/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.oracle;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.base.BaseXADataSource;
import com.metamatrix.jdbcx.oracle.OracleImplXAResource;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class OracleDataSource
extends BaseXADataSource {
    private static String footprint = "$Revision:   3.16.2.2  $";
    String SID;
    String serviceName;
    String refCursorSupportString;
    String FetchTSWTZasTimestampString;
    String serverType;
    String codePageOverride = "";
    String tnsNamesFile;
    String tnsServerName;
    String sendFloatParametersAsString;
    String supportLinks;
    boolean enableCancelTimeout;
    String authenticationMethod = "auto";
    String sysLoginRole = "";
    int wireProtocolMode = 1;
    int catalogOptions = 2;
    boolean ignoreCatalogIncludesSynonymsSetting = false;

    public final boolean getEnableCancelTimeout() {
        return this.enableCancelTimeout;
    }

    public int getPortNumber() {
        int n = super.getPortNumber();
        if (n == 0) {
            return 1521;
        }
        return n;
    }

    public String getSID() {
        return this.SID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getTNSServerName() {
        return this.tnsServerName;
    }

    public String getTNSNamesFile() {
        return this.tnsNamesFile;
    }

    public String getFetchTSWTZasTimestamp() {
        return this.FetchTSWTZasTimestampString;
    }

    public String getrefCursorSupport() {
        return this.refCursorSupportString;
    }

    public boolean getCatalogIncludesSynonyms() {
        return (this.catalogOptions & 2) > 0;
    }

    public int getCatalogOptions() {
        return this.catalogOptions;
    }

    public int getWireProtocolMode() {
        return this.wireProtocolMode;
    }

    public String getSendFloatParametersAsString() {
        return this.sendFloatParametersAsString;
    }

    public String getSupportLinks() {
        return this.supportLinks;
    }

    public void setSendFloatParametersAsString(String string) {
        this.sendFloatParametersAsString = string;
    }

    public void setSupportLinks(String string) {
        this.supportLinks = string;
    }

    public void setFetchTSWTZasTimestamp(String string) {
        this.FetchTSWTZasTimestampString = string;
    }

    public void setrefCursorSupport(String string) {
        this.refCursorSupportString = string;
    }

    public void setCatalogOptions(int n) {
        this.catalogOptions = n;
        this.ignoreCatalogIncludesSynonymsSetting = true;
    }

    public void setWireProtocolMode(int n) {
        this.wireProtocolMode = n;
    }

    public void setCatalogIncludesSynonyms(boolean bl) {
        if (!this.ignoreCatalogIncludesSynonymsSetting) {
            this.catalogOptions = bl ? 2 : 0;
        }
    }

    public String getCodePageOverride() {
        return this.codePageOverride;
    }

    public void setCodePageOverride(String string) {
        this.codePageOverride = string == null ? "" : string;
    }

    public final void setEnableCancelTimeout(boolean bl) {
        this.enableCancelTimeout = bl;
    }

    public void setSID(String string) {
        this.SID = string;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setServerType(String string) {
        this.serverType = string;
    }

    public void setTNSServerName(String string) {
        this.tnsServerName = string;
    }

    public void setTNSNamesFile(String string) {
        this.tnsNamesFile = string;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String string) {
        this.authenticationMethod = string == null ? "auto" : string;
    }

    public String getSysLoginRole() {
        return this.sysLoginRole;
    }

    public void setSysLoginRole(String string) {
        this.sysLoginRole = string == null ? "" : string;
    }

    protected void implAddProperties(Reference reference) {
        if (this.SID != null) {
            reference.add(new StringRefAddr("SID", this.SID));
        }
        if (this.serviceName != null) {
            reference.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.serverType != null) {
            reference.add(new StringRefAddr("serverType", this.serverType));
        }
        if (this.refCursorSupportString != null) {
            reference.add(new StringRefAddr("refCursorSupport", this.refCursorSupportString));
        }
        if (this.FetchTSWTZasTimestampString != null) {
            reference.add(new StringRefAddr("FetchTSWTZasTimestamp", this.FetchTSWTZasTimestampString));
        }
        if (this.tnsNamesFile != null) {
            reference.add(new StringRefAddr("TNSNamesFile", this.tnsNamesFile));
        }
        if (this.tnsServerName != null) {
            reference.add(new StringRefAddr("TNSServerName", this.tnsServerName));
        }
        if (this.codePageOverride != null) {
            reference.add(new StringRefAddr("codePageOverride", this.codePageOverride));
        }
        if (this.sendFloatParametersAsString != null) {
            reference.add(new StringRefAddr("sendFloatParametersAsString", this.sendFloatParametersAsString));
        }
        if (this.supportLinks != null) {
            reference.add(new StringRefAddr("supportLinks", this.supportLinks));
        }
        reference.add(new StringRefAddr("authenticationMethod", this.authenticationMethod));
        reference.add(new StringRefAddr("enableCancelTimeout", new Boolean(this.enableCancelTimeout).toString()));
        if (this.wireProtocolMode != 1) {
            reference.add(new StringRefAddr("wireProtocolMode", Integer.toString(this.wireProtocolMode)));
        }
        if (this.catalogOptions != 2) {
            reference.add(new StringRefAddr("catalogOptions", Integer.toString(this.catalogOptions)));
            reference.add(new StringRefAddr("CatalogIncludesSynonyms", "false"));
        }
        if (this.sysLoginRole != null) {
            reference.add(new StringRefAddr("sysLoginRole", this.sysLoginRole));
        }
    }

    protected String implGetPropertyNameValuePairs() throws SQLException {
        String string = null;
        if (this.SID != null) {
            string = "SID=" + this.SID;
        }
        if (this.serviceName != null) {
            string = string == null ? "serviceName=" + this.serviceName : string + ";serviceName=" + this.serviceName;
        }
        if (this.serverType != null) {
            string = string == null ? "serverType=" + this.serverType : string + ";serverType=" + this.serverType;
        }
        if (this.refCursorSupportString != null) {
            string = string == null ? "refCursorSupport=" + this.refCursorSupportString : string + ";refCursorSupport=" + this.refCursorSupportString;
        }
        if (this.FetchTSWTZasTimestampString != null) {
            string = string == null ? "FetchTSWTZasTimestamp=" + this.FetchTSWTZasTimestampString : string + ";FetchTSWTZasTimestamp=" + this.FetchTSWTZasTimestampString;
        }
        if (this.tnsServerName != null) {
            string = string == null ? "TNSServerName=" + this.tnsServerName : string + ";TNSServerName=" + this.tnsServerName;
        }
        if (this.tnsNamesFile != null) {
            string = string == null ? "TNSNamesFile=" + this.tnsNamesFile : string + ";TNSNamesFile=" + this.tnsNamesFile;
        }
        if (this.catalogOptions != 2) {
            string = string == null ? "CatalogIncludesSynonyms=" + ((this.catalogOptions & 2) > 0 ? "TRUE" : "FALSE") + ";catalogOptions=" + this.catalogOptions : string + ";CatalogIncludesSynonyms=" + ((this.catalogOptions & 2) > 0 ? "TRUE" : "FALSE") + ";catalogOptions=" + this.catalogOptions;
        }
        if (this.codePageOverride != null) {
            string = string == null ? "codePageOverride=" + this.codePageOverride : string + ";codePageOverride=" + this.codePageOverride;
        }
        string = string == null ? "enableCancelTimeout=" + this.enableCancelTimeout : string + ";enableCancelTimeout=" + this.enableCancelTimeout;
        string = string == null ? "authenticationMethod=" + this.authenticationMethod : string + ";authenticationMethod=" + this.authenticationMethod;
        if (this.sendFloatParametersAsString != null) {
            string = string == null ? "sendFloatParametersAsString=" + this.sendFloatParametersAsString : string + ";sendFloatParametersAsString=" + this.sendFloatParametersAsString;
        }
        if (this.supportLinks != null) {
            string = string == null ? "supportLinks=" + this.supportLinks : string + ";supportLinks=" + this.supportLinks;
        }
        if (this.wireProtocolMode != 1) {
            string = string == null ? "wireProtocolMode=" + this.wireProtocolMode : string + ";wireProtocolMode=" + this.wireProtocolMode;
        }
        if (this.sysLoginRole != null) {
            string = string == null ? "sysLoginRole=" + this.sysLoginRole : string + ";sysLoginRole=" + this.sysLoginRole;
        }
        return string;
    }

    protected BaseImplXAResource createImplXAResource(BaseConnection baseConnection) {
        return new OracleImplXAResource(baseConnection);
    }

    public String getAuthenticatedUser(String string) {
        if (this.authenticationMethod.equalsIgnoreCase("client")) {
            return System.getProperty("user.name");
        }
        return "";
    }
}

