/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.columns;

import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkStreamColumn;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.sequelink.ctxt.stmt.SequeLinkInputStream;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.slutil.UtilCharacterReaderToUCS2InputStream;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilPagedTempBuffer;
import com.metamatrix.slutil.UtilUCS2InputStreamToCharacterReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class SequeLinkLongvarcharColumn
extends SequeLinkStreamColumn {
    private UtilPagedTempBuffer temp;
    private boolean cached;
    private boolean cachedSQLNULL;

    public SequeLinkLongvarcharColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, 18);
    }

    protected void setBindInfo() {
        this.sqlnkType = 4;
        this.sqlnkSize = this.precision;
        if (this.maxFieldSize != 0) {
            this.sqlnkSize = Math.min(this.sqlnkSize, this.maxFieldSize);
        }
    }

    public int readLongData(SspInputStream sspInputStream, byte[] byArray, int n2, int n3) throws IOException {
        return sspInputStream.readSSPLongVarChar(byArray, n2, n3);
    }

    public BaseData getData(int n2, int n3, DiagnosticList diagnosticList) throws SQLException {
        Closeable closeable;
        int n4;
        if (this.cached) {
            n4 = 18;
            closeable = this.cachedSQLNULL ? null : new UtilUCS2InputStreamToCharacterReader(this.temp.getInputStream());
            this.cached = false;
        } else {
            try {
                switch (n2) {
                    case 10: 
                    case 18: {
                        closeable = this.getCharacterStream(diagnosticList);
                        n4 = 18;
                        break;
                    }
                    default: {
                        closeable = this.getAsciiStream(diagnosticList);
                        n4 = 15;
                        break;
                    }
                }
            }
            catch (UtilException utilException) {
                SQLException sQLException = Message.Gen.getSqlException(7452);
                Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                throw sQLException;
            }
        }
        if (n4 == 18) {
            this.myBaseData.setCharacterStreamReader((Reader)closeable);
        } else {
            this.myBaseData.setASCIIStream((InputStream)closeable);
        }
        return this.myBaseData;
    }

    public void cacheData(int n2, DiagnosticList diagnosticList) throws SQLException {
        Reader reader;
        try {
            reader = this.getCharacterStream(diagnosticList);
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
        if (reader == null) {
            this.cachedSQLNULL = true;
        } else {
            UtilCharacterReaderToUCS2InputStream utilCharacterReaderToUCS2InputStream = new UtilCharacterReaderToUCS2InputStream(reader);
            this.cachedSQLNULL = false;
            if (this.temp == null) {
                this.temp = new UtilPagedTempBuffer(2048);
            }
            byte[] byArray = new byte[1024];
            int n3 = 0;
            int n4 = 0;
            try {
                while (n3 != -1) {
                    n3 = utilCharacterReaderToUCS2InputStream.read(byArray);
                    if (n3 == -1) continue;
                    this.temp.write(n4, byArray, 0, n3);
                    n4 += n3;
                }
                ((InputStream)utilCharacterReaderToUCS2InputStream).close();
                reader.close();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            catch (UtilException utilException) {
                throw new SQLException(utilException.toString());
            }
        }
        this.cached = true;
    }

    private InputStream getAsciiStream(DiagnosticList diagnosticList) throws SQLException, UtilException {
        SequeLinkInputStream sequeLinkInputStream = new SequeLinkInputStream(this, diagnosticList);
        if (sequeLinkInputStream.isNull()) {
            return null;
        }
        return this.ut.decodeAsAsciiStream(sequeLinkInputStream);
    }

    private Reader getCharacterStream(DiagnosticList diagnosticList) throws SQLException, UtilException {
        SequeLinkInputStream sequeLinkInputStream = new SequeLinkInputStream(this, diagnosticList);
        if (sequeLinkInputStream.isNull()) {
            return null;
        }
        return this.ut.decodeAsReader(sequeLinkInputStream);
    }

    public void clearCache() {
        this.cached = false;
        this.cachedSQLNULL = false;
        if (this.temp != null) {
            try {
                this.temp.truncate();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
        }
    }

    public void cleanUp() {
        if (this.temp != null) {
            try {
                this.temp.truncate(true);
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            this.temp = null;
        }
    }
}

