/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcsnoop;

import com.metamatrix.jdbcsnoop.SnoopInputStream;
import com.metamatrix.jdbcsnoop.SnoopOutputStream;
import com.metamatrix.jdbcsnoop.SnoopScope;
import com.metamatrix.jdbcsnoop.SnoopStreamFixupRecord;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;

public class SnoopSocket
extends Socket {
    private static String footprint = "$Revision:   1.2.1.0  $";
    InputStream realInputStream;
    OutputStream realOutputStream;
    private SnoopInputStream snoopInputStream;
    private SnoopOutputStream snoopOutputStream;
    private Socket realSocket;
    private PrintStream logStream;
    static final int SNOOP_NONE = 0;
    static final int SNOOP_SEND = 1;
    static final int SNOOP_READ = 2;
    private int logType = 0;
    private boolean showEBCDIC = false;
    private StringBuffer maxBytesBuffer;
    private int maxBytesInFile;
    private int currentBytesInFile;
    private int maxBytesInLine = 8;
    private int numBytesInLine;
    private int numBytesProcessed;
    private byte[] line;
    private LinkedList sendStreamFixupInfo;
    private int currentSendStreamIndex;
    private int sendStreamSkipBytes;
    private boolean timestamp = false;
    private static char[] hex_map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    SnoopScope snoopScope;

    public SnoopSocket(Socket socket, Properties properties) throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        this.realSocket = socket;
        String string5 = properties.getProperty("DDTDBG.PROTOCOLTRACELOCATION");
        if (string5 == null) {
            string5 = SnoopSocket.getSystemProperty("java.io.tmpdir");
        }
        String string6 = properties.getProperty("DDTDBG.PROTOCOLTRACEPREFIX");
        String string7 = properties.getProperty("DDTDBG.PROTOCOLTRACESHOWTIME");
        if (string7 != null) {
            try {
                this.timestamp = Boolean.valueOf(string7);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string4 = properties.getProperty("DDTDBG.PROTOCOLTRACEMAXBYTES")) != null) {
            try {
                this.maxBytesInFile = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string3 = properties.getProperty("DDTDBG.PROTOCOLTRACEMAXLINE")) != null) {
            try {
                this.maxBytesInLine = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string2 = properties.getProperty("DDTDBG.PROTOCOLTRACEEBCDIC")) != null) {
            try {
                if (string2.equalsIgnoreCase("true")) {
                    this.showEBCDIC = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.maxBytesInFile > 0) {
            this.maxBytesBuffer = new StringBuffer();
        }
        String string8 = properties.getProperty("DDTDBG.PROTOCOLTRACESCOPE");
        String string9 = properties.getProperty("DDTDBG.PROTOCOLTRACESCOPEEXIT");
        if (string8 != null) {
            try {
                if (Boolean.valueOf(string8).booleanValue()) {
                    this.snoopScope = SnoopScope.start(Boolean.valueOf(string9));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = properties.getProperty("DDTDBG.PROTOCOLTRACEFILE")) != null) {
            try {
                if (Boolean.valueOf(string).booleanValue()) {
                    this.logStream = SnoopSocket.getLogWriter(string5, string6);
                }
            }
            catch (Exception exception) {}
        } else {
            this.logStream = SnoopSocket.getLogWriter(string5, string6);
        }
        this.line = new byte[this.maxBytesInLine];
        this.realInputStream = socket.getInputStream();
        this.realOutputStream = socket.getOutputStream();
        this.snoopOutputStream = new SnoopOutputStream(this);
        this.snoopInputStream = new SnoopInputStream(this);
    }

    static PrintStream getLogWriter(String string, String string2) throws IOException {
        File file;
        String string3 = string;
        if (string2 != null) {
            string3 = string3 + string2 + "_";
        }
        int n = 0;
        while ((file = new File(string3 + Integer.toString(n) + ".txt")).exists()) {
            ++n;
        }
        return new PrintStream(new FileOutputStream(file));
    }

    static String getSystemProperty(String string) {
        String string2 = null;
        final String string3 = string;
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string3);
            }
        };
        try {
            string2 = (String)AccessController.doPrivileged(privilegedAction);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public synchronized void cleanup() {
        this.finishLastLog(true);
        this.flushMaxBytesBuffer();
        if (this.logStream != null) {
            this.logStream.close();
        }
        this.logStream = null;
    }

    public synchronized void close() throws IOException {
        this.cleanup();
        this.realSocket.close();
    }

    public synchronized void doNotLogBytesInSendStream(int n, int n2, String string) {
        if (this.sendStreamFixupInfo == null) {
            this.sendStreamFixupInfo = new LinkedList();
        }
        SnoopStreamFixupRecord snoopStreamFixupRecord = new SnoopStreamFixupRecord();
        snoopStreamFixupRecord.type = 1;
        snoopStreamFixupRecord.offset = n;
        snoopStreamFixupRecord.length = n2;
        snoopStreamFixupRecord.text = string;
        snoopStreamFixupRecord.resetByteCount = false;
        this.sendStreamFixupInfo.addLast(snoopStreamFixupRecord);
    }

    public synchronized void addTextToSendStream(int n, String string, boolean bl) {
        if (this.sendStreamFixupInfo == null) {
            this.sendStreamFixupInfo = new LinkedList();
        }
        SnoopStreamFixupRecord snoopStreamFixupRecord = new SnoopStreamFixupRecord();
        snoopStreamFixupRecord.type = 2;
        snoopStreamFixupRecord.offset = n;
        snoopStreamFixupRecord.text = string;
        snoopStreamFixupRecord.resetByteCount = bl;
        this.sendStreamFixupInfo.addLast(snoopStreamFixupRecord);
    }

    public InputStream getInputStream() throws IOException {
        return this.snoopInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.snoopOutputStream;
    }

    synchronized void logBytes(int n, byte[] byArray, int n2, int n3) {
        if (n != this.logType) {
            if (this.logType != 0) {
                this.finishLastLog(true);
            }
            if (n == 1) {
                this.println("Send :");
                this.currentSendStreamIndex = 0;
            } else {
                this.println("Receive :");
            }
            if (this.timestamp) {
                Date date = new Date(System.currentTimeMillis());
                this.println(date.toString() + " : " + date.getTime());
            }
            this.logType = n;
        }
        for (int i = 0; i < n3; ++i) {
            if (this.logType == 1 && this.sendStreamFixupInfo != null && !this.sendStreamFixupInfo.isEmpty()) {
                SnoopStreamFixupRecord snoopStreamFixupRecord = (SnoopStreamFixupRecord)this.sendStreamFixupInfo.getFirst();
                if (snoopStreamFixupRecord.offset == this.currentSendStreamIndex) {
                    if (snoopStreamFixupRecord.text != null) {
                        this.finishLastLog(snoopStreamFixupRecord.resetByteCount && this.currentSendStreamIndex > 0);
                        this.print(snoopStreamFixupRecord.text);
                        if (this.numBytesInLine > 0) {
                            this.println(" (at offset " + this.numBytesInLine + ")");
                        } else {
                            this.println("");
                        }
                    }
                    if (snoopStreamFixupRecord.type == 1) {
                        this.sendStreamSkipBytes = snoopStreamFixupRecord.length;
                    }
                    this.sendStreamFixupInfo.removeFirst();
                }
            }
            if (this.sendStreamSkipBytes == 0) {
                this.line[this.numBytesInLine++] = byArray[n2 + i];
                if (this.numBytesInLine == this.maxBytesInLine) {
                    this.printLine();
                }
                ++this.numBytesProcessed;
            } else {
                --this.sendStreamSkipBytes;
            }
            ++this.currentSendStreamIndex;
        }
        if (this.logStream != null) {
            this.logStream.flush();
        }
    }

    private void finishLastLog(boolean bl) {
        if (this.logType != 0) {
            if (this.numBytesInLine > 0) {
                this.printLine();
            }
            if (bl) {
                this.print("Bytes ");
                if (this.logType == 1) {
                    this.print("Sent : ");
                } else {
                    this.print("Received : ");
                }
                this.println(Integer.toString(this.numBytesProcessed));
                this.numBytesProcessed = 0;
                this.println("");
            }
        }
        this.flushPrints();
    }

    synchronized void attemptingRead() {
        if (this.logType != 2) {
            this.finishLastLog(true);
            this.logType = 0;
        }
    }

    private void printLine() {
        int n;
        for (n = 0; n < this.numBytesInLine; ++n) {
            char[] cArray = SnoopSocket.byteToHex(this.line[n]);
            this.print(Character.toString(cArray[0]));
            this.print(Character.toString(cArray[1]));
            this.print(" ");
        }
        for (n = 0; n < this.maxBytesInLine - this.numBytesInLine; ++n) {
            this.print("   ");
        }
        this.print("    ");
        for (n = 0; n < this.numBytesInLine; ++n) {
            this.print(Character.toString(SnoopSocket.byteToASCII(this.line[n])));
        }
        if (this.showEBCDIC) {
            for (n = 0; n < this.maxBytesInLine - this.numBytesInLine; ++n) {
                this.print(" ");
            }
            this.print("    ");
            for (n = 0; n < this.numBytesInLine; ++n) {
                this.print(Character.toString(SnoopSocket.eByteToASCII(this.line[n])));
            }
        }
        this.println("");
        this.flushPrints();
        this.numBytesInLine = 0;
    }

    private void print(String string) {
        if (this.maxBytesBuffer == null) {
            if (this.logStream != null) {
                this.logStream.print(string);
            }
        } else {
            this.maxBytesBuffer.append(string);
        }
        if (this.snoopScope != null) {
            this.snoopScope.print(string);
        }
    }

    private void println(String string) {
        if (this.maxBytesBuffer == null) {
            if (this.logStream != null) {
                this.logStream.println(string);
            }
        } else {
            this.print(string);
            this.print("\r\n");
        }
        if (this.snoopScope != null) {
            this.snoopScope.println(string);
        }
    }

    private void flushPrints() {
        if (this.maxBytesBuffer == null) {
            if (this.logStream != null) {
                this.logStream.flush();
            }
        } else {
            int n = this.maxBytesBuffer.length();
            if (n > this.maxBytesInFile) {
                String string = this.maxBytesBuffer.substring(n - this.maxBytesInFile, n);
                this.maxBytesBuffer.setLength(0);
                this.maxBytesBuffer.append(string);
            }
        }
    }

    private void flushMaxBytesBuffer() {
        if (this.maxBytesBuffer != null) {
            this.print(this.maxBytesBuffer.toString());
        }
    }

    private static char[] byteToHex(byte by) {
        char[] cArray = new char[]{hex_map[by >> 4 & 0xF], hex_map[by & 0xF]};
        return cArray;
    }

    private static char byteToASCII(byte by) {
        if (by > 31 && by < 127) {
            return (char)by;
        }
        return '.';
    }

    private static char eByteToASCII(byte by) {
        int n = 0xFF & by;
        if (n >= 129 && n <= 137) {
            return (char)(97 + (n - 129));
        }
        if (n >= 145 && n <= 153) {
            return (char)(106 + (n - 145));
        }
        if (n >= 162 && n <= 169) {
            return (char)(115 + (n - 162));
        }
        if (n >= 193 && n <= 201) {
            return (char)(65 + (n - 193));
        }
        if (n >= 209 && n <= 217) {
            return (char)(74 + (n - 209));
        }
        if (n >= 226 && n <= 233) {
            return (char)(83 + (n - 226));
        }
        if (n >= 240 && n <= 249) {
            return (char)(48 + (n - 240));
        }
        switch (n) {
            case 64: {
                return ' ';
            }
            case 76: {
                return '<';
            }
            case 77: {
                return '(';
            }
            case 78: {
                return '+';
            }
            case 79: {
                return '|';
            }
            case 80: {
                return '&';
            }
            case 90: {
                return '!';
            }
            case 91: {
                return '$';
            }
            case 92: {
                return '*';
            }
            case 93: {
                return ')';
            }
            case 94: {
                return ';';
            }
            case 96: {
                return '-';
            }
            case 97: {
                return '/';
            }
            case 107: {
                return ',';
            }
            case 108: {
                return '%';
            }
            case 109: {
                return '_';
            }
            case 110: {
                return '>';
            }
            case 111: {
                return '?';
            }
            case 122: {
                return ':';
            }
            case 123: {
                return '#';
            }
            case 124: {
                return '@';
            }
            case 125: {
                return '\'';
            }
            case 126: {
                return '=';
            }
            case 127: {
                return '\"';
            }
            case 185: {
                return '`';
            }
        }
        return '.';
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.realSocket.bind(socketAddress);
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.realSocket.connect(socketAddress);
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        this.realSocket.connect(socketAddress, n);
    }

    public InetAddress getInetAddress() {
        return this.realSocket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.realSocket.getLocalAddress();
    }

    public int getPort() {
        return this.realSocket.getPort();
    }

    public int getLocalPort() {
        return this.realSocket.getLocalPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.realSocket.getRemoteSocketAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.realSocket.getLocalSocketAddress();
    }

    public SocketChannel getChannel() {
        return this.realSocket.getChannel();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.realSocket.setTcpNoDelay(bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.realSocket.getTcpNoDelay();
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.realSocket.setSoLinger(bl, n);
    }

    public int getSoLinger() throws SocketException {
        return this.realSocket.getSoLinger();
    }

    public void sendUrgentData(int n) throws IOException {
        this.realSocket.sendUrgentData(n);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.realSocket.setOOBInline(bl);
    }

    public boolean getOOBInline() throws SocketException {
        return this.realSocket.getOOBInline();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.realSocket.setSoTimeout(n);
    }

    public int getSoTimeout() throws SocketException {
        return this.realSocket.getSoTimeout();
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.realSocket.setSendBufferSize(n);
    }

    public int getSendBufferSize() throws SocketException {
        return this.realSocket.getSendBufferSize();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.realSocket.setReceiveBufferSize(n);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.realSocket.getReceiveBufferSize();
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.realSocket.setKeepAlive(bl);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.realSocket.getKeepAlive();
    }

    public void setTrafficClass(int n) throws SocketException {
        this.realSocket.setTrafficClass(n);
    }

    public int getTrafficClass() throws SocketException {
        return this.realSocket.getTrafficClass();
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.realSocket.setReuseAddress(bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.realSocket.getReuseAddress();
    }

    public void shutdownInput() throws IOException {
        this.realSocket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.realSocket.shutdownOutput();
    }

    public String toString() {
        return this.realSocket.toString();
    }

    public boolean isConnected() {
        return this.realSocket.isConnected();
    }

    public boolean isBound() {
        return this.realSocket.isBound();
    }

    public boolean isClosed() {
        return this.realSocket.isClosed();
    }

    public boolean isInputShutdown() {
        return this.realSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.realSocket.isOutputShutdown();
    }
}

