/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ssl;

import iaik.asn1.structures.Name;
import iaik.security.dh.DHPrivateKey;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.security.rsa.RSAPublicKey;
import iaik.security.ssl.SecurityProvider;
import iaik.security.ssl.p;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.Key;
import java.security.Principal;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class IaikProvider
extends SecurityProvider {
    private boolean b;
    private double a;
    private static final double d = 2.5100000000000002;
    private static final String c = "IAIK";

    protected java.security.cert.X509Certificate getX509Certificate(byte[] byArray) throws CertificateException {
        return new X509Certificate(byArray);
    }

    protected String[] getTLSServerName(java.security.cert.X509Certificate x509Certificate) {
        if (!(x509Certificate instanceof X509Certificate)) {
            try {
                x509Certificate = this.getX509Certificate(x509Certificate.getEncoded());
            }
            catch (Exception exception) {
                return new String[0];
            }
        }
        return p.a((X509Certificate)x509Certificate);
    }

    protected Signature getSignature(String string, int n2, Key key, SecureRandom secureRandom) throws Exception {
        if (string.equals("MD5withRSA")) {
            string = "MD5WithRSA";
        }
        return super.getSignature(string, n2, key, secureRandom);
    }

    protected SecureRandom getSecureRandom() {
        return SecRandom.getDefault();
    }

    protected java.security.interfaces.RSAPublicKey getRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        return new RSAPublicKey(bigInteger, bigInteger2);
    }

    protected Principal getPrincipal(byte[] byArray) throws Exception {
        return new Name(byArray);
    }

    protected byte[] getEncodedPrincipal(Principal principal) {
        return ((Name)principal).getEncoded();
    }

    protected DHPublicKey getDHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return new iaik.security.dh.DHPublicKey(new DHPublicKeySpec(bigInteger, bigInteger2, bigInteger3));
    }

    protected javax.crypto.interfaces.DHPrivateKey getDHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return new DHPrivateKey(new DHPrivateKeySpec(bigInteger, bigInteger2, bigInteger3));
    }

    protected Cipher getCipher(String string, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws Exception {
        if (string.equals("RSA/ECB/PKCS1PaddingSSL2")) {
            if (this.a < 2.59) {
                string = "RSA/ECB/PKCS1Padding";
            }
        } else if (string.startsWith("RSA/ECB/PKCS1Padding")) {
            string = "RSA/ECB/PKCS1Padding";
        }
        Cipher cipher = Cipher.getInstance(string, c);
        if (n2 != SecurityProvider.CIPHER_NONE) {
            int n3 = n2 == SecurityProvider.CIPHER_ENCRYPT ? 1 : 2;
            cipher.init(n3, key, algorithmParameterSpec, secureRandom);
        }
        return cipher;
    }

    public IaikProvider() {
        super(c);
        Provider provider;
        if (Security.getProvider(c) == null) {
            IAIK.addAsProvider((boolean)false);
        }
        if ((provider = Security.getProvider(c)) == null) {
            String string = "Could not add IAIK provider!";
            System.err.println(string);
            throw new RuntimeException(string);
        }
        this.a = provider.getVersion();
        if (this.a < 2.5099) {
            System.err.println("WARNING: This version of iSaSiLk should only be used with IAIK JCE");
            System.err.println("WARNING: version " + 2.5100000000000002 + " and later! You are using IAIK JCE " + this.a + ".");
        }
    }
}

