/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.informix.InformixColumn;
import com.metamatrix.jdbc.informix.InformixImplConnection;
import com.metamatrix.jdbc.informix.InformixImplResultSet;
import com.metamatrix.jdbc.informix.InformixParameter;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICursorRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIExecuteRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIProcedureRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIRequest;
import java.sql.SQLException;

public class InformixImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   3.10.1.1  $";
    private int stmtId = -1;
    private int stmtType = 0;
    private boolean isPrepared = false;
    private String preparedSql = "";
    private String nativeSql = "";
    private int resultType = 0;
    private int numRows = 0;
    private int numInputs = 0;
    InformixImplConnection implConnection = null;
    InformixSQLICommunication comm = null;
    InformixSQLIRequest request = null;
    private int resultSetType;
    private int resultSetConcurrency;
    private Integer generatedValueForSerialColumn;
    private Long generatedValueForSerial8Column;
    private BaseColumns autoGenKeysColDescriptions = null;

    InformixImplStatement(InformixImplConnection informixImplConnection, InformixSQLICommunication informixSQLICommunication, int n, int n2) {
        this.implConnection = informixImplConnection;
        this.comm = informixSQLICommunication;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
    }

    public void prepare() throws SQLException {
        this.isPrepared = true;
        if (this.request != null) {
            this.request.closeStatement();
            this.request = null;
        }
        this.nativeSql = this.sql.getFormatted();
        if (this.nativeSql.equals(this.preparedSql)) {
            return;
        }
        this.numInputs = this.sql.getParameterCount();
        this.preparedSql = this.nativeSql;
        this.resultType = 3;
        if (this.sql.getType() == 1) {
            this.request = new InformixSQLICursorRequest(this.comm, this, this.preparedSql, this.resultSetType, this.resultSetConcurrency);
            ((InformixSQLICursorRequest)this.request).setInputParameterCount(this.numInputs);
            this.request.setFetchSize(this.fetchSize);
            ((InformixSQLICursorRequest)this.request).prepare();
            if (this.request.getNumberOfColumns() > 0) {
                this.resultType = 2;
            }
        } else if (this.sql.getType() == 3 || this.sql.getVerb().toLowerCase().equals("execute")) {
            this.request = new InformixSQLIProcedureRequest(this.comm, this, this.preparedSql, this.resultSetType, this.resultSetConcurrency);
            ((InformixSQLIProcedureRequest)this.request).setInputParameterCount(this.numInputs);
            this.request.setFetchSize(this.fetchSize);
            ((InformixSQLIProcedureRequest)this.request).prepare();
            if (this.request.getNumberOfColumns() > 0) {
                this.resultType = 2;
            }
        } else {
            this.request = new InformixSQLIExecuteRequest(this.comm, this, this.preparedSql);
            ((InformixSQLIExecuteRequest)this.request).setInputParameterCount(this.numInputs);
            this.request.setFetchSize(this.fetchSize);
            ((InformixSQLIExecuteRequest)this.request).prepare();
        }
    }

    public void execute() throws SQLException {
        InformixImplConnection informixImplConnection = this.implConnection;
        if (this.isPrepared) {
            if (this.numInputs > 0) {
                BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
                InformixParameter[] informixParameterArray = InformixParameter.prepareParamData(baseParameters, this.request.columns, this.stmtType, this.comm.getImplConnection().versionNumber, this.comm.exceptions, this.comm.warnings);
                this.request.setInputParameters(informixParameterArray);
            }
            this.resultType = 3;
            if (this.sql.getType() == 1) {
                if (this.request.getNumberOfColumns() > 0) {
                    ((InformixSQLICursorRequest)this.request).openPreparedCursor();
                    this.resultType = 2;
                } else {
                    this.request.executePrepared();
                }
            } else if (this.sql.getType() == 3 || this.sql.getVerb().toLowerCase().equals("execute")) {
                this.request.executePrepared();
                if (this.request.getNumberOfColumns() > 0) {
                    this.resultType = 2;
                }
            } else {
                this.request.executePrepared();
            }
        } else {
            if (this.request != null) {
                this.request.closeStatement();
                this.request = null;
            }
            this.nativeSql = this.processSQL();
            this.resultType = 3;
            if (this.sql.getType() == 1) {
                this.request = new InformixSQLICursorRequest(this.comm, this, this.nativeSql, this.resultSetType, this.resultSetConcurrency);
                this.request.setFetchSize(this.fetchSize);
                ((InformixSQLICursorRequest)this.request).openCursor();
                if (this.request.getNumberOfColumns() > 0) {
                    this.resultType = 2;
                }
            } else if (this.sql.getType() == 3 || this.sql.getVerb().toLowerCase().equals("execute")) {
                this.request = new InformixSQLICursorRequest(this.comm, this, this.nativeSql, this.resultSetType, this.resultSetConcurrency);
                this.request.setFetchSize(this.fetchSize);
                this.request.prepare();
                if (this.request.getNumberOfColumns() > 0) {
                    this.resultType = 2;
                    ((InformixSQLICursorRequest)this.request).openCursor();
                } else {
                    this.request.executePrepared();
                }
            } else {
                this.request = new InformixSQLIExecuteRequest(this.comm, this, this.nativeSql);
                this.request.setFetchSize(this.fetchSize);
                this.request.execute();
            }
        }
    }

    private String processSQL() throws SQLException {
        String string = this.sql.getFormatted();
        return string;
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        if (this.databaseMetaDataResultSet != 0) {
            return baseColumns;
        }
        if (this.stmtType == 6 || this.stmtType == 33 || this.stmtType == 4) {
            return null;
        }
        if (this.request == null) {
            return null;
        }
        return this.request.columns;
    }

    public void describeParameters(BaseParameters baseParameters) throws SQLException {
        BaseColumns baseColumns;
        int n;
        int n2 = 1;
        if ((this.stmtType == 6 || this.stmtType == 33 || this.stmtType == 4) && (n = (baseColumns = this.request.columns).count(0)) == this.sql.getParameterCount()) {
            while (n2 <= n) {
                BaseColumn baseColumn = baseColumns.get(n2);
                BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
                baseParameterInfo.setType(baseColumn.type);
                baseParameterInfo.signed = baseColumn.isSigned;
                baseParameterInfo.nullable = baseColumn.isNullable;
                baseParameterInfo.precision = baseColumn.precision;
                baseParameterInfo.scale = baseColumn.scale;
                baseParameterInfo.nativeTypeName = baseColumn.typeName;
                baseParameterInfo.mode = 1;
                baseParameters.setParameterInfo(n2 - 1, baseParameterInfo);
                ++n2;
            }
        }
    }

    public BaseImplResultSet getNextResultSet() throws SQLException {
        InformixImplResultSet informixImplResultSet = new InformixImplResultSet(this.request, this.resultSetType, this.resultSetConcurrency);
        return informixImplResultSet;
    }

    public int getNextResultType() throws SQLException {
        int n;
        block3: {
            n = this.resultType;
            this.resultType = 1;
            if (!this.autoGeneratedKeysRequested) break block3;
            try {
                InformixSQLICursorRequest informixSQLICursorRequest = new InformixSQLICursorRequest(this.comm, null, "select count(*), dbinfo('sqlca.sqlerrd1'), dbinfo('serial8') from informix.systables", 1003, 1007);
                informixSQLICursorRequest.openCursor();
                if (informixSQLICursorRequest.fetch()) {
                    informixSQLICursorRequest.buildRow();
                    InformixColumn informixColumn = (InformixColumn)informixSQLICursorRequest.columns.get(2);
                    this.generatedValueForSerialColumn = (Integer)informixColumn.data;
                    informixColumn = (InformixColumn)informixSQLICursorRequest.columns.get(3);
                    this.generatedValueForSerial8Column = (Long)informixColumn.data;
                    this.autoGenKeysColDescriptions = informixSQLICursorRequest.columns;
                    informixSQLICursorRequest.closeCursor();
                }
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public int getNextRowsAffectedCount() throws SQLException {
        if (this.request != null && this.stmtType != 2) {
            return this.request.getRowsAffected();
        }
        return -1;
    }

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        BaseColumns baseColumns = null;
        BaseColumn baseColumn = null;
        if (this.generatedValueForSerialColumn.longValue() != 0L) {
            baseColumns = new BaseColumns();
            baseColumn = this.autoGenKeysColDescriptions.get(2);
            baseColumn.label = "SERIAL_COL";
            baseColumn.name = "SERIAL_COL";
            baseColumns.add(baseColumn);
        }
        if (this.generatedValueForSerial8Column != 0L) {
            baseColumn = this.autoGenKeysColDescriptions.get(3);
            baseColumn.label = "SERIAL8_COL";
            baseColumn.name = "SERIAL8_COL";
            if (baseColumns == null) {
                baseColumns = new BaseColumns();
            }
            baseColumns.add(baseColumn);
        }
        return baseColumns;
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        return new InformixAutoGeneratedKeyResultSet();
    }

    public void close() throws SQLException {
        if (this.request != null) {
            this.request.closeStatement();
        }
        this.preparedSql = "";
    }

    private boolean isAutoCommit() {
        return this.implConnection.isAutoCommit;
    }

    private boolean isQuery() {
        return this.sql.getType() == 1;
    }

    public int getStatementId() {
        return this.stmtId;
    }

    public void setStatementId(int n) {
        this.stmtId = n;
    }

    public int getStatementType() {
        return this.stmtType;
    }

    public void setStatementType(int n) {
        this.stmtType = n;
    }

    public String getRowIdColumnName() {
        return "rowid";
    }

    public boolean supportsDefaultKeyword() {
        return false;
    }

    public void setSQL(BaseSQL baseSQL) {
        super.setSQL(baseSQL);
        this.isPrepared = false;
    }

    class InformixAutoGeneratedKeyResultSet
    extends BaseImplResultSet {
        boolean returnedTheRow = false;

        InformixAutoGeneratedKeyResultSet() {
        }

        public boolean fetchAtPosition(int n) throws SQLException {
            if (this.returnedTheRow) {
                return false;
            }
            this.returnedTheRow = true;
            return true;
        }

        public BaseData getData(int n, int n2) throws SQLException {
            if (n == 1 && InformixImplStatement.this.generatedValueForSerialColumn.longValue() != 0L) {
                return new BaseData(4, InformixImplStatement.this.generatedValueForSerialColumn, InformixImplStatement.this.implConnection.connection);
            }
            return new BaseData(5, InformixImplStatement.this.generatedValueForSerial8Column, InformixImplStatement.this.implConnection.connection);
        }

        public void close() throws SQLException {
        }
    }
}

