/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.osgi.framework.adaptor.core.StateManager;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public abstract class StateImpl
implements State {
    public static final String[] PROPS = new String[]{"osgi.os", "osgi.ws", "osgi.nl", "osgi.arch", "org.osgi.framework.system.packages", "osgi.resolverMode"};
    private transient Resolver resolver;
    private transient StateDeltaImpl changes;
    private transient boolean resolving = false;
    private transient HashSet removalPendings = new HashSet();
    private boolean resolved = true;
    private long timeStamp = System.currentTimeMillis();
    private KeyedHashSet bundleDescriptions = new KeyedHashSet(false);
    private StateObjectFactory factory;
    private KeyedHashSet resolvedBundles = new KeyedHashSet();
    boolean fullyLoaded = false;
    private StateReader reader;
    private Dictionary[] platformProperties = new Dictionary[]{new Hashtable(PROPS.length)};
    private ExportPackageDescription[] systemExports = new ExportPackageDescription[0];
    private static long cumulativeTime;

    protected StateImpl() {
    }

    public boolean addBundle(BundleDescription description) {
        if (!this.basicAddBundle(description)) {
            return false;
        }
        this.resolved = false;
        this.getDelta().recordBundleAdded((BundleDescriptionImpl)description);
        if (this.resolver != null) {
            this.resolver.bundleAdded(description);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBundle(BundleDescription newDescription) {
        BundleDescriptionImpl existing = (BundleDescriptionImpl)this.bundleDescriptions.get((BundleDescriptionImpl)newDescription);
        if (existing == null) {
            return false;
        }
        if (!this.bundleDescriptions.remove(existing)) {
            return false;
        }
        this.resolvedBundles.remove(existing);
        if (!this.basicAddBundle(newDescription)) {
            return false;
        }
        this.resolved = false;
        this.getDelta().recordBundleUpdated((BundleDescriptionImpl)newDescription);
        if (this.resolver != null) {
            boolean pending = existing.getDependents().length > 0;
            this.resolver.bundleUpdated(newDescription, existing, pending);
            if (pending) {
                this.getDelta().recordBundleRemovalPending(existing);
                this.removalPendings.add(existing);
            } else {
                StateImpl stateImpl = this;
                synchronized (stateImpl) {
                    try {
                        this.resolving = true;
                        this.resolveBundle(existing, false, null, null, null, null);
                    }
                    finally {
                        this.resolving = false;
                    }
                }
            }
        }
        return true;
    }

    public BundleDescription removeBundle(long bundleId) {
        BundleDescription toRemove = this.getBundle(bundleId);
        if (toRemove == null || !this.removeBundle(toRemove)) {
            return null;
        }
        return toRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBundle(BundleDescription toRemove) {
        if (!this.bundleDescriptions.remove((KeyedElement)((Object)toRemove))) {
            return false;
        }
        this.resolvedBundles.remove((KeyedElement)((Object)toRemove));
        this.resolved = false;
        this.getDelta().recordBundleRemoved((BundleDescriptionImpl)toRemove);
        if (this.resolver != null) {
            boolean pending = toRemove.getDependents().length > 0;
            this.resolver.bundleRemoved(toRemove, pending);
            if (pending) {
                this.getDelta().recordBundleRemovalPending((BundleDescriptionImpl)toRemove);
                this.removalPendings.add(toRemove);
            } else {
                StateImpl stateImpl = this;
                synchronized (stateImpl) {
                    try {
                        this.resolving = true;
                        this.resolveBundle(toRemove, false, null, null, null, null);
                    }
                    finally {
                        this.resolving = false;
                    }
                }
            }
        }
        return true;
    }

    public StateDelta getChanges() {
        return this.getDelta();
    }

    private StateDeltaImpl getDelta() {
        if (this.changes == null) {
            this.changes = new StateDeltaImpl(this);
        }
        return this.changes;
    }

    public BundleDescription[] getBundles(String symbolicName) {
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>();
        Iterator iter = this.bundleDescriptions.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            if (!symbolicName.equals(bundle.getSymbolicName())) continue;
            bundles.add(bundle);
        }
        return bundles.toArray(new BundleDescription[bundles.size()]);
    }

    public BundleDescription[] getBundles() {
        return (BundleDescription[])this.bundleDescriptions.elements(new BundleDescription[this.bundleDescriptions.size()]);
    }

    public BundleDescription getBundle(long id) {
        BundleDescription result = (BundleDescription)((Object)this.bundleDescriptions.getByKey(new Long(id)));
        if (result != null) {
            return result;
        }
        for (BundleDescription removedBundle : this.removalPendings) {
            if (removedBundle.getBundleId() != id) continue;
            return removedBundle;
        }
        return null;
    }

    public BundleDescription getBundle(String name, Version version) {
        BundleDescription[] allBundles = this.getBundles(name);
        if (allBundles.length == 1) {
            return version == null || allBundles[0].getVersion().equals(version) ? allBundles[0] : null;
        }
        if (allBundles.length == 0) {
            return null;
        }
        BaseDescription unresolvedFound = null;
        BaseDescription resolvedFound = null;
        for (int i = 0; i < allBundles.length; ++i) {
            BundleDescription current = allBundles[i];
            BaseDescription base = current.isResolved() ? resolvedFound : unresolvedFound;
            if (version != null && !current.getVersion().equals(version)) continue;
            if (base != null && (base.getVersion().compareTo(current.getVersion()) <= 0 || base.getBundleId() > current.getBundleId())) {
                if (base == resolvedFound) {
                    resolvedFound = current;
                    continue;
                }
                unresolvedFound = current;
                continue;
            }
            if (current.isResolved()) {
                resolvedFound = current;
                continue;
            }
            unresolvedFound = current;
        }
        if (resolvedFound != null) {
            return resolvedFound;
        }
        return unresolvedFound;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isResolved() {
        return this.resolved || this.isEmpty();
    }

    public void resolveConstraint(VersionConstraint constraint, BaseDescription supplier) {
        ((VersionConstraintImpl)constraint).setSupplier(supplier);
    }

    public void resolveBundle(BundleDescription bundle, boolean status, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        BundleDescriptionImpl modifiable = (BundleDescriptionImpl)bundle;
        this.getDelta().recordBundleResolved(modifiable, status);
        modifiable.setLazyLoaded(false);
        modifiable.setStateBit(1, status);
        if (status) {
            this.resolveConstraints(modifiable, hosts, selectedExports, resolvedRequires, resolvedImports);
            this.resolvedBundles.add(modifiable);
        } else {
            this.unresolveConstraints(modifiable);
            this.resolvedBundles.remove(modifiable);
        }
    }

    public void removeBundleComplete(BundleDescription bundle) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        this.getDelta().recordBundleRemovalComplete((BundleDescriptionImpl)bundle);
        this.removalPendings.remove(bundle);
    }

    private void resolveConstraints(BundleDescriptionImpl bundle, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports) {
        HostSpecificationImpl hostSpec = (HostSpecificationImpl)bundle.getHost();
        if (hostSpec != null && hosts != null) {
            hostSpec.setHosts(hosts);
            for (int i = 0; i < hosts.length; ++i) {
                ((BundleDescriptionImpl)hosts[i]).addDependency(bundle);
            }
        }
        bundle.setSelectedExports(selectedExports);
        bundle.setResolvedRequires(resolvedRequires);
        bundle.setResolvedImports(resolvedImports);
        bundle.addDependencies(hosts);
        bundle.addDependencies(resolvedRequires);
        bundle.addDependencies(resolvedImports);
    }

    private void unresolveConstraints(BundleDescriptionImpl bundle) {
        HostSpecificationImpl host = (HostSpecificationImpl)bundle.getHost();
        if (host != null) {
            host.setHosts(null);
        }
        bundle.setSelectedExports(null);
        bundle.setResolvedImports(null);
        bundle.setResolvedRequires(null);
        bundle.removeDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StateDelta resolve(boolean incremental, BundleDescription[] reResolve) {
        try {
            BundleDescription[] removed;
            this.resolving = true;
            if (this.resolver == null) {
                throw new IllegalStateException("no resolver set");
            }
            this.fullyLoad();
            long start = 0L;
            if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                start = System.currentTimeMillis();
            }
            if (!incremental) {
                this.resolved = false;
                reResolve = this.getBundles();
                if (this.removalPendings.size() > 0) {
                    removed = this.getRemovalPendings();
                    reResolve = this.mergeBundles(reResolve, removed);
                }
                this.flush(reResolve);
            }
            if (this.resolved && reResolve == null) {
                removed = new StateDeltaImpl(this);
                return removed;
            }
            if (this.removalPendings.size() > 0) {
                removed = this.getRemovalPendings();
                reResolve = this.mergeBundles(reResolve, removed);
            }
            this.resolver.resolve(reResolve, this.platformProperties);
            this.resolved = true;
            StateDeltaImpl savedChanges = this.changes == null ? new StateDeltaImpl(this) : this.changes;
            this.changes = new StateDeltaImpl(this);
            if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                long time = System.currentTimeMillis() - start;
                Debug.println("Time spent resolving: " + time);
                FrameworkDebugOptions.getDefault().setOption("org.eclipse.core.runtime.adaptor/resolver/timing/value", Long.toString(cumulativeTime += time));
            }
            StateDeltaImpl stateDeltaImpl = savedChanges;
            return stateDeltaImpl;
        }
        finally {
            this.resolving = false;
        }
    }

    private BundleDescription[] mergeBundles(BundleDescription[] reResolve, BundleDescription[] removed) {
        int i;
        if (reResolve == null) {
            return removed;
        }
        if (reResolve.length == 0) {
            return reResolve;
        }
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>(reResolve.length + removed.length);
        for (i = 0; i < reResolve.length; ++i) {
            result.add(reResolve[i]);
        }
        for (i = 0; i < removed.length; ++i) {
            boolean found = false;
            for (int j = 0; j < reResolve.length; ++j) {
                if (removed[i] != reResolve[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(removed[i]);
        }
        return result.toArray(new BundleDescription[result.size()]);
    }

    private void flush(BundleDescription[] bundles) {
        this.resolver.flush();
        this.resolved = false;
        if (this.resolvedBundles.isEmpty()) {
            return;
        }
        for (int i = 0; i < bundles.length; ++i) {
            this.resolveBundle(bundles[i], false, null, null, null, null);
        }
        this.resolvedBundles.clear();
    }

    public StateDelta resolve() {
        return this.resolve(true, null);
    }

    public StateDelta resolve(boolean incremental) {
        return this.resolve(incremental, null);
    }

    public StateDelta resolve(BundleDescription[] reResolve) {
        return this.resolve(true, reResolve);
    }

    public void setOverrides(Object value) {
        throw new UnsupportedOperationException();
    }

    public BundleDescription[] getResolvedBundles() {
        return (BundleDescription[])this.resolvedBundles.elements(new BundleDescription[this.resolvedBundles.size()]);
    }

    public boolean isEmpty() {
        return this.bundleDescriptions.isEmpty();
    }

    void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    boolean basicAddBundle(BundleDescription description) {
        ((BundleDescriptionImpl)description).setContainingState(this);
        return this.bundleDescriptions.add((BundleDescriptionImpl)description);
    }

    void addResolvedBundle(BundleDescriptionImpl resolvedBundle) {
        this.resolvedBundles.add(resolvedBundle);
    }

    public ExportPackageDescription[] getExportedPackages() {
        int i;
        ExportPackageDescription[] bundlePackages;
        this.fullyLoad();
        ArrayList<ExportPackageDescription> allExportedPackages = new ArrayList<ExportPackageDescription>();
        Iterator iter = this.resolvedBundles.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            bundlePackages = bundle.getSelectedExports();
            if (bundlePackages == null) continue;
            for (i = 0; i < bundlePackages.length; ++i) {
                allExportedPackages.add(bundlePackages[i]);
            }
        }
        for (BundleDescription bundle : this.removalPendings) {
            bundlePackages = bundle.getSelectedExports();
            if (bundlePackages == null) continue;
            for (i = 0; i < bundlePackages.length; ++i) {
                allExportedPackages.add(bundlePackages[i]);
            }
        }
        return allExportedPackages.toArray(new ExportPackageDescription[allExportedPackages.size()]);
    }

    BundleDescription[] getFragments(BundleDescription host) {
        ArrayList<BundleDescription> fragments = new ArrayList<BundleDescription>();
        Iterator iter = this.bundleDescriptions.iterator();
        block0: while (iter.hasNext()) {
            BundleDescription[] hosts;
            BundleDescription bundle = (BundleDescription)iter.next();
            HostSpecification hostSpec = bundle.getHost();
            if (hostSpec == null || (hosts = hostSpec.getHosts()) == null) continue;
            for (int i = 0; i < hosts.length; ++i) {
                if (hosts[i] != host) continue;
                fragments.add(bundle);
                continue block0;
            }
        }
        return fragments.toArray(new BundleDescription[fragments.size()]);
    }

    public void setTimeStamp(long newTimeStamp) {
        this.timeStamp = newTimeStamp;
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    void setFactory(StateObjectFactory factory) {
        this.factory = factory;
    }

    public BundleDescription getBundleByLocation(String location) {
        Iterator i = this.bundleDescriptions.iterator();
        while (i.hasNext()) {
            BundleDescription current = (BundleDescription)i.next();
            if (!location.equals(current.getLocation())) continue;
            return current;
        }
        return null;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver newResolver) {
        if (this.resolver == newResolver) {
            return;
        }
        if (this.resolver != null) {
            Resolver oldResolver = this.resolver;
            this.resolver = null;
            oldResolver.setState(null);
        }
        this.resolver = newResolver;
        if (this.resolver == null) {
            return;
        }
        this.resolver.setState(this);
    }

    public synchronized boolean setPlatformProperties(Dictionary platformProperties) {
        if (this.platformProperties.length != 1) {
            this.platformProperties = new Dictionary[]{new Hashtable(PROPS.length)};
        }
        return this.setProps(this.platformProperties[0], platformProperties);
    }

    public boolean setPlatformProperties(Dictionary[] platformProperties) {
        if (platformProperties.length == 0) {
            throw new IllegalArgumentException();
        }
        if (this.platformProperties.length != platformProperties.length) {
            this.platformProperties = new Dictionary[platformProperties.length];
            for (int i = 0; i < platformProperties.length; ++i) {
                this.platformProperties[i] = new Hashtable(PROPS.length);
            }
        }
        boolean result = false;
        for (int i = 0; i < platformProperties.length; ++i) {
            result |= this.setProps(this.platformProperties[i], platformProperties[0]);
        }
        return result;
    }

    public Dictionary[] getPlatformProperties() {
        return this.platformProperties;
    }

    private boolean checkProp(Object origObj, Object newObj) {
        if (origObj == null && newObj != null || origObj != null && newObj == null) {
            return true;
        }
        if (origObj == null) {
            return false;
        }
        if (origObj.getClass() != newObj.getClass()) {
            return true;
        }
        if (origObj instanceof String) {
            return !origObj.equals(newObj);
        }
        String[] origProps = (String[])origObj;
        String[] newProps = (String[])newObj;
        if (origProps.length != newProps.length) {
            return true;
        }
        for (int i = 0; i < origProps.length; ++i) {
            if (origProps[i].equals(newProps[i])) continue;
            return true;
        }
        return false;
    }

    private boolean setProps(Dictionary origProps, Dictionary newProps) {
        boolean changed = false;
        for (int i = 0; i < PROPS.length; ++i) {
            Object newProp;
            Object origProp = origProps.get(PROPS[i]);
            if (!this.checkProp(origProp, newProp = newProps.get(PROPS[i]))) continue;
            changed = true;
            if (newProp == null) {
                origProps.remove(PROPS[i]);
            } else {
                origProps.put(PROPS[i], newProp);
            }
            if (!PROPS[i].equals("org.osgi.framework.system.packages")) continue;
            this.setSystemExports((String)newProp);
        }
        return changed;
    }

    public BundleDescription[] getRemovalPendings() {
        return this.removalPendings.toArray(new BundleDescription[this.removalPendings.size()]);
    }

    public synchronized ExportPackageDescription linkDynamicImport(BundleDescription importingBundle, String requestedPackage) {
        if (this.resolver == null) {
            throw new IllegalStateException("no resolver set");
        }
        this.fullyLoad();
        ExportPackageDescriptionImpl result = (ExportPackageDescriptionImpl)this.resolver.resolveDynamicImport(importingBundle, requestedPackage);
        if (result == null) {
            return null;
        }
        ((BundleDescriptionImpl)importingBundle).addDynamicResolvedImport(result);
        return result;
    }

    void setReader(StateReader reader) {
        this.reader = reader;
    }

    StateReader getReader() {
        return this.reader;
    }

    public void fullyLoad() {
        if (this.fullyLoaded) {
            return;
        }
        if (this.reader != null && this.reader.isLazyLoaded()) {
            this.reader.fullyLoad();
        }
        this.fullyLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadLazyData(long expireTime) {
        long currentTime = System.currentTimeMillis();
        BundleDescription[] bundles = this.getBundles();
        StateReader stateReader = this.reader;
        synchronized (stateReader) {
            for (int i = 0; i < bundles.length; ++i) {
                ((BundleDescriptionImpl)bundles[i]).unload(currentTime, expireTime);
            }
        }
    }

    void setSystemExports(String exportSpec) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader("Export-Package", exportSpec);
            this.systemExports = StateBuilder.createExportPackages(elements, null, null, null, 2, false);
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }

    public ExportPackageDescription[] getSystemPackages() {
        if (this.systemExports == null) {
            return new ExportPackageDescription[0];
        }
        return this.systemExports;
    }

    boolean inStrictMode() {
        return "strict".equals(this.getPlatformProperties()[0].get("osgi.resolverMode"));
    }
}

