/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementCollectorVisitor
extends LanguageVisitor {
    private Collection elements;

    public ElementCollectorVisitor(Collection elements) {
        if (elements == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0021"));
        }
        this.elements = elements;
    }

    public Collection getElements() {
        return this.elements;
    }

    @Override
    public void visit(ElementSymbol obj) {
        this.elements.add(obj);
    }

    @Override
    public void visit(AllInGroupSymbol obj) {
        if (obj.getElementSymbols() != null) {
            this.elements.addAll(obj.getElementSymbols());
        }
    }

    @Override
    public void visit(AllSymbol obj) {
        if (obj.getElementSymbols() != null) {
            this.elements.addAll(obj.getElementSymbols());
        }
    }

    public static final void getElements(LanguageObject obj, Collection elements) {
        if (obj == null) {
            return;
        }
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static final Collection getElements(LanguageObject obj, boolean removeDuplicates) {
        return ElementCollectorVisitor.getElements(obj, removeDuplicates, false);
    }

    public static final Collection getElements(LanguageObject obj, boolean removeDuplicates, boolean useDeepIteration) {
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        AbstractCollection elements = null;
        elements = removeDuplicates ? new HashSet() : new ArrayList();
        ElementCollectorVisitor visitor = null;
        if (useDeepIteration) {
            visitor = new ElementCollectorVisitor(elements);
            DeepPreOrderNavigator.doVisit(obj, visitor);
        } else {
            visitor = new ElementCollectorVisitor(elements);
            PreOrderNavigator.doVisit(obj, visitor);
        }
        return elements;
    }

    public static final void getElements(Collection<LanguageObject> objs, Collection elements) {
        if (objs == null) {
            return;
        }
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        for (LanguageObject object : objs) {
            PreOrderNavigator.doVisit(object, visitor);
        }
    }
}

