/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationActions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StandardAuthorizationActions
implements Serializable,
AuthorizationActions {
    public static final int NONE_VALUE = 0;
    public static final int DATA_CREATE_VALUE = 1;
    public static final int DATA_READ_VALUE = 2;
    public static final int DATA_UPDATE_VALUE = 4;
    public static final int DATA_DELETE_VALUE = 8;
    public static final int ALL_VALUE = 15;
    public static final String NONE_LABEL = "None";
    public static final String DATA_CREATE_LABEL = "Create";
    public static final String DATA_READ_LABEL = "Read";
    public static final String DATA_UPDATE_LABEL = "Update";
    public static final String DATA_DELETE_LABEL = "Delete";
    public static final AuthorizationActions NONE = new StandardAuthorizationActions(0, new String[]{"None"});
    public static final AuthorizationActions DATA_CREATE = new StandardAuthorizationActions(1, new String[]{"Create"});
    public static final AuthorizationActions DATA_UPDATE = new StandardAuthorizationActions(4, new String[]{"Update"});
    public static final AuthorizationActions DATA_READ = new StandardAuthorizationActions(2, new String[]{"Read"});
    public static final AuthorizationActions DATA_DELETE = new StandardAuthorizationActions(8, new String[]{"Delete"});
    public static final AuthorizationActions ALL = new StandardAuthorizationActions(15, new String[]{"Create", "Read", "Update", "Delete"});
    private static final int LABELS_COUNT = 6;
    private static Map actionSet = new HashMap();
    private int actions;
    private String label;
    private String[] labels;
    private Collection labelCollection;

    private static void addAction(int values, String[] labels) {
        actionSet.put(new Integer(values), new StandardAuthorizationActions(values, labels));
    }

    private StandardAuthorizationActions(int actions, String[] labels) {
        this.actions = actions;
        this.labels = labels;
        this.label = "";
        this.labelCollection = new ArrayList(6);
        for (int i = 0; i != this.labels.length; ++i) {
            if (i != 0) {
                this.label = this.label + ",";
            }
            this.label = this.label + this.labels[i];
            this.labelCollection.add(this.labels[i]);
        }
    }

    public static AuthorizationActions getAuthorizationActions(int actions) {
        if (actions > 15 || actions < 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0066"));
        }
        AuthorizationActions results = (AuthorizationActions)actionSet.get(new Integer(actions));
        if (results == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0067", actions));
        }
        return (AuthorizationActions)actionSet.get(new Integer(actions));
    }

    public static AuthorizationActions getAuthorizationActions(String[] labels) {
        if (labels == null || labels.length == 0 || labels.length > 6) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0068", labels));
        }
        for (AuthorizationActions action : actionSet.values()) {
            if (!action.containsLabels(labels)) continue;
            return action;
        }
        return null;
    }

    public static AuthorizationActions getAuthorizationActions(String labels) {
        if (labels == null || labels.length() == 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0068", labels));
        }
        for (AuthorizationActions action : actionSet.values()) {
            if (!action.getLabel().equals(labels)) continue;
            return action;
        }
        return null;
    }

    public static AuthorizationActions getAuthorizationActions(Collection labels) {
        if (labels == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0068", labels));
        }
        int labelCount = labels.size();
        if (labelCount == 0 || labelCount > 6) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0068", labels));
        }
        for (AuthorizationActions action : actionSet.values()) {
            if (!action.containsLabels(labels) || labels.size() != action.getLabelCount()) continue;
            return action;
        }
        return null;
    }

    public static AuthorizationActions getORedActions(AuthorizationActions actions, AuthorizationActions otherActions) {
        int oredValue = actions.getValue() | otherActions.getValue();
        AuthorizationActions oredActions = StandardAuthorizationActions.getAuthorizationActions(oredValue);
        return oredActions;
    }

    public static AuthorizationActions getCommonActions(AuthorizationActions actions, AuthorizationActions sharedActions) {
        int commonValue = actions.getValue() & sharedActions.getValue();
        AuthorizationActions commonActions = StandardAuthorizationActions.getAuthorizationActions(commonValue);
        return commonActions;
    }

    public static AuthorizationActions getCommonActions(int actions, int sharedActions) {
        int commonValue = actions & sharedActions;
        AuthorizationActions commonActions = StandardAuthorizationActions.getAuthorizationActions(commonValue);
        return commonActions;
    }

    public static AuthorizationActions getIndependantActions(AuthorizationActions actions, AuthorizationActions sharedActions) {
        int independantValue = actions.getValue() ^ sharedActions.getValue();
        AuthorizationActions independantActions = StandardAuthorizationActions.getAuthorizationActions(independantValue);
        return independantActions;
    }

    public static AuthorizationActions getIndependantActions(int actions, int sharedActions) {
        int independantValue = actions ^ sharedActions;
        AuthorizationActions independantActions = StandardAuthorizationActions.getAuthorizationActions(independantValue);
        return independantActions;
    }

    public static String[] getActionsLabels(int actionsValue) {
        AuthorizationActions actions = StandardAuthorizationActions.getAuthorizationActions(actionsValue);
        String[] actionLabels = new String[]{};
        if (actions != null) {
            actionLabels = actions.getLabels();
        }
        return actionLabels;
    }

    public static String getActionsString(int actionsValue) {
        StringBuffer actionBuf = new StringBuffer();
        AuthorizationActions actions = StandardAuthorizationActions.getAuthorizationActions(actionsValue);
        if (actions != null) {
            String[] actionLables = actions.getLabels();
            actionBuf.append("{");
            for (int i = 0; i < actionLables.length; ++i) {
                actionBuf.append(actionLables[i] + ", ");
            }
            actionBuf.replace(actionBuf.length() - 2, actionBuf.length(), "}");
        }
        return actionBuf.toString();
    }

    public int getValue() {
        return this.actions;
    }

    public int getLabelCount() {
        return this.labelCollection.size();
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public boolean containsLabel(String label) {
        return this.labelCollection.contains(label);
    }

    public boolean containsLabels(String[] labels) {
        return this.labelCollection.containsAll(Arrays.asList(labels));
    }

    public boolean containsLabels(Collection labels) {
        return this.labelCollection.containsAll(labels);
    }

    public String toString() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StandardAuthorizationActions) {
            return this.compareFields((StandardAuthorizationActions)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.actions;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (obj == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0069"));
        }
        if (obj instanceof StandardAuthorizationActions) {
            return this.compareFields((StandardAuthorizationActions)obj);
        }
        throw new ClassCastException(PlatformPlugin.Util.getString("ERR.014.107.0070", obj.getClass()));
    }

    public boolean implies(AuthorizationActions that) {
        if (that == null || !(that instanceof StandardAuthorizationActions)) {
            return false;
        }
        return (this.getValue() & that.getValue()) == that.getValue();
    }

    int compareFields(StandardAuthorizationActions obj) {
        return obj.getValue() < this.getValue() ? -1 : (obj.getValue() == this.getValue() ? 0 : 1);
    }

    static {
        StandardAuthorizationActions.addAction(0, new String[]{NONE_LABEL});
        StandardAuthorizationActions.addAction(1, new String[]{DATA_CREATE_LABEL});
        StandardAuthorizationActions.addAction(2, new String[]{DATA_READ_LABEL});
        StandardAuthorizationActions.addAction(3, new String[]{DATA_CREATE_LABEL, DATA_READ_LABEL});
        StandardAuthorizationActions.addAction(4, new String[]{DATA_UPDATE_LABEL});
        StandardAuthorizationActions.addAction(5, new String[]{DATA_CREATE_LABEL, DATA_UPDATE_LABEL});
        StandardAuthorizationActions.addAction(6, new String[]{DATA_READ_LABEL, DATA_UPDATE_LABEL});
        StandardAuthorizationActions.addAction(7, new String[]{DATA_CREATE_LABEL, DATA_READ_LABEL, DATA_UPDATE_LABEL});
        StandardAuthorizationActions.addAction(8, new String[]{DATA_DELETE_LABEL});
        StandardAuthorizationActions.addAction(9, new String[]{DATA_CREATE_LABEL, DATA_DELETE_LABEL});
        StandardAuthorizationActions.addAction(10, new String[]{DATA_READ_LABEL, DATA_DELETE_LABEL});
        StandardAuthorizationActions.addAction(11, new String[]{DATA_CREATE_LABEL, DATA_READ_LABEL, DATA_DELETE_LABEL});
        StandardAuthorizationActions.addAction(12, new String[]{DATA_UPDATE_LABEL, DATA_DELETE_LABEL});
        StandardAuthorizationActions.addAction(13, new String[]{DATA_CREATE_LABEL, DATA_UPDATE_LABEL, DATA_DELETE_LABEL});
        StandardAuthorizationActions.addAction(14, new String[]{DATA_READ_LABEL, DATA_UPDATE_LABEL, DATA_DELETE_LABEL});
        StandardAuthorizationActions.addAction(15, new String[]{DATA_CREATE_LABEL, DATA_READ_LABEL, DATA_UPDATE_LABEL, DATA_DELETE_LABEL});
    }
}

