/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.impl.local;

import com.metamatrix.common.comm.CommonCommPlugin;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionContext;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.impl.local.LocalClientConnection;
import java.util.Properties;
import java.util.TimeZone;

public class LocalServerConnection
implements ServerConnection {
    private ServerListener server;
    private LocalClientConnection client;

    public LocalServerConnection(ServerListener server, LocalClientConnection client, Properties connectionProperties) {
        this.server = server;
        this.client = client;
    }

    public void shutdown() {
        this.server.connectionRemoved(this.client);
    }

    public ServerInstance selectServerInstance(String subSelector) throws CommunicationException {
        return null;
    }

    public ServerInstance reselectServerInstance(String contextPortableString) throws CommunicationException {
        return null;
    }

    public void send(Message message, MessageListener listener, String messageKey, ServerInstance instance) throws CommunicationException {
        ClassLoader current;
        if (!this.client.isShutdown()) {
            current = null;
            current = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (listener != null) {
                this.client.addWaitingKey(messageKey, listener);
            }
        } else {
            throw new CommunicationException(CommonCommPlugin.Util.getString("LocalServerConnection.client_shutdown"));
        }
        this.server.receive(this.client, message, messageKey);
        Thread.currentThread().setContextClassLoader(current);
    }

    public Message send(Message message, ServerInstance instance) throws CommunicationException, ApplicationException {
        if (!this.client.isShutdown()) {
            ClassLoader current = null;
            current = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Message returnMessage = this.server.receive(this.client, message);
            Thread.currentThread().setContextClassLoader(current);
            return returnMessage;
        }
        throw new CommunicationException(CommonCommPlugin.Util.getString("LocalServerConnection.client_shutdown"));
    }

    public ServerConnectionContext getContext() throws CommunicationException {
        return null;
    }

    public TimeZone getTimeZone() {
        return null;
    }
}

