/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.sybase;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.sybase.SybaseXid;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class SybaseImplXAResource
extends BaseImplXAResource {
    private static String footprint = "$Revision:   3.5.4.0  $";
    static final int XA_DTM_STAT_NEW = 0;
    static final int XA_DTM_STAT_ATTACH = 1;
    static final int XA_DTM_STAT_DETACH = 2;
    static final int XA_DTM_STAT_SUSPEND = 3;
    static final int XA_DTM_STAT_MIGRATE = 4;
    static final int XA_DTM_STAT_RBONLY = 6;
    static final int XA_DTM_STAT_PREPARED = 7;
    static final int XA_DTM_STAT_COMMIT = 100;
    static final int XA_DTM_STAT_ABORT = 101;
    static final int XA_DTM_STAT_FORGET = 102;
    static final int XA_DTM_STAT_QUERYING = 255;
    static final int XA_DTM_1_RESULT = 1;
    static final int XA_DTM_NO_RESULT = 0;
    static final int XA_DTM_NO_COLUMNS = 2;
    static final int XA_DTM_NO_ROWS = 3;
    static final int XA_DTM_XTRA_RESULT = 4;
    static final int XA_DTM_XTRA_COLUMNS = 5;
    static final int XA_DTM_XTRA_ROW = 6;
    static final int XA_DTM_BAD_RESULT = -1;
    static final int XACTFL_NOFLAG = 0;
    static final int XACTFL_ABORT = 1;
    static final int XACTFL_NOWAIT = 2;
    static final int XACTFL_DONE = 4;
    static final int XACTFL_RESERVED_1 = 8;
    static final int XACTFL_WITHATTACH = 16;
    static final int XACTFL_ONE_PHASE_COMMIT = 32;
    static final int XACTFL_RESERVED_2 = 64;
    static final int XACTFL_RESERVED_3 = 128;
    static final int XACTFL_ASYNC = 256;
    static final int XACTFL_HEUR_COMMIT = 512;
    static final int XACTFL_HEUR_ROLLBACK = 1024;
    static final int XACTFL_BEGIN_SAVEPT = 2048;
    static final int XACTFL_STRICTDTM = 4096;
    static final int XACTFL_WITHDETACH = 8192;
    static final int XACTFL_FORCE_DETACH = 16384;
    static final int XACTFL_TIGHTLY_COUPLED = 524288;
    static final int XACTRV_RM_ERR = -1;
    static final int XACTRV_NOXID_ERR = -2;
    static final int XACTRV_DUPXID_ERR = -3;
    static final int XACTRV_BUSY_ERR = -4;
    static final int XACTRV_INVLDPRM_ERR = -5;
    static final int XACTRV_NOPERM_ERR = -6;
    static final int XACTRV_RECOVERY_IN_PROGRESS = -7;
    static final int XACTRV_CURSOR_NOT_ALLOWED_ERR = -8;
    static final int XACTRV_COMPLETE_IN_PROGRESS = -9;
    static final int XACTRV_PROTO_ERR = -128;
    static final int XACTRV_COMMITTED_READONLY = -256;
    static final String BEGIN_RPC = "{?= call $beginSybDtmXact (?, ?, ?, ?)}";
    static final String END_RPC = "{?= call $endSybDtmXact (?, ?, ?)}";
    static final String PREPARE_RPC = "{?= call $prepareSybDtmXact (?, ?, ?)}";
    static final String COMMIT_RPC = "{?= call $commitSybDtmXact (?, ?, ?)}";
    static final String ROLLBACK_RPC = "{?= call $rollbackSybDtmXact (?, ?, ?)}";
    static final String FORGET_RPC = "{?= call $forgetSybDtmXact (?, ?, ?)}";
    static final String STATUS_RPC = "{?= call $statusSybDtmXact (?, ?, ?)}";
    static final String ATTACH_RPC = "{?= call $attachSybDtmXact (?, ?, ?)}";
    static final String DETACH_RPC = "{?= call $detachSybDtmXact (?, ?, ?)}";
    static final String TRANSACTION_STATUS = "{?= call sp_transactions (?)}";
    BaseConnectionProperties connectProps;
    int timeout;
    Xid currentTxnXid;
    boolean recursiveMode = false;
    CallableStatement beginRpcStmt = null;
    CallableStatement attachRpcStmt = null;
    CallableStatement detachRpcStmt = null;
    CallableStatement commitRpcStmt = null;
    CallableStatement rollbackRpcStmt = null;
    CallableStatement prepareRpcStmt = null;
    CallableStatement forgetRpcStmt = null;
    CallableStatement transactionStatusRpcStmt = null;

    public SybaseImplXAResource(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.connectProps = baseConnection.getConnectProperties();
        this.currentTxnXid = null;
        this.recursiveMode = false;
    }

    private CallableStatement prepCall(String string) throws XAException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(string);
        }
        catch (SQLException sQLException) {
            XAException xAException = new XAException(sQLException.getMessage());
            xAException.errorCode = -3;
            throw xAException;
        }
        return callableStatement;
    }

    protected void close() throws SQLException {
        try {
            if (this.beginRpcStmt != null) {
                this.beginRpcStmt.close();
                this.beginRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.attachRpcStmt != null) {
                this.attachRpcStmt.close();
                this.attachRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.detachRpcStmt != null) {
                this.detachRpcStmt.close();
                this.detachRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.commitRpcStmt != null) {
                this.commitRpcStmt.close();
                this.commitRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.rollbackRpcStmt != null) {
                this.rollbackRpcStmt.close();
                this.rollbackRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.prepareRpcStmt != null) {
                this.prepareRpcStmt.close();
                this.prepareRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.forgetRpcStmt != null) {
                this.forgetRpcStmt.close();
                this.forgetRpcStmt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void start(Xid xid, int n) throws XAException {
        int n2 = 0;
        try {
            this.connection.setTransactionIsolation(2112);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if ((n & 0x8200000) == 0) {
            if (this.beginRpcStmt == null) {
                this.beginRpcStmt = this.prepCall(BEGIN_RPC);
            }
            this.executeXaRpc(this.beginRpcStmt, BEGIN_RPC, xid, 1, 16);
        } else {
            if (this.attachRpcStmt == null) {
                this.attachRpcStmt = this.prepCall(ATTACH_RPC);
            }
            n2 = this.executeXaRpc(this.attachRpcStmt, ATTACH_RPC, xid, 1, 0);
            if (!this.recursiveMode && (n & 0x8000000) != 0 && n2 != 3 || (n & 0x200000) != 0 && n2 == 101) {
                try {
                    if (this.detachRpcStmt == null) {
                        this.detachRpcStmt = this.prepCall(DETACH_RPC);
                    }
                    this.executeXaRpc(this.detachRpcStmt, DETACH_RPC, xid, n2, 0);
                }
                catch (XAException xAException) {
                    // empty catch block
                }
                throw new XAException(-6);
            }
        }
        this.setCurrentTransaction(xid);
    }

    protected void end(Xid xid, int n) throws XAException {
        this.clearCurrentTransaction(xid);
        int n2 = 2;
        if ((n & 0x2000000) != 0) {
            n2 = 3;
        } else if ((n & 0x20000000) != 0) {
            n2 = 101;
        }
        if (this.detachRpcStmt == null) {
            this.detachRpcStmt = this.prepCall(DETACH_RPC);
        }
        this.executeXaRpc(this.detachRpcStmt, DETACH_RPC, xid, n2, 0);
    }

    protected int prepare(Xid xid) throws XAException {
        if (this.prepareRpcStmt == null) {
            this.prepareRpcStmt = this.prepCall(PREPARE_RPC);
        }
        int n = this.executeXaRpc(this.prepareRpcStmt, PREPARE_RPC, xid, 7, 24576);
        this.resumeCurrentTransaction(xid);
        if (n == -256) {
            return 3;
        }
        return 0;
    }

    protected void commit(Xid xid, boolean bl) throws XAException {
        int n = 24576;
        if (bl) {
            n |= 0x20;
        }
        if (this.commitRpcStmt == null) {
            this.commitRpcStmt = this.prepCall(COMMIT_RPC);
        }
        this.executeXaRpc(this.commitRpcStmt, COMMIT_RPC, xid, 100, n);
        this.resumeCurrentTransaction(xid);
    }

    protected void rollback(Xid xid) throws XAException {
        if (this.rollbackRpcStmt == null) {
            this.rollbackRpcStmt = this.prepCall(ROLLBACK_RPC);
        }
        this.executeXaRpc(this.rollbackRpcStmt, ROLLBACK_RPC, xid, 101, 24576);
        this.resumeCurrentTransaction(xid);
    }

    protected void forget(Xid xid) throws XAException {
        if (this.forgetRpcStmt == null) {
            this.forgetRpcStmt = this.prepCall(FORGET_RPC);
        }
        this.executeXaRpc(this.forgetRpcStmt, FORGET_RPC, xid, 102, 24576);
        this.resumeCurrentTransaction(xid);
    }

    protected Xid[] recover(int n) throws XAException {
        UtilVectorUnsynced utilVectorUnsynced = new UtilVectorUnsynced();
        ResultSet resultSet = null;
        try {
            if (this.transactionStatusRpcStmt == null) {
                this.transactionStatusRpcStmt = this.prepCall(TRANSACTION_STATUS);
            }
            this.transactionStatusRpcStmt.registerOutParameter(1, 4);
            this.transactionStatusRpcStmt.setString(2, "xa_recover");
            boolean bl = this.transactionStatusRpcStmt.execute();
            int n2 = 0;
            while (true) {
                if (bl) {
                    resultSet = this.transactionStatusRpcStmt.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString("xactname");
                        utilVectorUnsynced.add(new SybaseXid(string));
                    }
                    break;
                }
                n2 = this.transactionStatusRpcStmt.getUpdateCount();
                if (n2 == -1) {
                    break;
                }
                bl = this.transactionStatusRpcStmt.getMoreResults();
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(-3);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        if (utilVectorUnsynced.size() == 0) {
            return null;
        }
        Object[] objectArray = new SybaseXid[utilVectorUnsynced.size()];
        utilVectorUnsynced.copyInto(objectArray);
        return objectArray;
    }

    protected boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.timeout = n;
        return false;
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    protected String getRmIdentification() throws XAException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("databaseName");
        String string4 = this.connectProps.get("user");
        return string + "_" + string2 + "_" + string3 + "_" + string4;
    }

    private final int executeXaRpc(CallableStatement callableStatement, String string, Xid xid, int n, int n2) throws XAException {
        int n3 = 0;
        SybaseXid sybaseXid = xid instanceof SybaseXid ? (SybaseXid)xid : new SybaseXid(xid);
        String string2 = sybaseXid.getEncodedString();
        try {
            callableStatement.registerOutParameter(1, 4);
            callableStatement.setString(2, string2);
            callableStatement.setInt(3, n);
            callableStatement.setInt(4, n2);
            if (callableStatement.equals(this.beginRpcStmt)) {
                callableStatement.setInt(5, 196608);
            }
            callableStatement.executeUpdate();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            XAException xAException = new XAException(sQLException.getMessage());
            xAException.errorCode = -3;
            throw xAException;
        }
        this.verifyReturnCode(string, n3);
        return n3;
    }

    private final void verifyReturnCode(String string, int n) throws XAException {
        if (n >= 0) {
            return;
        }
        int n2 = -3;
        String string2 = null;
        switch (n) {
            case -1: {
                n2 = -3;
                string2 = "XACTRV_RM_ERR, XA Error: XAER_RMERR";
                break;
            }
            case -2: {
                n2 = -4;
                string2 = "XACTRV_NOXID_ERR, XA Error = XAER_NOTA";
                break;
            }
            case -3: {
                n2 = -8;
                string2 = "XACTRV_DUPXID_ERR, XA Error = XAER_DUPID";
                break;
            }
            case -4: {
                n2 = -7;
                string2 = "XACTRV_DUPXID_ERR, XA Error = XAER_RMFAIL";
                break;
            }
            case -5: {
                n2 = -5;
                string2 = "XACTRV_INVLDPRM_ERR, XA Error = XAER_INVAL";
                break;
            }
            case -6: {
                n2 = -6;
                string2 = "XACTRV_NOPERM_ERR, XA Error = XAER_PROTO";
                break;
            }
            case -128: {
                n2 = -6;
                string2 = "XACTRV_NOPERM_ERR, XA Error = XAER_PROTO";
                break;
            }
            case -256: {
                return;
            }
            default: {
                n2 = -3;
                string2 = "Unrecognized return code from server: " + n;
            }
        }
        int n3 = string.indexOf(36);
        int n4 = string.indexOf("Xact");
        String string3 = string.substring(n3, n4 + 4);
        string2 = string3 + ": " + string2;
        XAException xAException = new XAException(string2);
        xAException.errorCode = n2;
        throw xAException;
    }

    void setCurrentTransaction(Xid xid) {
        if (this.recursiveMode) {
            return;
        }
        this.currentTxnXid = xid;
    }

    void clearCurrentTransaction(Xid xid) {
        if (this.recursiveMode || this.currentTxnXid == null || !this.currentTxnXid.equals(xid)) {
            return;
        }
        this.currentTxnXid = null;
    }

    void suspendCurrentTransaction(Xid xid) throws XAException {
        if (this.currentTxnXid == null || this.currentTxnXid.equals(xid)) {
            return;
        }
        this.recursiveMode = true;
        this.end(this.currentTxnXid, 0x2000000);
        this.recursiveMode = false;
    }

    void resumeCurrentTransaction(Xid xid) throws XAException {
        if (this.currentTxnXid == null || this.currentTxnXid.equals(xid)) {
            return;
        }
        this.recursiveMode = true;
        this.start(this.currentTxnXid, 0x8000000);
        this.recursiveMode = false;
    }
}

