/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.db2.DB2EscapeTranslator;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.DB2LocalMessages;
import com.metamatrix.jdbc.db2.drda.DRDABindRequest;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAExecuteStatementRequest;
import com.metamatrix.jdbc.db2.drda.DRDALoginRequest;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;
import java.text.MessageFormat;

public class DB2PackageManager {
    private static String footprint = "$Revision:   3.23.1.0  $";
    DB2ImplConnection con;
    DRDACommunication comm;
    DRDALoginRequest loginRequest;
    boolean packagesCreated;
    boolean replaceForProblem;
    private String databaseName;
    private String collectionId;
    private String grantee;
    private String replacePackage;
    private String packageOwner;
    private String defaultQualifier;
    private boolean withHoldCursors;
    private int dynamicSections;
    private boolean isInitialized;
    public final String baseName = "DDJ";
    public final String[] isoLvl = new String[]{"C", "S", "R", "U", "N"};
    public final String[] suffix = new String[]{"A", "B", "C"};
    public String currentPackage;
    public static final String vrm = "360";
    public static final String SDDJCVRMA = "DDJC360A";
    public static final String SDDJSVRMA = "DDJS360A";
    public static final String SDDJRVRMA = "DDJR360A";
    public static final String SDDJUVRMA = "DDJU360A";
    public static final String SDDJNVRMA = "DDJN360A";
    public static final String SDDJCVRMB = "DDJC360B";
    public static final String SDDJSVRMB = "DDJS360B";
    public static final String SDDJRVRMB = "DDJR360B";
    public static final String SDDJUVRMB = "DDJU360B";
    public static final String SDDJNVRMB = "DDJN360B";
    public static final String SDDJCVRMC = "DDJC360C";
    public static final String SDDJSVRMC = "DDJS360C";
    public static final String SDDJRVRMC = "DDJR360C";
    public static final String SDDJUVRMC = "DDJU360C";
    public static final String SDDJNVRMC = "DDJN360C";
    int[] DDJCVRMA;
    int[] DDJCVRMB;
    int[] DDJCVRMC;
    int[] DDJSVRMA;
    int[] DDJSVRMB;
    int[] DDJSVRMC;
    int[] DDJRVRMA;
    int[] DDJRVRMB;
    int[] DDJRVRMC;
    int[] DDJUVRMA;
    int[] DDJUVRMB;
    int[] DDJUVRMC;
    int[] DDJNVRMA;
    int[] DDJNVRMB;
    int[] DDJNVRMC;
    int DDJCVRMA_last;
    int DDJCVRMB_last;
    int DDJSVRMA_last;
    int DDJSVRMB_last;
    int DDJRVRMA_last;
    int DDJRVRMB_last;
    int DDJUVRMA_last;
    int DDJUVRMB_last;
    int DDJNVRMA_last;
    int DDJNVRMB_last;
    Object[] secs = new Object[15];
    boolean detectedProblem = false;

    public DB2PackageManager(DRDACommunication dRDACommunication, DB2ImplConnection dB2ImplConnection) {
        this.con = dB2ImplConnection;
        this.comm = dRDACommunication;
    }

    public void initialize(DRDALoginRequest dRDALoginRequest) throws SQLException {
        this.loginRequest = dRDALoginRequest;
        this.databaseName = this.con.databaseName;
        this.collectionId = this.con.collectionId;
        this.packageOwner = this.con.packageOwner;
        this.grantee = this.con.grantee;
        this.replacePackage = this.con.replacePackage;
        this.defaultQualifier = this.con.defaultQualifier;
        this.withHoldCursors = this.con.holdCursorsOverCommit;
        this.dynamicSections = Integer.parseInt(this.con.dynSectionsString);
        this.detectedProblem = false;
        try {
            int n;
            if (!this.con.connectProps.get("createDefaultPackage").equalsIgnoreCase("false")) {
                n = this.createPackageSet();
                if (!this.con.grantExecute.equalsIgnoreCase("false")) {
                    this.grantPackagePrivileges();
                }
            } else {
                try {
                    n = this.getMaxSections();
                    if (this.detectedProblem) {
                        System.out.println(((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7117, null));
                        n = this.createPackageSet();
                        if (!this.con.grantExecute.equalsIgnoreCase("false")) {
                            this.grantPackagePrivileges();
                        }
                        System.out.println(((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7118, null));
                    }
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -805) {
                        n = this.createPackageSet();
                        if (!this.con.grantExecute.equalsIgnoreCase("false")) {
                            this.grantPackagePrivileges();
                        }
                    }
                    throw sQLException;
                }
            }
            this.dynamicSections = n;
        }
        catch (SQLException sQLException) {
            if (!this.con.connectProps.get("createDefaultPackage").equalsIgnoreCase("false")) {
                throw sQLException;
            }
            String[] stringArray = new String[]{sQLException.getMessage()};
            this.con.warnings.add(7119, stringArray, sQLException.getSQLState(), sQLException.getErrorCode());
        }
        this.setupLocalPackageSet();
        if (this.packagesCreated) {
            this.con.warnings.add(7095);
        }
    }

    public int getNumberOfSections() {
        return this.dynamicSections;
    }

    private void setupLocalPackageSet() {
        this.DDJCVRMA = new int[this.dynamicSections];
        this.DDJCVRMB = new int[this.dynamicSections];
        this.DDJCVRMC = new int[2];
        this.DDJSVRMA = new int[this.dynamicSections];
        this.DDJSVRMB = new int[this.dynamicSections];
        this.DDJSVRMC = new int[2];
        this.DDJRVRMA = new int[this.dynamicSections];
        this.DDJRVRMB = new int[this.dynamicSections];
        this.DDJRVRMC = new int[2];
        this.DDJUVRMA = new int[this.dynamicSections];
        this.DDJUVRMB = new int[this.dynamicSections];
        this.DDJUVRMC = new int[2];
        this.DDJNVRMA = new int[this.dynamicSections];
        this.DDJNVRMB = new int[this.dynamicSections];
        this.DDJNVRMC = new int[2];
        this.secs[0] = this.DDJCVRMA;
        this.secs[1] = this.DDJCVRMB;
        this.secs[2] = this.DDJCVRMC;
        this.secs[3] = this.DDJSVRMA;
        this.secs[4] = this.DDJSVRMB;
        this.secs[5] = this.DDJSVRMC;
        this.secs[6] = this.DDJRVRMA;
        this.secs[7] = this.DDJRVRMB;
        this.secs[8] = this.DDJRVRMC;
        this.secs[9] = this.DDJUVRMA;
        this.secs[10] = this.DDJUVRMB;
        this.secs[11] = this.DDJUVRMC;
        this.secs[12] = this.DDJNVRMA;
        this.secs[13] = this.DDJNVRMB;
        this.secs[14] = this.DDJNVRMC;
        for (int i = 0; i < this.secs.length; ++i) {
            int[] nArray = (int[])this.secs[i];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = -1;
            }
        }
        this.isInitialized = true;
    }

    private int getMaxSections() throws SQLException {
        if (this.con.skipConnectionChecks) {
            return this.dynamicSections;
        }
        String string = null;
        if (this.comm.serverOS == 8) {
            string = "SELECT ISOLATION FROM QSYS2.SYSPACKAGE WHERE PACKAGE_NAME = 'DDJN360B' and PACKAGE_SCHEMA = '" + this.con.collectionId.toUpperCase() + "'";
            DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.con.createImplStatement(1000, 1003);
            dB2ImplStatement.setup(this.con, this.con.warnings);
            dB2ImplStatement.setSQL(new BaseSQL(string, 0, this.con.quotingChar, this.con.intoIsOptional, new DB2EscapeTranslator(this.con), this.con.exceptions));
            dB2ImplStatement.execute();
            dB2ImplStatement.getNextResultType();
            BaseImplResultSet baseImplResultSet = dB2ImplStatement.getNextResultSet();
            baseImplResultSet.setImplStatement(dB2ImplStatement);
            baseImplResultSet.setWarnings(this.con.warnings);
            if (baseImplResultSet.fetchAtPosition(0)) {
                baseImplResultSet.getData(1, 1).getString(10, this.con.exceptions);
            } else {
                this.detectedProblem = true;
                this.replaceForProblem = true;
            }
            baseImplResultSet.close();
            dB2ImplStatement.close();
            return 200;
        }
        if (this.comm.serverOS == 3) {
            string = "SELECT COUNT(*)-1 FROM SYSIBM.SYSPACKSTMT WHERE NAME ='DDJU360C' and COLLID = '" + this.con.collectionId.toUpperCase() + "' AND LOCATION = '' union all SELECT COUNT(*)-1 FROM SYSIBM.SYSPACKSTMT WHERE NAME ='DDJU" + vrm + "B' and COLLID = '" + this.con.collectionId.toUpperCase() + "' AND LOCATION = ''";
            DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.con.createImplStatement(1000, 1003);
            dB2ImplStatement.setup(this.con, this.con.warnings);
            dB2ImplStatement.setSQL(new BaseSQL(string, 0, this.con.quotingChar, this.con.intoIsOptional, new DB2EscapeTranslator(this.con), this.con.exceptions));
            dB2ImplStatement.execute();
            dB2ImplStatement.getNextResultType();
            BaseImplResultSet baseImplResultSet = dB2ImplStatement.getNextResultSet();
            baseImplResultSet.setImplStatement(dB2ImplStatement);
            baseImplResultSet.setWarnings(this.con.warnings);
            int n = 0;
            if (baseImplResultSet.fetchAtPosition(0)) {
                if (baseImplResultSet.getData(1, 4).getInteger(this.con.exceptions) != 2) {
                    this.detectedProblem = true;
                }
            } else {
                this.detectedProblem = true;
            }
            if (baseImplResultSet.fetchAtPosition(1)) {
                n = baseImplResultSet.getData(1, 4).getInteger(this.con.exceptions);
            } else {
                this.detectedProblem = true;
            }
            baseImplResultSet.close();
            dB2ImplStatement.close();
            return n;
        }
        string = "SELECT count(*), TOTALSECT FROM SYSIBM.SYSPLAN WHERE NAME like 'DDJ_360_' AND CREATOR = '" + this.con.collectionId.toUpperCase() + "' GROUP BY TOTALSECT order by TOTALSECT desc";
        DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.con.createImplStatement(1000, 1003);
        dB2ImplStatement.setup(this.con, this.con.warnings);
        dB2ImplStatement.setSQL(new BaseSQL(string, 0, this.con.quotingChar, this.con.intoIsOptional, new DB2EscapeTranslator(this.con), this.con.exceptions));
        dB2ImplStatement.execute();
        dB2ImplStatement.getNextResultType();
        BaseImplResultSet baseImplResultSet = dB2ImplStatement.getNextResultSet();
        baseImplResultSet.setImplStatement(dB2ImplStatement);
        baseImplResultSet.setWarnings(this.con.warnings);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (baseImplResultSet.fetchAtPosition(0)) {
            n = baseImplResultSet.getData(1, 4).getInteger(this.con.exceptions);
            n3 = baseImplResultSet.getData(2, 4).getInteger(this.con.exceptions);
            if (n < 8) {
                this.detectedProblem = true;
            }
        } else {
            this.detectedProblem = true;
        }
        if (this.comm.serverType == 8) {
            if (baseImplResultSet.fetchAtPosition(1)) {
                n2 = baseImplResultSet.getData(1, 4).getInteger(this.con.exceptions);
                if (n2 < 4) {
                    this.detectedProblem = true;
                }
            } else {
                this.detectedProblem = true;
            }
        }
        baseImplResultSet.close();
        dB2ImplStatement.close();
        return n3;
    }

    private int createPackageSet() throws SQLException {
        try {
            String string = "DDJ";
            MessageFormat messageFormat = new MessageFormat("DECLARE C0{0} CURSOR FOR S0{0}");
            MessageFormat messageFormat2 = new MessageFormat("DECLARE C0{0} CURSOR WITH HOLD FOR S0{0}");
            String string2 = "CALL :H";
            String string3 = "CALL :H USING DESCRIPTOR :H";
            StringBuffer stringBuffer = null;
            int n = this.dynamicSections;
            Object[] objectArray = new Object[]{new Integer(1)};
            boolean bl = Boolean.valueOf(this.replacePackage);
            if (this.replaceForProblem) {
                bl = true;
            }
            if (this.comm.bindsPackagesAsSQLAMv6) {
                this.loginRequest.workAroundv8Bug = true;
                this.loginRequest.submitRequest();
                this.loginRequest.processReply(this.con.warnings);
                this.comm.setServerInfo();
                this.comm.fixSQLAMLevels();
            }
            if (this.comm.serverOS != 3 && this.comm.serverOS != 8) {
                bl = true;
            }
            DRDABindRequest dRDABindRequest = new DRDABindRequest(this.con, this.comm, this.con.dataReader, this.con.dataWriter, this.databaseName, this.collectionId, "", this.defaultQualifier, this.packageOwner, "1", bl);
            for (int i = 0; i < this.suffix.length; ++i) {
                for (int j = 0; j < this.isoLvl.length; ++j) {
                    if (this.isoLvl[j] == "N" && (this.isoLvl[j] != "N" || this.comm.serverOS != 8) || this.suffix[i] == "C" && (this.suffix[i] != "C" || this.comm.enableRealStoredProcPrepare)) continue;
                    string = "DDJ" + this.isoLvl[j] + vrm + this.suffix[i];
                    dRDABindRequest.setPackageName(string);
                    dRDABindRequest.setIsoLvl(this.isoLvl[j]);
                    dRDABindRequest.writeBGNBND();
                    dRDABindRequest.submitRequest();
                    try {
                        dRDABindRequest.processReply(this.con.warnings);
                    }
                    catch (SQLException sQLException) {
                        dRDABindRequest.clearExceptions();
                        bl = !bl;
                        dRDABindRequest.setReplace(bl);
                        dRDABindRequest.writeBGNBND();
                        dRDABindRequest.submitRequest();
                    }
                    if (this.suffix[i] == "A") {
                        for (int k = 1; k <= n; ++k) {
                            objectArray[0] = new Integer(k);
                            stringBuffer = new StringBuffer(messageFormat.format(objectArray));
                            for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
                                if (stringBuffer.charAt(i2) != ',' && stringBuffer.charAt(i2) != '.' && stringBuffer.charAt(i2) != '\u00a0') continue;
                                stringBuffer.deleteCharAt(i2);
                            }
                            dRDABindRequest.writeBNDSQLSTT(stringBuffer.toString(), k, null);
                            dRDABindRequest.submitRequest();
                            dRDABindRequest.processReply(this.con.warnings);
                        }
                        dRDABindRequest.writeENDBND(this.dynamicSections);
                    } else if (this.suffix[i] == "B") {
                        for (int k = 1; k <= n; ++k) {
                            objectArray[0] = new Integer(k);
                            stringBuffer = new StringBuffer(messageFormat2.format(objectArray));
                            for (int i3 = 0; i3 < stringBuffer.length(); ++i3) {
                                if (stringBuffer.charAt(i3) != ',' && stringBuffer.charAt(i3) != '.' && stringBuffer.charAt(i3) != '\u00a0') continue;
                                stringBuffer.deleteCharAt(i3);
                            }
                            dRDABindRequest.writeBNDSQLSTT(stringBuffer.toString(), k, null);
                            dRDABindRequest.submitRequest();
                            dRDABindRequest.processReply(this.con.warnings);
                        }
                        dRDABindRequest.writeENDBND(this.dynamicSections);
                    } else if (this.suffix[i] == "C") {
                        BaseParameters baseParameters = new BaseParameters(1, this.con.exceptions, (BaseConnection)this.con.db2Connection);
                        baseParameters.set(1, 1, new BaseParameter(1, 10, "spName", this.con.db2Connection));
                        dRDABindRequest.writeBNDSQLSTT(string2, 1, baseParameters);
                        dRDABindRequest.submitRequest();
                        dRDABindRequest.processReply(this.con.warnings);
                        BaseParameters baseParameters2 = new BaseParameters(2, this.con.exceptions, (BaseConnection)this.con.db2Connection);
                        baseParameters2.set(1, 1, new BaseParameter(1, 10, "spName", this.con.db2Connection));
                        baseParameters2.set(2, 1, new BaseParameter(1111, 10, "spSqlDa", this.con.db2Connection));
                        dRDABindRequest.writeBNDSQLSTT(string3, 2, baseParameters2);
                        dRDABindRequest.submitRequest();
                        dRDABindRequest.processReply(this.con.warnings);
                        dRDABindRequest.writeENDBND(2);
                    }
                    dRDABindRequest.submitRequest();
                    dRDABindRequest.processReply(this.con.warnings);
                    this.con.transactionRequest.submitRequest(1);
                    this.con.transactionRequest.processReply(this.con.warnings);
                }
            }
            if (this.comm.bindsPackagesAsSQLAMv6) {
                this.loginRequest.workAroundv8Bug = false;
                this.loginRequest.submitRequest();
                this.loginRequest.processReply(this.con.warnings);
                this.comm.setServerInfo();
                this.comm.fixSQLAMLevels();
            }
            this.packagesCreated = true;
            return n;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    private void grantPackagePrivileges() throws SQLException {
        DRDAPkgNamCsn dRDAPkgNamCsn = new DRDAPkgNamCsn(this.databaseName, this.collectionId, SDDJCVRMA, 1, null);
        DRDAExecuteStatementRequest dRDAExecuteStatementRequest = new DRDAExecuteStatementRequest(this.con, this.comm, this.con.dataReader, this.con.dataWriter, null, dRDAPkgNamCsn);
        String string = "DDJ";
        for (int i = 0; i < this.suffix.length; ++i) {
            for (int j = 0; j < this.isoLvl.length; ++j) {
                if (this.isoLvl[j] == "N" && (this.isoLvl[j] != "N" || this.comm.serverOS != 8) || this.suffix[i] == "C" && (this.suffix[i] != "C" || this.comm.enableRealStoredProcPrepare)) continue;
                string = "DDJ" + this.isoLvl[j] + vrm + this.suffix[i];
                String string2 = "GRANT EXECUTE ON PACKAGE " + this.collectionId + "." + string + " TO " + this.grantee.toUpperCase();
                dRDAExecuteStatementRequest.writeEXCSQLIMM(string2, 0);
                dRDAExecuteStatementRequest.submitRequest();
                dRDAExecuteStatementRequest.processMode = 2;
                dRDAExecuteStatementRequest.processReply(this.con.warnings);
            }
        }
    }

    public int getAvailableSectionNumber(boolean bl, boolean bl2) throws SQLException {
        int n = 0;
        if (!this.isInitialized) {
            return 1;
        }
        switch (this.con.transactionIsolationLevel) {
            case 0: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJNVRMC[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJNVRMC[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJNVRMB_last = n = this.searchForFreeSection(this.DDJNVRMB, this.DDJNVRMB_last);
                    break;
                }
                this.DDJNVRMA_last = n = this.searchForFreeSection(this.DDJNVRMA, this.DDJNVRMA_last);
                break;
            }
            case 2: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJCVRMC[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJCVRMC[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJCVRMB_last = n = this.searchForFreeSection(this.DDJCVRMB, this.DDJCVRMB_last);
                    break;
                }
                this.DDJCVRMA_last = n = this.searchForFreeSection(this.DDJCVRMA, this.DDJCVRMA_last);
                break;
            }
            case 1: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJUVRMC[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJUVRMC[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJUVRMB_last = n = this.searchForFreeSection(this.DDJUVRMB, this.DDJUVRMB_last);
                    break;
                }
                this.DDJUVRMA_last = n = this.searchForFreeSection(this.DDJUVRMA, this.DDJUVRMA_last);
                break;
            }
            case 4: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJRVRMC[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJRVRMC[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJRVRMB_last = n = this.searchForFreeSection(this.DDJRVRMB, this.DDJRVRMB_last);
                    break;
                }
                this.DDJRVRMA_last = n = this.searchForFreeSection(this.DDJRVRMA, this.DDJRVRMA_last);
                break;
            }
            case 8: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJSVRMC[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJSVRMC[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJSVRMB_last = n = this.searchForFreeSection(this.DDJSVRMB, this.DDJSVRMB_last);
                    break;
                }
                this.DDJSVRMA_last = n = this.searchForFreeSection(this.DDJSVRMA, this.DDJSVRMA_last);
            }
        }
        return n;
    }

    public String getPackageName(boolean bl) throws SQLException {
        String string = null;
        switch (this.con.transactionIsolationLevel) {
            case 0: {
                if (bl) {
                    string = SDDJNVRMC;
                    break;
                }
                if (this.withHoldCursors) {
                    string = SDDJNVRMB;
                    break;
                }
                string = SDDJNVRMA;
                break;
            }
            case 2: {
                if (bl) {
                    string = SDDJCVRMC;
                    break;
                }
                if (this.withHoldCursors) {
                    string = SDDJCVRMB;
                    break;
                }
                string = SDDJCVRMA;
                break;
            }
            case 1: {
                if (bl) {
                    string = SDDJUVRMC;
                    break;
                }
                if (this.withHoldCursors) {
                    string = SDDJUVRMB;
                    break;
                }
                string = SDDJUVRMA;
                break;
            }
            case 4: {
                if (bl) {
                    string = SDDJRVRMC;
                    break;
                }
                if (this.withHoldCursors) {
                    string = SDDJRVRMB;
                    break;
                }
                string = SDDJRVRMA;
                break;
            }
            case 8: {
                string = bl ? SDDJSVRMC : (this.withHoldCursors ? SDDJSVRMB : SDDJSVRMA);
            }
        }
        return string;
    }

    private int searchForFreeSection(int[] nArray, int n) throws SQLException {
        int n2;
        int n3 = -1;
        if (this.comm.serverType == 8) {
            n = 0;
        }
        for (n2 = n; n2 < this.dynamicSections; ++n2) {
            if (nArray[n2] != -1) continue;
            n3 = n2;
            nArray[n2] = 1;
            break;
        }
        if (n3 == -1 && n > 0) {
            for (n2 = 0; n2 < this.dynamicSections; ++n2) {
                if (nArray[n2] != -1) continue;
                n3 = n2;
                nArray[n2] = 1;
                break;
            }
        }
        if (this.dynamicSections == 0 || n3 == -1) {
            throw this.comm.exceptions.getException(7070);
        }
        return n3 + 1;
    }

    public void updatePackageSections() {
        if (!this.isInitialized) {
            return;
        }
        for (int i = 0; i < this.secs.length; ++i) {
            int[] nArray = (int[])this.secs[i];
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] == 2) {
                    nArray[j] = -1;
                    continue;
                }
                if (nArray[j] != 1 || this.comm.serverOS != 8 && this.comm.serverOS != 3) continue;
                nArray[j] = 3;
            }
        }
    }

    public boolean isSectionMarkedForPrepare(DRDAPkgNamCsn dRDAPkgNamCsn) {
        if (dRDAPkgNamCsn == null || dRDAPkgNamCsn.sectionNumber == 0 || dRDAPkgNamCsn.packageName == null || !this.isInitialized) {
            return false;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMB)) {
            return this.DDJCVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMA)) {
            return this.DDJCVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMC)) {
            return this.DDJCVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMB)) {
            return this.DDJRVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMA)) {
            return this.DDJRVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMC)) {
            return this.DDJRVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMB)) {
            return this.DDJSVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMA)) {
            return this.DDJSVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMC)) {
            return this.DDJSVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMB)) {
            return this.DDJUVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMA)) {
            return this.DDJUVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMC)) {
            return this.DDJUVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMB)) {
            return this.DDJNVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMA)) {
            return this.DDJNVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMC)) {
            return this.DDJNVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        return false;
    }

    public boolean isSectionMarkedInUse(DRDAPkgNamCsn dRDAPkgNamCsn) {
        if (dRDAPkgNamCsn == null || dRDAPkgNamCsn.sectionNumber == 0 || dRDAPkgNamCsn.packageName == null || !this.isInitialized) {
            return false;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMB)) {
            return this.DDJCVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMA)) {
            return this.DDJCVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMC)) {
            return this.DDJCVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMB)) {
            return this.DDJRVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMA)) {
            return this.DDJRVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMC)) {
            return this.DDJRVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMB)) {
            return this.DDJSVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMA)) {
            return this.DDJSVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMC)) {
            return this.DDJSVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMB)) {
            return this.DDJUVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMA)) {
            return this.DDJUVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMC)) {
            return this.DDJUVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMB)) {
            return this.DDJNVRMB[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMA)) {
            return this.DDJNVRMA[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMC)) {
            return this.DDJNVRMC[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        return false;
    }

    public void freeThisSectionNumber(DRDAPkgNamCsn dRDAPkgNamCsn) throws SQLException {
        if (!this.isInitialized || dRDAPkgNamCsn == null || dRDAPkgNamCsn.sectionNumber == 0) {
            return;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMB)) {
            this.DDJCVRMB[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMA)) {
            this.DDJCVRMA[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMC)) {
            this.DDJCVRMC[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMB)) {
            this.DDJRVRMB[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMA)) {
            this.DDJRVRMA[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMC)) {
            this.DDJRVRMC[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMB)) {
            this.DDJSVRMB[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMA)) {
            this.DDJSVRMA[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMC)) {
            this.DDJSVRMC[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMB)) {
            this.DDJUVRMB[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMA)) {
            this.DDJUVRMA[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMC)) {
            this.DDJUVRMC[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMB)) {
            this.DDJNVRMB[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMA)) {
            this.DDJNVRMA[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMC)) {
            this.DDJNVRMC[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        }
    }

    public void markThisSectionNumber(DRDAPkgNamCsn dRDAPkgNamCsn, int n) throws SQLException {
        if (dRDAPkgNamCsn == null || dRDAPkgNamCsn.sectionNumber == 0 || !this.isInitialized) {
            return;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMB)) {
            if (this.DDJCVRMB[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJCVRMB[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMA)) {
            if (this.DDJCVRMA[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJCVRMA[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJCVRMC)) {
            if (this.DDJCVRMC[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJCVRMC[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMB)) {
            if (this.DDJRVRMB[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJRVRMB[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMA)) {
            if (this.DDJRVRMA[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJRVRMA[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJRVRMC)) {
            if (this.DDJRVRMC[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJRVRMC[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMB)) {
            if (this.DDJSVRMB[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJSVRMB[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMA)) {
            if (this.DDJSVRMA[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJSVRMA[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJSVRMC)) {
            if (this.DDJSVRMC[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJSVRMC[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMB)) {
            if (this.DDJUVRMB[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJUVRMB[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMA)) {
            if (this.DDJUVRMA[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJUVRMA[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJUVRMC)) {
            if (this.DDJUVRMC[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJUVRMC[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMB)) {
            if (this.DDJNVRMB[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJNVRMB[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMA)) {
            if (this.DDJNVRMA[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJNVRMA[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase(SDDJNVRMC)) {
            if (this.DDJNVRMC[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJNVRMC[dRDAPkgNamCsn.sectionNumber - 1] = n;
        }
    }
}

