/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.ProcedureContainer;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StoredProcedure
extends ProcedureContainer {
    private Map mapOfParameters = new TreeMap();
    private Integer resultSetParameterKey;
    private boolean returnsResults;
    private String procedureName;
    private Object procedureID;
    private Object modelID;
    private String callableName;
    private boolean returnsScalarValue;
    private GroupSymbol group;
    private boolean displayNamedParameters = false;

    public int getType() {
        return 6;
    }

    private SPParameter getResultSetParameter() {
        if (this.resultSetParameterKey != null) {
            return (SPParameter)this.mapOfParameters.get(this.resultSetParameterKey);
        }
        return null;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String getProcedureCallableName() {
        return this.callableName;
    }

    public void setProcedureCallableName(String callableName) {
        this.callableName = callableName;
    }

    public Object getModelID() {
        return this.modelID;
    }

    public void setModelID(Object modelID) {
        this.modelID = modelID;
    }

    public void setProcedureID(Object procedureID) {
        this.procedureID = procedureID;
    }

    public Object getProcedureID() {
        return this.procedureID;
    }

    public void setParameter(SPParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0011"));
        }
        Integer key = new Integer(parameter.getIndex());
        if (parameter.getParameterType() == 5) {
            this.resultSetParameterKey = key;
        } else if (parameter.getParameterType() == 4) {
            this.returnsScalarValue = true;
        }
        this.mapOfParameters.put(key, parameter);
    }

    public List getParameters() {
        ArrayList listOfParameters = new ArrayList(this.mapOfParameters.values());
        return listOfParameters;
    }

    public SPParameter getParameter(int index) {
        return (SPParameter)this.mapOfParameters.get(new Integer(index));
    }

    public int getNumberOfColumns() {
        SPParameter resultSetParameter = this.getResultSetParameter();
        if (resultSetParameter != null) {
            return resultSetParameter.getResultSetColumns().size();
        }
        return 0;
    }

    public ElementSymbol getResultSetColumn(int index) {
        SPParameter resultSetParameter = this.getResultSetParameter();
        if (resultSetParameter != null) {
            return resultSetParameter.getResultSetColumn(index);
        }
        return null;
    }

    public List getResultSetColumns() {
        SPParameter resultSetParameter = this.getResultSetParameter();
        if (resultSetParameter != null) {
            LinkedList<ElementSymbol> result = new LinkedList<ElementSymbol>();
            Iterator i = resultSetParameter.getResultSetColumns().iterator();
            while (i.hasNext()) {
                ElementSymbol symbol = (ElementSymbol)((ElementSymbol)i.next()).clone();
                symbol.setGroupSymbol(this.getGroup());
                result.add(symbol);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        StoredProcedure copy = new StoredProcedure();
        copy.setModelID(this.getModelID());
        copy.setProcedureName(this.getProcedureName());
        copy.setProcedureCallableName(this.getProcedureCallableName());
        copy.setReturnsResults(this.returnsResults());
        copy.returnsScalarValue = this.returnsScalarValue();
        copy.setProcedureID(this.getProcedureID());
        copy.setGroup((GroupSymbol)this.getGroup().clone());
        if (this.getTemporaryMetadata() != null) {
            copy.setTemporaryMetadata(new HashMap(this.getTemporaryMetadata()));
        }
        copy.callableName = this.callableName;
        List params = this.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            copy.setParameter((SPParameter)params.get(i));
        }
        copy.resultSetParameterKey = this.resultSetParameterKey;
        this.copyMetadataState(copy);
        copy.setIsResolved(this.isResolved());
        if (this.group != null) {
            copy.setGroup((GroupSymbol)this.group.clone());
        }
        copy.displayNamedParameters = this.displayNamedParameters;
        return copy;
    }

    public void setReturnsResults(boolean returnsResults) {
        this.returnsResults = returnsResults;
    }

    public boolean returnsResults() {
        return this.returnsResults;
    }

    public boolean returnsResultSet() {
        return !this.getResultSetColumns().isEmpty();
    }

    public boolean returnsScalarValue() {
        return this.returnsScalarValue;
    }

    public List getProjectedSymbols() {
        ElementSymbol symbol;
        SPParameter parameter;
        ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>();
        List rsColumns = this.getResultSetColumns();
        result.addAll(rsColumns);
        Iterator iter = this.mapOfParameters.values().iterator();
        while (iter.hasNext()) {
            parameter = (SPParameter)iter.next();
            if (parameter.getParameterType() != 3 && parameter.getParameterType() != 2) continue;
            symbol = parameter.getParameterSymbol();
            symbol.setGroupSymbol(this.getGroup());
            result.add(symbol);
        }
        iter = this.mapOfParameters.values().iterator();
        while (iter.hasNext()) {
            parameter = (SPParameter)iter.next();
            if (parameter.getParameterType() != 4) continue;
            symbol = parameter.getParameterSymbol();
            symbol.setGroupSymbol(this.getGroup());
            result.add(symbol);
            break;
        }
        return result;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public void clearParameters() {
        this.mapOfParameters.clear();
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public GroupSymbol getGroup() {
        if (this.group == null) {
            return new GroupSymbol(this.getProcedureName());
        }
        return this.group;
    }

    public boolean areResultsCachable() {
        return true;
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        if (this.getContainedCommands().isEmpty()) {
            return 1;
        }
        return this.getSubCommandsUpdatingModelCount(metadata);
    }

    public boolean displayNamedParameters() {
        return this.displayNamedParameters;
    }

    public void setDisplayNamedParameters(boolean displayNamedParameters) {
        this.displayNamedParameters = displayNamedParameters;
    }

    public String getParamFullName(SPParameter param) {
        String paramName = param.getName();
        if (paramName.lastIndexOf(".") < 0) {
            paramName = this.getProcedureName() + "." + paramName;
        }
        return paramName;
    }

    public List getInputParameters() {
        List parameters = this.getParameters();
        Iterator params = parameters.iterator();
        while (params.hasNext()) {
            SPParameter param = (SPParameter)params.next();
            if (param.getParameterType() == 1 || param.getParameterType() == 3) continue;
            params.remove();
        }
        return parameters;
    }

    public boolean isProcedureRelational() {
        List inputs = this.getInputParameters();
        if (inputs.size() == 0) {
            return false;
        }
        Iterator params = inputs.iterator();
        while (params.hasNext()) {
            SPParameter param = (SPParameter)params.next();
            ElementSymbol symbol = param.getParameterSymbol();
            Expression input = param.getExpression();
            if (!(input instanceof Reference)) {
                return false;
            }
            Reference reference = (Reference)input;
            if (symbol.equals(reference.getExpression())) continue;
            return false;
        }
        return true;
    }
}

