/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.log;

import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.util.DateUtil;
import com.metamatrix.common.xa.CommonXAPlugin;
import com.metamatrix.common.xa.log.TransactionLogMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;

public class TransactionLogWriter {
    public static final String TRANSACTION_LOG_STATEMENT = "INSERT INTO TX_TXNLOG (TXNUID,TXNPOINT,TXN_STATUS,SESSIONUID,PRINCIPAL_NA,VDBNAME,VDBVERSION,CREATED_TS,ENDED_TS) VALUES (?,?,?,?,?,?,?,?,?)";
    public static final String MMX_COMMAND_LOG_STATEMENT = "INSERT INTO TX_MMXCMDLOG (REQUESTID,TXNUID,CMDPOINT,CMD_STATUS,SESSIONUID,APP_NAME,PRINCIPAL_NA,VDBNAME,VDBVERSION,CREATED_TS,ENDED_TS,FINL_ROWCNT,SQL_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final String SQL_LOG_STATEMENT = "INSERT INTO TX_SQL (SQL_ID,SQL_VL) VALUES (?,?)";
    public static final String SRC_COMMAND_LOG_STATEMENT = "INSERT INTO TX_SRCCMDLOG (REQUESTID,NODEID,SUBTXNUID,CMD_STATUS,MDL_NM,CNCTRNAME,CMDPOINT,SESSIONUID,PRINCIPAL_NA,CREATED_TS,ENDED_TS,SQL_ID,FINL_ROWCNT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final int DEFAULT_MAX_VDB_NAME_LENGTH = 255;
    public static final int DEFAULT_MAX_VDB_VERSION_LENGTH = 50;
    public static final int DEFAULT_MAX_CNCTR_NAME_LENGTH = 255;
    public static final int DEFAULT_MAX_MDL_NAME_LENGTH = 255;
    public static final int DEFAULT_MAX_SQL_LENGTH = 512;
    private static final int WRITE_RETRIES = 3;
    private static final int RESUME_LOGGING_AFTER_TIME = 180000;
    private Properties connProps;
    private boolean isLogSuspended = false;
    private long resumeTime = -1L;
    private boolean shutdown = false;

    public void initialize(Properties props) {
        this.connProps = props;
    }

    protected Connection getConnection() throws SQLException {
        Connection connection = null;
        try {
            connection = JDBCConnectionPoolHelper.getConnection((Properties)this.connProps, (String)"TRANSACTION_LOGGING");
        }
        catch (ResourcePoolException err) {
            throw new SQLException(err.getMessage());
        }
        return connection;
    }

    public void print(TransactionLogMessage message) {
        int retrycnt = 0;
        if (this.isLogSuspended && System.currentTimeMillis() > this.resumeTime) {
            this.resumeLogging();
        }
        while (!this.isLogSuspended && !this.shutdown) {
            try {
                this.printMsg(message);
                return;
            }
            catch (SQLException t) {
                if (retrycnt >= 3) {
                    this.isLogSuspended = true;
                    this.resumeTime = System.currentTimeMillis() + 180000L;
                    Date rd = new Date(this.resumeTime);
                    String stringDate = DateUtil.getDateAsString(rd);
                    LogManager.logError("TXN_LOG", (Throwable)t, CommonXAPlugin.Util.getString("TransactionLogWriter.Transaction_Logging_has_been_suspended", stringDate));
                } else {
                    LogManager.logWarning("TXN_LOG", (Throwable)t, t.getMessage());
                }
                ++retrycnt;
            }
        }
        LogManager.logCritical("TXN_LOG", CommonXAPlugin.Util.getString("TransactionLogWriter.Transaction_Logging_message_while_suspended", message.toString()));
    }

    private void resumeLogging() {
        this.isLogSuspended = false;
        this.resumeTime = -1L;
        Date rd = new Date(System.currentTimeMillis());
        String stringDate = DateUtil.getDateAsString(rd);
        LogManager.logInfo("TXN_LOG", CommonXAPlugin.Util.getString("TransactionLogWriter.Transaction_Logging_has_been_resumed", stringDate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMsg(TransactionLogMessage message) throws SQLException {
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            short dest = message.getDestinationTable();
            switch (dest) {
                case 0: {
                    ps = con.prepareStatement(TRANSACTION_LOG_STATEMENT);
                    ps.setString(1, message.getTxnUid());
                    ps.setShort(2, message.getPoint());
                    ps.setShort(3, message.getStatus());
                    ps.setString(4, message.getSessionUid());
                    ps.setString(5, message.getPrincipal());
                    ps.setString(6, TransactionLogWriter.truncString(message.getVdbName(), 255));
                    ps.setString(7, TransactionLogWriter.truncString(message.getVdbVersion(), 50));
                    ps.setString(8, message.getBeginTimeStamp());
                    ps.setString(9, message.getEndTimeStamp());
                    ps.executeUpdate();
                    break;
                }
                case 1: {
                    ps = con.prepareStatement(MMX_COMMAND_LOG_STATEMENT);
                    ps.setString(1, message.getRequestId());
                    ps.setString(2, message.getTxnUid());
                    ps.setShort(3, message.getPoint());
                    ps.setShort(4, message.getStatus());
                    ps.setString(5, message.getSessionUid());
                    ps.setString(6, message.getApplicationName());
                    ps.setString(7, message.getPrincipal());
                    ps.setString(8, TransactionLogWriter.truncString(message.getVdbName(), 255));
                    ps.setString(9, TransactionLogWriter.truncString(message.getVdbVersion(), 50));
                    ps.setString(10, message.getBeginTimeStamp());
                    ps.setString(11, message.getEndTimeStamp());
                    if (message.getRowCount() < 0) {
                        ps.setNull(12, 4);
                    } else {
                        ps.setInt(12, message.getRowCount());
                    }
                    if (message.getSql() == null) {
                        ps.setLong(13, -1L);
                        ps.executeUpdate();
                        break;
                    }
                    long sqlId = this.getNextSqlID();
                    ps.setLong(13, sqlId);
                    ps.executeUpdate();
                    this.insertSqlValue(sqlId, message.getSql(), con);
                    break;
                }
                case 2: {
                    ps = con.prepareStatement(SRC_COMMAND_LOG_STATEMENT);
                    ps.setString(1, message.getRequestId());
                    ps.setLong(2, message.getType());
                    ps.setString(3, message.getSubTxnUid());
                    ps.setShort(4, message.getStatus());
                    ps.setString(5, TransactionLogWriter.truncString(message.getModelName(), 255));
                    ps.setString(6, TransactionLogWriter.truncString(message.getConnectorBindingName(), 255));
                    ps.setShort(7, message.getPoint());
                    ps.setString(8, message.getSessionUid());
                    ps.setString(9, message.getPrincipal());
                    ps.setString(10, message.getBeginTimeStamp());
                    ps.setString(11, message.getEndTimeStamp());
                    if (message.getSql() == null) {
                        ps.setLong(12, -1L);
                        ps.setInt(13, message.getRowCount());
                        ps.executeUpdate();
                        break;
                    }
                    long sqlId = this.getNextSqlID();
                    ps.setLong(12, sqlId);
                    ps.setInt(13, message.getRowCount());
                    ps.executeUpdate();
                    this.insertSqlValue(sqlId, message.getSql(), con);
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                LogManager.logWarning("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0037", ex.getMessage()));
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                LogManager.logWarning("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0038", ex.getMessage()));
            }
            throw throwable;
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException ex) {
            LogManager.logWarning("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0037", ex.getMessage()));
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException ex) {
            LogManager.logWarning("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0038", ex.getMessage()));
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public static String truncString(String in, int len) {
        if (in != null && in.length() > len) {
            in = in.substring(0, len);
        }
        return in;
    }

    private long getNextSqlID() throws SQLException {
        try {
            return DBIDGenerator.getID((String)"TX_SQL");
        }
        catch (DBIDGeneratorException e) {
            throw new SQLException(CommonXAPlugin.Util.getString("ERR.003.031.0039"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSqlValue(long sqlID, String sqlValue, Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(SQL_LOG_STATEMENT);
            ps.setLong(1, sqlID);
            ps.setString(2, sqlValue);
            if (ps.executeUpdate() != 1) {
                throw new SQLException(CommonXAPlugin.Util.getString("ERR.003.031.0040"));
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                LogManager.logWarning("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0037", ex.getMessage()));
            }
            throw throwable;
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException ex) {
            LogManager.logWarning("TXN_LOG", CommonXAPlugin.Util.getString("ERR.003.031.0037", ex.getMessage()));
        }
    }
}

