/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Reference
implements Expression {
    private int refIndex;
    private Expression expression;
    private boolean correlated;
    private boolean positional;
    private transient Map elements;
    private transient List tuple;

    public Reference(int refIndex) {
        this.refIndex = refIndex;
        this.positional = true;
    }

    public Reference(int refIndex, Expression expression) {
        this.refIndex = refIndex;
        this.expression = expression;
        this.positional = false;
    }

    public boolean isResolved() {
        return this.expression != null;
    }

    public int getIndex() {
        return this.refIndex;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Class getType() {
        if (this.expression == null) {
            return null;
        }
        return this.expression.getType();
    }

    public void setData(Map elements, List tuple) {
        this.elements = elements;
        this.tuple = tuple;
    }

    public Map getDataElements() {
        return this.elements;
    }

    public List getTuple() {
        return this.tuple;
    }

    public Object getValue() throws ExpressionEvaluationException, MetaMatrixComponentException {
        return ExpressionEvaluator.evaluate((Expression)this.expression, (Map)this.elements, (List)this.tuple);
    }

    public Object getValue(LookupEvaluator dataMgr, CommandContext context) throws ExpressionEvaluationException, MetaMatrixComponentException {
        if (this.elements == null) {
            this.elements = Collections.EMPTY_MAP;
        }
        return ExpressionEvaluator.evaluate((Expression)this.expression, (Map)this.elements, (List)this.tuple, (LookupEvaluator)dataMgr, (CommandContext)context);
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Reference other = (Reference)obj;
        if (this.positional != other.positional) {
            return false;
        }
        if (this.positional) {
            return other.getIndex() == this.getIndex();
        }
        return this.expression.equals(other.expression);
    }

    public int hashCode() {
        return this.getIndex();
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean isCorrelated() {
        return this.correlated;
    }

    public void setCorrelated(boolean correlated) {
        this.correlated = correlated;
    }

    public void setValue(Object value) {
        HashMap<Expression, Integer> symbolMap = new HashMap<Expression, Integer>(1);
        symbolMap.put(this.getExpression(), new Integer(0));
        if (value instanceof Constant) {
            value = ((Constant)value).getValue();
        }
        this.setData(symbolMap, Arrays.asList(value));
    }

    public boolean isPositional() {
        return this.positional;
    }

    public void setPositional(boolean positional) {
        this.positional = positional;
    }
}

