/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.proxy;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInterceptorStack;
import com.metamatrix.core.proxy.ServiceInvocation;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ServiceInvocationHandler
implements InvocationHandler {
    private ServiceInterceptor[] interceptors;
    private TerminalServiceInterceptor lastInterceptor;

    public ServiceInvocationHandler(ServiceInterceptor[] interceptors, TerminalServiceInterceptor lastInterceptor) {
        this.interceptors = interceptors;
        this.lastInterceptor = lastInterceptor;
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        if (arguments == null) {
            arguments = new Object[]{};
        }
        try {
            ServiceInterceptorStack stack = new ServiceInterceptorStack(this.interceptors, this.lastInterceptor);
            ServiceInvocation invocation = new ServiceInvocation(method, arguments, stack);
            return invocation.invokeNext();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw t;
            }
            Class<?>[] declaredExceptionTypes = method.getExceptionTypes();
            for (int i = 0; i < declaredExceptionTypes.length; ++i) {
                if (!declaredExceptionTypes[i].isAssignableFrom(t.getClass())) continue;
                throw t;
            }
            throw new MetaMatrixRuntimeException(t);
        }
    }
}

