/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_ODNY;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class TTIDCBDataPacket
extends TTIFUNDataPacket {
    private static String footprint = "$Revision:   1.2.2.0  $";
    private OracleImplConnection m_connection;
    private BaseColumn[] m_columns;

    public TTIDCBDataPacket(OracleImplConnection oracleImplConnection) {
        this.TTCCode = 3;
        this.FUNCode = 16;
        this.m_connection = oracleImplConnection;
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        oracleDataProvider.skipCLR();
        int n = oracleDataProvider.readB4();
        this.ColumnsStreamIn(oracleDataProvider);
    }

    public void ColumnsStreamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        short s = oracleDataProvider.readB2();
        this.m_columns = new BaseColumn[s];
        byte by = oracleDataProvider.readByte();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            BaseColumn baseColumn;
            this.m_columns[s2] = baseColumn = TTIFUN_ODNY.readColumn(this.m_connection, oracleDataProvider);
        }
        oracleDataProvider.skipVCS();
        if (this.m_connection.oracleServerVersion >= 1000000000L) {
            oracleDataProvider.readB4();
            oracleDataProvider.readB4();
        }
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
    }

    public BaseColumn[] getColumns() {
        return this.m_columns;
    }
}

