/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.io.Serializable;

public final class GranteeEntitlementEntry
implements Serializable,
Comparable {
    private MetaMatrixPrincipalName grantee;
    private String grantor;
    private AuthorizationActions allowedActions;
    private String identifier;

    public GranteeEntitlementEntry(MetaMatrixPrincipalName grantee, String grantor, int allowedActions) {
        this.grantee = grantee;
        this.grantor = grantor;
        this.allowedActions = StandardAuthorizationActions.getAuthorizationActions(allowedActions);
        this.generateIdentity();
    }

    public GranteeEntitlementEntry(MetaMatrixPrincipalName grantee, GranteeEntitlementEntry clone) {
        this.grantee = grantee;
        this.grantor = clone.grantor;
        this.allowedActions = clone.allowedActions;
        this.generateIdentity();
    }

    public String getGrantee() {
        return this.grantee.getName();
    }

    public boolean isUserGroup() {
        return this.grantee.getType() == 1;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public String[] getAllowedActions() {
        return this.allowedActions.getLabels();
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GranteeEntitlementEntry) {
            GranteeEntitlementEntry that = (GranteeEntitlementEntry)obj;
            return GranteeEntitlementEntry.compare(this, that) == 0;
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0045"));
        }
        if (!(o instanceof GranteeEntitlementEntry)) {
            throw new ClassCastException(PlatformPlugin.Util.getString("ERR.014.107.0046", o.getClass()));
        }
        return GranteeEntitlementEntry.compare(this, (GranteeEntitlementEntry)o);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.grantee.getName());
        buff.append(", ");
        buff.append(this.grantor);
        buff.append(", {");
        String[] actions = this.allowedActions.getLabels();
        for (int i = 0; i < actions.length; ++i) {
            buff.append(actions[i] + ", ");
        }
        buff.setLength(buff.length() - 2);
        buff.append("}");
        return buff.toString();
    }

    void addActions(AuthorizationActions newActions) {
        if (!this.allowedActions.implies(newActions)) {
            this.allowedActions = StandardAuthorizationActions.getORedActions(newActions, this.allowedActions);
            this.generateIdentity();
        }
    }

    AuthorizationActions getActions() {
        return this.allowedActions;
    }

    static int compare(GranteeEntitlementEntry obj1, GranteeEntitlementEntry obj2) {
        return obj1.identifier.compareTo(obj2.identifier);
    }

    private void generateIdentity() {
        StringBuffer idBuff = new StringBuffer(this.grantee.getName());
        idBuff.append(this.grantor);
        String[] actions = this.allowedActions.getLabels();
        for (int i = 0; i < actions.length; ++i) {
            idBuff.append(actions[i]);
        }
        this.identifier = idBuff.toString();
    }
}

