/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.StreamImpl;
import com.metamatrix.query.util.ValueID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class MMBlob
implements Blob,
Serializable {
    private MMStatement statement;
    private ValueID valueID;
    private StreamImpl in;
    private long length = -1L;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMBlob;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;
    static /* synthetic */ Class class$com$metamatrix$query$util$ValueID;

    public static MMBlob newInstance(MMStatement statement, ValueID valueID) {
        if (AOP.useproxy()) {
            return (MMBlob)ProxyFactory.extend(class$com$metamatrix$jdbc$MMBlob == null ? (class$com$metamatrix$jdbc$MMBlob = MMBlob.class$("com.metamatrix.jdbc.MMBlob")) : class$com$metamatrix$jdbc$MMBlob, new Class[]{class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = MMBlob.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement, class$com$metamatrix$query$util$ValueID == null ? (class$com$metamatrix$query$util$ValueID = MMBlob.class$("com.metamatrix.query.util.ValueID")) : class$com$metamatrix$query$util$ValueID}, new Object[]{statement, valueID});
        }
        return new MMBlob(statement, valueID);
    }

    public MMBlob(MMStatement statement, ValueID valueID) {
        this.statement = statement;
        this.valueID = valueID;
        try {
            this.in = StreamImpl.newInstance(this.statement, this.getValueID());
            this.length = this.in.length();
        }
        catch (SQLException se) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Logger getLogger() {
        return this.statement.getLogger();
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.in;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] dataCopy = new byte[length];
        try {
            if (pos < 1L) {
                Object[] params = new Object[]{new Long(pos)};
                throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.0", params));
            }
            if (pos > this.length) {
                return null;
            }
            if (length < 0) {
                Object[] params = new Object[]{new Integer(length)};
                throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.3", params));
            }
            if ((long)length > this.length) {
                length = (int)this.length;
            }
            this.in.skip(pos - 1L);
            this.in.read(dataCopy, 0, length);
        }
        catch (IOException ie) {
            Object[] params = new Object[]{ie.getMessage()};
            throw new SQLException(JDBCPlugin.Util.getString("MMBlob.Unable_to_get_bytes_from_pos_to_length._{0}_1", params));
        }
        return dataCopy;
    }

    public long length() {
        return this.length;
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (pattern == null || start > this.length) {
            return -1L;
        }
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(patternBytes, start);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        int position = 0;
        try {
            if (start < 1L) {
                Object[] params = new Object[]{new Long(start)};
                throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.2", params));
            }
            if (pattern == null || start > this.length) {
                return -1L;
            }
            String patternStr = new String(pattern);
            byte[] restData = new byte[(int)this.length];
            this.in.read(restData, restData.length);
            String streamData = new String(restData);
            position = streamData.indexOf(patternStr, (int)start - 1);
            if (position != -1) {
                ++position;
            }
        }
        catch (IOException ie) {
            Object[] params = new Object[]{ie.getMessage()};
            throw new SQLException(JDBCPlugin.Util.getString("MMBlob.Unable_to_get_the_position_for_the_byte_array._{0}_2", params));
        }
        return position;
    }

    public String toString() {
        String pre = "{";
        String post = "";
        if (this.length == 0L) {
            return "Length: 0";
        }
        return "Length:" + this.length + ":" + pre + "..." + post + "}";
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null || this.in == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MMBlob)) {
                return false;
            }
            MMBlob blob = (MMBlob)obj;
            if (blob.length() != this.length() || blob.getValueID() != this.getValueID()) {
                return false;
            }
            byte[] bytes = blob.getBytes(1L, (int)blob.length());
            byte[] thisBytes = this.getBytes(1L, (int)this.length);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == thisBytes[i]) continue;
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ValueID getValueID() {
        return this.valueID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

