/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.CharOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ObjectConverterUtil {
    private static final int DEFAULT_READING_SIZE = 8192;

    protected static byte[] convertToByteArray(Blob data) throws MetaMatrixCoreException {
        try {
            if (CorePlugin.DEBUG) {
                CorePlugin.Util.log(1, CorePlugin.Util.getString("ObjectConverterUtil.DEBUG.Converting_Blob_to_byte[];_size_is_1", data.length()));
            }
            InputStream l_blobStream = data.getBinaryStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(out);
            byte[] l_buffer = new byte[1024];
            int l_nbytes = 0;
            while ((l_nbytes = l_blobStream.read(l_buffer)) != -1) {
                bos.write(l_buffer, 0, l_nbytes);
            }
            bos.flush();
            bos.close();
            l_blobStream.close();
            return out.toByteArray();
        }
        catch (IOException ioe) {
            Object[] params = new Object[]{data.getClass().getName()};
            throw new MetaMatrixCoreException((Throwable)ioe, CorePlugin.Util.getString("ObjectConverterUtil.Error_translating_results_from_data_type_to_a_byte[]._1", params));
        }
        catch (SQLException sqe) {
            Object[] params = new Object[]{data.getClass().getName()};
            throw new MetaMatrixCoreException((Throwable)sqe, CorePlugin.Util.getString("ObjectConverterUtil.Error_translating_results_from_data_type_to_a_byte[]._2", params));
        }
    }

    public static byte[] convertToByteArray(Object data) throws MetaMatrixCoreException, IOException {
        if (data instanceof InputStream) {
            return ObjectConverterUtil.convertToByteArray((InputStream)data);
        }
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        if (data instanceof Blob) {
            return ObjectConverterUtil.convertToByteArray((Blob)data);
        }
        Object[] params = new Object[]{data.getClass().getName()};
        throw new MetaMatrixCoreException(CorePlugin.Util.getString("ObjectConverterUtil.Object_type_not_supported_for_object_conversion._3", params));
    }

    public static byte[] convertToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        byte[] l_buffer = new byte[1024];
        int l_nbytes = 0;
        while ((l_nbytes = is.read(l_buffer)) != -1) {
            bos.write(l_buffer, 0, l_nbytes);
        }
        bos.flush();
        bos.close();
        byte[] data = out.toByteArray();
        return data;
    }

    public static InputStream convertToInputStream(byte[] data) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream isContent = new BufferedInputStream(bais);
        return isContent;
    }

    public static InputStream convertToInputStream(String data) {
        return ObjectConverterUtil.convertToInputStream(data.getBytes());
    }

    public static InputStream convertToInputStream(char[] data) {
        return ObjectConverterUtil.convertToInputStream(new String(data));
    }

    public static void write(InputStream is, String fileName) throws Exception {
        int bytesRead;
        File f = new File(fileName);
        f.delete();
        FileOutputStream fio = new FileOutputStream(f);
        BufferedOutputStream bos = new BufferedOutputStream(fio);
        byte[] buff = new byte[2048];
        while (-1 != (bytesRead = is.read(buff, 0, buff.length))) {
            bos.write(buff, 0, bytesRead);
        }
        bos.flush();
        bos.close();
    }

    public static void write(byte[] data, String fileName) throws Exception {
        InputStream is = ObjectConverterUtil.convertToInputStream(data);
        ObjectConverterUtil.write(is, fileName);
        is.close();
    }

    public static void write(char[] data, String fileName) throws Exception {
        InputStream is = ObjectConverterUtil.convertToInputStream(data);
        ObjectConverterUtil.write(is, fileName);
        is.close();
    }

    public static InputStream convertToInputStream(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream isContent = new BufferedInputStream(fis);
            return isContent;
        }
        catch (FileNotFoundException fie) {
            Object[] params = new Object[]{file.getName()};
            throw new IllegalArgumentException(CorePlugin.Util.getString("ObjectConverterUtil.File_is_not_found_4", params));
        }
    }

    public static char[] bytesToChar(byte[] bytes, String encoding) throws IOException {
        return ObjectConverterUtil.convertToCharArray(new ByteArrayInputStream(bytes), bytes.length, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertFileToByteArray(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = ObjectConverterUtil.convertToByteArray(stream, (int)file.length());
                Object var4_3 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] convertFileToCharArray(File file, String encoding) throws IOException {
        char[] cArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                cArray = ObjectConverterUtil.convertToCharArray(stream, (int)file.length(), encoding);
                Object var5_4 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return cArray;
    }

    public static String convertFileToString(File file) throws IOException {
        return new String(ObjectConverterUtil.convertFileToCharArray(file, null));
    }

    public static String convertToString(InputStream stream) throws IOException {
        return new String(ObjectConverterUtil.convertToCharArray(stream, -1, null));
    }

    public static byte[] convertToByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] convertToCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = CharOperation.NO_CHAR;
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertToByteArray(ZipEntry ze, ZipFile zip) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(zip.getInputStream(ze));
                byArray = ObjectConverterUtil.convertToByteArray(stream, (int)ze.getSize());
                Object var5_4 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return byArray;
    }
}

