/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.core.util.StringUtil;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.rmi.PortableRemoteObject;

public final class RemoteUtil {
    public static final String FIREWALL_ADDRESS_PROPERTY = "metamatrix.firewall.address";
    public static final String FIREWALL_ENABLED_PROPERTY = "metamatrix.firewall.address.enabled";
    private static final String STANDALONE = "standalone";
    private static String appServer;

    private RemoteUtil() {
    }

    public static Remote getStub(Remote remote, String appServerType) throws RemoteException {
        if (STANDALONE.equalsIgnoreCase(appServerType)) {
            return UnicastRemoteObject.toStub(remote);
        }
        return remote;
    }

    public static Remote getStub(Remote remote) throws RemoteException {
        return RemoteUtil.getStub(remote, RemoteUtil.getAppServerType());
    }

    public static void exportObject(Remote remote) throws RemoteException {
        String appServerType = RemoteUtil.getAppServerType();
        RemoteUtil.exportObject(remote, appServerType);
    }

    public static void exportObject(Remote remote, String appServerType) throws RemoteException {
        if (STANDALONE.equalsIgnoreCase(appServerType)) {
            UnicastRemoteObject.exportObject(remote);
        }
    }

    public static void unExportObject(Remote remote) throws RemoteException {
        String appServerType = RemoteUtil.getAppServerType();
        if (STANDALONE.equalsIgnoreCase(appServerType)) {
            PortableRemoteObject.unexportObject((Remote)remote);
        }
    }

    public static boolean isFirewallEnabled() {
        String enabled = CurrentConfiguration.getProperty((String)FIREWALL_ENABLED_PROPERTY);
        return Boolean.valueOf(enabled);
    }

    public static List getFirewallAddresses() {
        ArrayList<String> firewallAddresses = null;
        String firewalladdresses = CurrentConfiguration.getProperty((String)FIREWALL_ADDRESS_PROPERTY);
        if (firewalladdresses != null) {
            List fwa = StringUtil.getTokens(firewalladdresses.toLowerCase(), ",");
            firewallAddresses = new ArrayList<String>(fwa.size());
            Iterator it = fwa.iterator();
            while (it.hasNext()) {
                String v = (String)it.next();
                firewallAddresses.add(v.trim());
            }
        }
        return firewallAddresses;
    }

    public static void unExportObject(Remote remote, String appServerType) throws RemoteException {
        if (STANDALONE.equalsIgnoreCase(appServerType)) {
            PortableRemoteObject.unexportObject((Remote)remote);
        }
    }

    public static synchronized String getAppServerType() {
        if (appServer == null) {
            try {
                appServer = CurrentConfiguration.getProperty((String)"metamatrix.deployment.platform");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return appServer;
    }

    public static Object narrow(Object obj, Class clazz) {
        return obj;
    }
}

