/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Hashtable;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.debug.ProtocolTester;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class NakackTest
extends TestCase {
    final long WAIT_TIME = 5000L;
    public final long NUM_MSGS = 10000L;
    long num_msgs_received = 0L;
    long num_msgs_sent = 0L;

    public NakackTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test0() throws Exception {
        Object mutex = new Object();
        CheckNoGaps check = new CheckNoGaps(-1L, this, mutex);
        ProtocolTester t = new ProtocolTester("pbcast.NAKACK", check);
        IpAddress my_addr = new IpAddress("localhost", 10000);
        ViewId vid = new ViewId(my_addr, 322649L);
        Vector<IpAddress> mbrs = new Vector<IpAddress>();
        mbrs.addElement(my_addr);
        View view = new View(vid, mbrs);
        t.start();
        check.down(new Event(16));
        check.down(new Event(6, view));
        Object object = mutex;
        synchronized (object) {
            for (long i = 0L; i < 10000L; ++i) {
                if (i % 1000L == 0L && i > 0L) {
                    System.out.println("sending msg #" + i);
                }
                check.down(new Event(1, new Message(null, (Address)my_addr, new Long(i))));
                ++this.num_msgs_sent;
            }
            mutex.wait(5000L);
        }
        System.out.println("\nMessages sent: " + this.num_msgs_sent + ", messages received: " + this.num_msgs_received);
        NakackTest.assertEquals((long)this.num_msgs_received, (long)this.num_msgs_sent);
        t.stop();
    }

    public static Test suite() {
        return new TestSuite(NakackTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NakackTest.suite());
    }

    private static class CheckNoGaps
    extends Protocol {
        long starting_seqno = 0L;
        long num_msgs = 0L;
        Hashtable senders = new Hashtable();
        NakackTest t = null;
        Object mut = null;

        CheckNoGaps(long seqno, NakackTest t, Object mut) {
            this.starting_seqno = seqno;
            this.t = t;
            this.mut = mut;
        }

        public String getName() {
            return "CheckNoGaps";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void up(Event evt) {
            block12: {
                Message msg = null;
                if (evt == null) {
                    return;
                }
                if (evt.getType() == 8) {
                    System.out.println("local address is " + evt.getArg());
                }
                if (evt.getType() != 1) {
                    return;
                }
                msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                if (sender == null) {
                    this.log.error((Object)"NakackTest.CheckNoGaps.up(): sender is null; discarding msg");
                    return;
                }
                Long s = (Long)this.senders.get(sender);
                if (s == null) {
                    s = new Long(this.starting_seqno);
                    this.senders.put(sender, s);
                }
                long highest_seqno = s;
                try {
                    s = (Long)msg.getObject();
                    long received_seqno = s;
                    if (received_seqno == highest_seqno + 1L) {
                        if (received_seqno % 1000L == 0L && received_seqno > 0L) {
                            System.out.println("PASS: received msg #" + received_seqno);
                        }
                        this.senders.put(sender, new Long(highest_seqno + 1L));
                        ++this.num_msgs;
                        if (this.num_msgs < this.t.NUM_MSGS) break block12;
                        Object object = this.mut;
                        synchronized (object) {
                            this.t.num_msgs_received = this.num_msgs;
                            this.mut.notifyAll();
                            break block12;
                        }
                    }
                    this.log.error((Object)("FAIL: received msg #" + received_seqno));
                }
                catch (Exception ex) {
                    this.log.error((Object)("NakackTest.CheckNoGaps.up(): " + ex));
                }
            }
        }

        public void startUpHandler() {
        }

        public void startDownHandler() {
        }
    }
}

