/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;

public class Main
implements MessageListener,
MembershipListener {
    private Channel channel;
    private PullPushAdapter adapter;
    private int port;
    final int NUM = 10000;
    String props = "UDP(bind_addr=192.168.5.2;mcast_addr=224.10.10.10;mcast_port=5555;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=false)";
    private boolean redirectToSocket = false;
    private int cpt = 0;
    private long start;
    private long stop;
    private boolean log = false;
    private PrintWriter pwriter;

    public Main(int port, boolean isgui) {
        this.port = port;
        if (isgui) {
            this.redirectToSocket = false;
            JFrame frm = new JFrame();
            frm.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                }
            });
            JButton bpub = new JButton("Start Publisher");
            bpub.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Main.this.publish();
                }
            });
            JButton bsub = new JButton("Start Subscriber");
            bsub.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Main.this.subscribe();
                }
            });
            frm.getContentPane().setLayout(new FlowLayout(1));
            frm.getContentPane().add(bpub);
            frm.getContentPane().add(bsub);
            frm.setBounds(100, 100, 400, 300);
            frm.setVisible(true);
        } else {
            this.redirectToSocket = true;
        }
    }

    private void publish() {
        this.init(false);
        Thread t = new Thread(new Runnable(){

            public void run() {
                Main.this.loop();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private void subscribe() {
        this.init(true);
    }

    private void loop() {
        int cpt = 0;
        for (int i = 0; i < 10000; ++i) {
            try {
                String msg = "Message " + cpt++;
                this.adapter.send(new Message(null, null, (Serializable)((Object)msg)));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void init(boolean isConsumer) {
        try {
            this.channel = new JChannel(this.props);
            this.channel.connect("MyTest");
            this.adapter = new PullPushAdapter(this.channel);
            this.adapter.addMembershipListener(this);
            if (isConsumer) {
                this.adapter.setListener(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        boolean isgui = true;
        if (isgui) {
            int port = Integer.parseInt(args[1]);
            Main m = new Main(port, true);
        } else if (args.length > 1) {
            int port = Integer.parseInt(args[1]);
            if (args[0].equals("server")) {
                Main m = new Main(port, false);
                m.process(false);
            } else if (args[0].equals("client")) {
                Main m = new Main(port, false);
                m.process(true);
            }
        }
    }

    public void process(boolean isConsumer) {
        try {
            this.channel = new JChannel(this.props);
            this.channel.connect("MyTest");
            this.adapter = new PullPushAdapter(this.channel);
            this.adapter.addMembershipListener(this);
            if (isConsumer) {
                this.adapter.setListener(this);
            }
            Thread t = new Thread(new Runnable(){

                public void run() {
                    Main.this.listenFromSocket();
                }
            });
            t.setDaemon(true);
            t.start();
            this.blockThread();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockThread() {
        Main main = this;
        synchronized (main) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void receive(Message arg0) {
        String data = new String(arg0.getBuffer());
        if (this.cpt == 0) {
            this.start = System.currentTimeMillis();
        }
        ++this.cpt;
        if (this.cpt % 1000 == 0) {
            System.out.println(this.cpt);
        }
        if (this.log) {
            System.out.println("Lu sur le Bus " + this.port + " : " + data);
        }
        if (this.redirectToSocket) {
            this.writeToSocket(data);
        }
        if (this.cpt >= 10000) {
            this.stop = System.currentTimeMillis();
            long diff = this.stop - this.start;
            double msgs_sec = 10000.0 / ((double)diff / 1000.0);
            System.out.println("received 10000 msgs in " + diff + "ms (" + msgs_sec + " msgs/sec)");
        }
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] arg0) {
    }

    private void writeToSocket(String message) {
        this.pwriter.write(message + "\n");
        this.pwriter.flush();
    }

    public void listenFromSocket() {
        try {
            ServerSocket ss = new ServerSocket(this.port);
            Socket sock = ss.accept();
            System.out.println("Listing messages for the group on " + this.port);
            BufferedReader r = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            this.pwriter = new PrintWriter(sock.getOutputStream());
            String line = "";
            while ((line = r.readLine()) != null) {
                if (this.log) {
                    System.out.println("A envoyer au Bus : " + line);
                }
                this.adapter.send(new Message(null, null, line.getBytes()));
            }
            this.pwriter.close();
            r.close();
            sock.close();
            ss.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void viewAccepted(View arg0) {
        System.out.println("**** MEMBERS STATUS ****");
        for (int i = 0; i < arg0.getMembers().size(); ++i) {
            System.out.println(arg0.getMembers().elementAt(i));
        }
        System.out.println("****");
    }

    public void suspect(Address arg0) {
    }

    public void block() {
    }
}

