/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.RspList;

public class GroupRequestPull
implements MessageListener,
MembershipListener,
Transport {
    PullPushAdapter adapter = null;
    Channel ch = null;
    String props = null;
    GroupRequest group_req = null;
    static final String HDRNAME = "GroupRequestPullHeader";
    Vector members = new Vector();

    GroupRequestPull(String props) {
        this.props = props;
    }

    void start() throws Throwable {
        this.ch = new JChannel(this.props);
        this.ch.connect("GroupRequestPull-Group");
        this.adapter = new PullPushAdapter(this.ch, this, this);
        this.loop();
        this.adapter.stop();
        this.ch.close();
    }

    void loop() throws Throwable {
        boolean looping = true;
        while (looping) {
            System.out.println("Members are " + this.ch.getView().getMembers() + "\n<enter to send a new group request>");
            System.out.flush();
            int c = System.in.read();
            if (c == 113) {
                looping = false;
            }
            System.in.skip(System.in.available());
            this.sendGroupRequest();
        }
    }

    void sendGroupRequest() throws Throwable {
        Message msg = new Message();
        msg.putHeader(HDRNAME, new MyHeader(1));
        this.group_req = new GroupRequest(msg, this, this.members, 2);
        this.group_req.execute();
        RspList lst = this.group_req.getResults();
        System.out.println("-- received " + lst.size() + " results:");
        for (int i = 0; i < lst.size(); ++i) {
            System.out.println(lst.elementAt(i));
        }
        System.out.println();
    }

    public void receive(Message msg) {
        MyHeader hdr = (MyHeader)msg.removeHeader(HDRNAME);
        if (hdr == null) {
            System.err.println("GroupRequestPull.receive(): header for GroupRequestPullHeader was null");
            return;
        }
        if (hdr.type == 2) {
            if (this.group_req != null) {
                this.group_req.receiveResponse(msg);
            }
        } else if (hdr.type == 1) {
            Message rsp = new Message(msg.getSrc());
            rsp.putHeader(HDRNAME, new MyHeader(2));
            rsp.setObject((Serializable)((Object)("Hello from member " + this.ch.getLocalAddress())));
            try {
                this.adapter.send(rsp);
            }
            catch (Exception ex) {
                System.err.println("GroupRequestPull.receive(): failure sending response: " + ex);
            }
        } else {
            System.err.println("GroupRequestPull.receive(): header type of " + hdr.type + " not known");
        }
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    public void viewAccepted(View new_view) {
        System.out.println("** viewAccepted(): " + new_view);
        if (new_view != null && new_view.getMembers().size() > 0) {
            this.members.removeAllElements();
            this.members.addAll(new_view.getMembers());
        }
        if (this.group_req != null) {
            this.group_req.viewChange(new_view);
        }
    }

    public void suspect(Address suspected_mbr) {
        System.out.println("** suspect(): " + suspected_mbr);
        if (this.group_req != null) {
            this.group_req.suspect(suspected_mbr);
        }
    }

    public void block() {
    }

    public void send(Message msg) throws Exception {
        if (this.adapter == null) {
            System.err.println("GroupRequestPull.send(): adapter is null, cannot send message");
        } else {
            this.adapter.send(msg);
        }
    }

    public Object receive(long timeout) throws Exception {
        return null;
    }

    public static void main(String[] args) {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (!"-props".equals(args[i])) {
                GroupRequestPull.help();
                return;
            }
            props = args[++i];
        }
        try {
            new GroupRequestPull(props).start();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("GroupRequestPull [-help] [-props <properties>]");
    }

    public static class MyHeader
    extends Header {
        public static final int REQUEST = 1;
        public static final int RESPONSE = 2;
        int type = 0;

        public MyHeader() {
        }

        public MyHeader(int type) {
            this.type = type;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }
    }
}

