/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;

public class IpAddress
implements Address {
    private InetAddress ip_addr = null;
    private int port = 0;
    private byte[] additional_data;
    protected static final Log log = LogFactory.getLog((Class)IpAddress.class);
    static boolean resolve_dns = false;
    transient int size = -1;

    public IpAddress() {
    }

    public IpAddress(String i, int p) throws UnknownHostException {
        this.port = p;
        this.ip_addr = InetAddress.getByName(i);
    }

    public IpAddress(InetAddress i, int p) {
        this.ip_addr = i;
        this.port = p;
        if (this.ip_addr == null) {
            this.setAddressToLocalHost();
        }
    }

    private void setAddressToLocalHost() {
        block2: {
            try {
                this.ip_addr = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)("exception: " + e));
            }
        }
    }

    public IpAddress(int port) {
        this(port, true);
    }

    public IpAddress(int port, boolean set_default_host) {
        this.port = port;
        if (set_default_host) {
            this.setAddressToLocalHost();
        }
    }

    public final InetAddress getIpAddress() {
        return this.ip_addr;
    }

    public final int getPort() {
        return this.port;
    }

    public final boolean isMulticastAddress() {
        return this.ip_addr != null && this.ip_addr.isMulticastAddress();
    }

    public final byte[] getAdditionalData() {
        return this.additional_data;
    }

    public final void setAdditionalData(byte[] additional_data) {
        this.additional_data = additional_data;
        this.size = -1;
        this.size = this.size();
    }

    public final int compare(IpAddress other) {
        return this.compareTo(other);
    }

    public final int compareTo(Object o) {
        int rc;
        int h2;
        if (this == o) {
            return 0;
        }
        if (o == null || !(o instanceof IpAddress)) {
            throw new ClassCastException("comparison between different classes: the other object is " + (o != null ? o.getClass() : o));
        }
        IpAddress other = (IpAddress)((Object)o);
        if (this.ip_addr == null) {
            if (other.ip_addr == null) {
                return this.port < other.port ? -1 : (this.port > other.port ? 1 : 0);
            }
            return -1;
        }
        int h1 = this.ip_addr.hashCode();
        int n = h1 < (h2 = other.ip_addr.hashCode()) ? -1 : (rc = h1 > h2 ? 1 : 0);
        return rc != 0 ? rc : (this.port < other.port ? -1 : (this.port > other.port ? 1 : 0));
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public final int hashCode() {
        return this.ip_addr != null ? this.ip_addr.hashCode() + this.port : this.port;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.ip_addr == null) {
            sb.append("<null>");
        } else if (this.ip_addr.isMulticastAddress()) {
            sb.append(this.ip_addr.getHostAddress());
        } else {
            String host_name = null;
            host_name = resolve_dns ? this.ip_addr.getHostName() : this.ip_addr.getHostAddress();
            sb.append(host_name);
        }
        sb.append(":").append(this.port);
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
        } else {
            out.writeByte(0);
        }
        out.writeInt(this.port);
        if (this.additional_data != null) {
            out.writeBoolean(true);
            out.writeShort(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short len = in.readByte();
        if (len > 0) {
            byte[] a = new byte[len];
            in.readFully(a);
            this.ip_addr = InetAddress.getByAddress(a);
        }
        this.port = in.readInt();
        if (!in.readBoolean()) {
            return;
        }
        len = in.readShort();
        if (len > 0) {
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
        }
    }

    public void writeTo(DataOutputStream out) throws IOException {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
        } else {
            out.writeByte(0);
        }
        out.writeInt(this.port);
        if (this.additional_data != null) {
            out.writeBoolean(true);
            out.writeShort(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFrom(DataInputStream in) throws IOException {
        short len = in.readByte();
        if (len > 0) {
            byte[] a = new byte[len];
            in.readFully(a);
            this.ip_addr = InetAddress.getByAddress(a);
        }
        this.port = in.readInt();
        if (!in.readBoolean()) {
            return;
        }
        len = in.readShort();
        if (len > 0) {
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
        }
    }

    public int size() {
        if (this.size >= 0) {
            return this.size;
        }
        int tmp_size = 6;
        if (this.ip_addr != null) {
            tmp_size += this.ip_addr.getAddress().length;
        }
        if (this.additional_data != null) {
            tmp_size += this.additional_data.length + 2;
        }
        this.size = tmp_size;
        return tmp_size;
    }

    public Object clone() throws CloneNotSupportedException {
        IpAddress ret = new IpAddress(this.ip_addr, this.port);
        if (this.additional_data != null) {
            ret.additional_data = new byte[this.additional_data.length];
            System.arraycopy(this.additional_data, 0, ret.additional_data, 0, this.additional_data.length);
        }
        return ret;
    }

    static {
        try {
            resolve_dns = Boolean.valueOf(System.getProperty("resolve.dns", "false"));
        }
        catch (SecurityException ex) {
            resolve_dns = false;
        }
    }
}

