/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class LOOPBACK
extends Protocol {
    private Address local_addr = null;
    private String group_addr = null;

    public String toString() {
        return "Protocol LOOPBACK(local address: " + this.local_addr + ')';
    }

    public String getName() {
        return "LOOPBACK";
    }

    public void init() throws Exception {
        this.local_addr = new IpAddress(12345);
    }

    public void start() throws Exception {
        this.passUp(new Event(8, this.local_addr));
    }

    public void down(Event evt) {
        if (this.trace) {
            this.log.trace((Object)("event is " + evt + ", group_addr=" + this.group_addr + ", time is " + System.currentTimeMillis() + ", hdrs: " + Util.printEvent(evt)));
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Message rsp = msg.copy();
                if (rsp.getSrc() == null) {
                    rsp.setSrc(this.local_addr);
                }
                this.up(new Event(1, rsp));
                break;
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 47: {
                this.passUp(evt);
            }
        }
    }
}

