/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAParameter;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAQueryStatementRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.sql.SQLException;

public class DB2ImplBlob
extends BaseImplBlob {
    private static String footprint = "$Revision:   3.25.1.0  $";
    public static final int MAX_BLOB_SIZE = Integer.MAX_VALUE;
    DB2ImplConnection con;
    DB2ImplResultSet results;
    public UtilPagedTempBuffer blobData;
    private byte[] locator;

    public DB2ImplBlob(byte[] byArray, DB2ImplConnection dB2ImplConnection) throws SQLException {
        super(dB2ImplConnection.exceptions);
        this.locator = byArray;
        this.con = dB2ImplConnection;
        this.initBlobData();
    }

    public DB2ImplBlob(long l, DB2ImplConnection dB2ImplConnection, UtilPagedTempBuffer utilPagedTempBuffer) throws SQLException {
        super(dB2ImplConnection.exceptions);
        this.locator = null;
        this.con = dB2ImplConnection;
        this.blobData = utilPagedTempBuffer;
    }

    public UtilPagedTempBuffer getData() {
        return this.blobData;
    }

    private void initBlobData() throws SQLException {
        if (this.con.comm.serverOS == 3 || this.con.comm.serverOS == 8) {
            this.initBlobDataHost();
        }
    }

    private void initBlobDataHost() throws SQLException {
        String string = "SELECT CAST (? AS BLOB(2147483647)) FROM SYSIBM.SYSDUMMY1 FOR FETCH ONLY";
        DRDAByteOrderedDataReader dRDAByteOrderedDataReader = this.con.comm.createReader();
        dRDAByteOrderedDataReader.interpretAsBigEndian = true;
        BaseParameters baseParameters = new BaseParameters(1, this.con.exceptions, (BaseConnection)this.con.db2Connection);
        BaseParameter baseParameter = new BaseParameter(2004, 2, (Object)this.locator, (BaseConnection)this.con.db2Connection);
        baseParameters.set(1, 1, baseParameter);
        DRDAParameter dRDAParameter = new DRDAParameter(baseParameter, 25, 4, 0, false);
        dRDAParameter.isLobLocator = true;
        int n = this.con.comm.packageManager.getAvailableSectionNumber(false, false);
        String string2 = this.con.comm.packageManager.getPackageName(false);
        DRDAPkgNamCsn dRDAPkgNamCsn = new DRDAPkgNamCsn(this.con.databaseName, this.con.collectionId, string2, n, null);
        DRDAQueryStatementRequest dRDAQueryStatementRequest = new DRDAQueryStatementRequest(this.con, this.con.comm, dRDAByteOrderedDataReader, this.con.dataWriter, dRDAPkgNamCsn);
        dRDAQueryStatementRequest.setParameters(baseParameters);
        dRDAQueryStatementRequest.chainCommit = false;
        dRDAQueryStatementRequest.lobLocParam = dRDAParameter;
        dRDAQueryStatementRequest.writePRPSQLSTT(string, true, false);
        dRDAQueryStatementRequest.openQuery(this.con.warnings, false, (short)2);
        dRDAQueryStatementRequest.submitRequest();
        dRDAQueryStatementRequest.processMode = 1;
        dRDAQueryStatementRequest.processReply(this.con.warnings);
        this.results = new DB2ImplResultSet(dRDAQueryStatementRequest, this.con.comm);
        this.results.request.useOUTOVRlob = false;
        this.results.fetchAtPosition(0);
        long l = this.results.getData(1, 5).getLong(this.con.exceptions);
        if (l == 0L) {
            this.blobData = new UtilPagedTempBuffer();
        } else if (this.con.comm.serverType == 9) {
            dRDAQueryStatementRequest.processReply(this.con.warnings);
            this.blobData = dRDAQueryStatementRequest.lobBuffer;
        } else {
            this.results.request.discardReplyBytes();
            this.results.request.continueQuery(this.con.warnings);
            dRDAQueryStatementRequest.submitRequest();
            dRDAQueryStatementRequest.processReply(this.con.warnings);
            this.blobData = dRDAQueryStatementRequest.lobBuffer;
        }
        dRDAQueryStatementRequest.discardReplyBytes();
        this.results.close();
        this.con.comm.packageManager.markThisSectionNumber(dRDAPkgNamCsn, -1);
    }

    public long getLength() throws SQLException {
        return this.blobData.getSize();
    }

    public void close() throws SQLException {
        try {
            this.blobData.truncate(true);
        }
        catch (UtilException utilException) {
            throw this.con.exceptions.getException((Exception)((Object)utilException));
        }
        this.blobData = null;
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        int n3 = 0;
        if (this.blobData == null) {
            this.exceptions.getException(6009);
        }
        try {
            n3 = this.blobData.read(l - 1L, byArray, n, n2);
        }
        catch (UtilException utilException) {
            throw this.con.exceptions.getException((Exception)((Object)utilException));
        }
        return n3;
    }

    public int writeData(long l, byte[] byArray, int n, int n2) throws SQLException {
        int n3 = 0;
        if ((long)n2 + l - 1L > Integer.MAX_VALUE) {
            String[] stringArray = new String[]{String.valueOf(Integer.MAX_VALUE)};
            throw this.exceptions.getException(7078, stringArray);
        }
        if (l - 1L > this.blobData.getSize()) {
            String[] stringArray = new String[]{String.valueOf(l), String.valueOf(this.blobData.getSize())};
            throw this.exceptions.getException(7082, stringArray);
        }
        if (this.blobData == null) {
            this.exceptions.getException(6009);
        }
        try {
            n3 = this.blobData.write(l - 1L, byArray, n, n2);
        }
        catch (UtilException utilException) {
            throw this.con.exceptions.getException((Exception)((Object)utilException));
        }
        return n3;
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(byte[] byArray, long l) throws SQLException {
        long l2 = this.getLength();
        long l3 = l - 1L;
        int n = byArray.length;
        int n2 = 0;
        long l4 = l3;
        try {
            while (n2 < n) {
                byte by;
                byte by2;
                if (l3 == l2) {
                    return -1L;
                }
                if ((by2 = byArray[n2++]) == (by = this.blobData.read(l3++))) continue;
                n2 = 0;
                by2 = byArray[n2++];
                l3 = l4 + 1L;
                do {
                    if (l3 != l2) continue;
                    return -1L;
                } while (by2 != (by = this.blobData.read(l3++)));
                l4 = l3 - 1L;
            }
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
        return l4 + 1L;
    }

    public void truncate(long l) throws SQLException {
        try {
            this.blobData.truncate(l);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }
}

