/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.jdbc.base.BaseCallEscape;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseFunctionEscape;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.base.BaseTimestampEscape;
import java.sql.SQLException;

public class SybaseEscapeTranslator
extends BaseEscapeTranslator {
    private static String footprint = "$Revision:   3.8.4.0  $";
    float serverVersionNumber;

    public SybaseEscapeTranslator(float f) {
        this.serverVersionNumber = f;
    }

    public int getTranslationNeeded(int n) {
        int n2;
        switch (n) {
            case 8193: 
            case 8194: 
            case 8212: {
                n2 = 1;
                break;
            }
            case 8208: {
                n2 = (double)this.serverVersionNumber >= 12.0 ? 1 : 2;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        return n2;
    }

    public String translateCallEscape(BaseCallEscape baseCallEscape) {
        String string = new String("execute ");
        if (baseCallEscape.getEscapeType() == 8210) {
            string = string + "?=";
        }
        string = string + baseCallEscape.getProcedureName() + " " + baseCallEscape.getAllParameters();
        return string;
    }

    public String translateFunctionEscape(BaseFunctionEscape baseFunctionEscape) throws SQLException {
        String string = new String();
        switch (baseFunctionEscape.getFunctionType()) {
            case 11: {
                string = "((" + baseFunctionEscape.getParameter(1) + ")+" + "(" + baseFunctionEscape.getParameter(2) + "))";
                break;
            }
            case 33: {
                string = "lower(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 34: {
                string = "substring(" + baseFunctionEscape.getParameter(1) + ",1," + baseFunctionEscape.getParameter(2) + ")";
                break;
            }
            case 35: {
                string = "char_length(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 36: {
                String string2;
                if (baseFunctionEscape.getParameterCount() == 3 && !(string2 = baseFunctionEscape.getParameter(3).toString()).equals("1")) {
                    string = baseFunctionEscape.getFunctionText();
                    throw this.exceptions.getException(7018);
                }
                string = "charindex(" + baseFunctionEscape.getParameter(1) + "," + baseFunctionEscape.getParameter(2) + ")";
                break;
            }
            case 52: {
                string = "replicate(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 68: {
                string = "upper(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 9: 
            case 10: {
                string = "char_length(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 32: {
                string = "stuff(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                string = baseFunctionEscape.getFunctionTypeText().toLowerCase() + "(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 5: {
                string = "ATN2(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 41: {
                string = "((" + baseFunctionEscape.getParameter(1) + ")%" + "(" + baseFunctionEscape.getParameter(2) + "))";
                break;
            }
            case 22: {
                string = "datepart(day," + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 21: {
                string = "datename(weekday," + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 23: {
                string = "datepart(weekday," + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 24: {
                string = "datepart(dy," + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 43: {
                string = "datename(month," + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 65: 
            case 66: {
                String string3;
                String string4 = string3 = baseFunctionEscape.getParameter(1).toString();
                if (string3.equals("SQL_TSI_FRAC_SECOND")) {
                    string4 = "ms";
                } else if (string3.equals("SQL_TSI_SECOND")) {
                    string4 = "ss";
                } else if (string3.equals("SQL_TSI_MINUTE")) {
                    string4 = "mi";
                } else if (string3.equals("SQL_TSI_HOUR")) {
                    string4 = "hh";
                } else if (string3.equals("SQL_TSI_DAY")) {
                    string4 = "dd";
                } else if (string3.equals("SQL_TSI_WEEK")) {
                    string4 = "wk";
                } else if (string3.equals("SQL_TSI_MONTH")) {
                    string4 = "mm";
                } else if (string3.equals("SQL_TSI_QUARTER")) {
                    string4 = "qq";
                } else if (string3.equals("SQL_TSI_YEAR")) {
                    string4 = "yy";
                }
                string = (baseFunctionEscape.getFunctionType() == 65 ? "dateadd" : "datediff") + "(" + string4 + "," + baseFunctionEscape.getParameter(2) + "," + baseFunctionEscape.getParameter(3) + ")";
                break;
            }
            case 30: 
            case 40: 
            case 42: 
            case 49: 
            case 57: 
            case 70: 
            case 71: {
                string = "datepart(" + baseFunctionEscape.getFunctionTypeText().toLowerCase() + "," + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 44: {
                string = "getdate()";
                break;
            }
            case 15: {
                string = "convert(varchar, getdate(), 102)";
                break;
            }
            case 19: {
                string = "convert(varchar, getdate(), 108)";
                break;
            }
            case 20: {
                string = "db_name()";
                break;
            }
            case 31: {
                string = "isnull(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 69: {
                string = "suser_name()";
                break;
            }
            case 12: {
                String string5 = baseFunctionEscape.getParameter(2).toString().toLowerCase();
                if (string5.substring(0, 4).equals("sql_")) {
                    string5 = string5.substring(4);
                }
                if (string5.equals("decimal")) {
                    string5 = "decimal(8,4)";
                } else if (string5.equals("double")) {
                    string5 = "float";
                } else if (string5.equals("longvarchar")) {
                    string5 = "text";
                } else if (string5.equals("longvarbinary")) {
                    string5 = "image";
                }
                string = "convert(" + string5 + "," + baseFunctionEscape.getParameter(1) + ")";
                break;
            }
            default: {
                string = baseFunctionEscape.getFunctionText();
            }
        }
        return string;
    }

    public String translateTimestampEscape(BaseTimestampEscape baseTimestampEscape) {
        switch (baseTimestampEscape.getEscapeType()) {
            case 8194: {
                return "'" + baseTimestampEscape.getDate() + "'";
            }
            case 8193: {
                return "'" + baseTimestampEscape.getTime() + "'";
            }
        }
        String string = baseTimestampEscape.getTimestamp();
        String string2 = baseTimestampEscape.getSecondsFraction();
        if (string2 != null && string2.length() > 4) {
            string = string.substring(0, 23);
            this.warnings.add(7007);
        }
        return "'" + string + "'";
    }

    public void insertOuterJoinOperator(StringBuffer stringBuffer, int n) {
        if (n == 1037) {
            return;
        }
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        int n2 = 0;
        baseSQLScanner.setup(stringBuffer.toString(), '\'', '\"');
        while (true) {
            BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type == 6) break;
            n2 += baseSQLToken.value.length();
            if (baseSQLToken.value.charAt(0) != '=') continue;
            if (n == 1035) {
                stringBuffer.insert(n2 - 1, '*');
            } else {
                stringBuffer.insert(n2, '*');
            }
            ++n2;
        }
    }
}

