/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.resource.jdbc.spi;

import com.metamatrix.jdbcx.base.BaseDataSource;
import com.metamatrix.jdbcx.base.BaseXADataSource;
import com.metamatrix.resource.jdbc.JCAConnectionFactory;
import com.metamatrix.resource.jdbc.spi.JCAConnectionRequestInfo;
import com.metamatrix.resource.jdbc.spi.JCADefaultConnectionManager;
import com.metamatrix.resource.jdbc.spi.JCAExceptions;
import com.metamatrix.resource.jdbc.spi.JCALogger;
import com.metamatrix.resource.jdbc.spi.JCAManagedConnection;
import com.metamatrix.resource.jdbc.spi.JCAUtil;
import com.metamatrix.util.UtilDebug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;

public abstract class JCAManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private static String footprint = "$Revision:   3.18.1.1  $";
    protected BaseDataSource nativeDataSource;
    protected transient JCAExceptions exceptions;
    protected transient JCALogger logger;
    protected String connectorName;
    protected String spyAttributes;

    public JCAManagedConnectionFactory(String string, BaseDataSource baseDataSource) {
        UtilDebug.assert((String)"dataSource argument can not be null", (baseDataSource != null ? 1 : 0) != 0);
        this.exceptions = new JCAExceptions(string);
        this.nativeDataSource = baseDataSource;
        this.connectorName = string;
        this.logger = new JCALogger();
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.println("ManagedConnectionFactory.createConnectionFactroy(ConnectionManager connectionMgr)");
            this.logger.println("connectionMgr = " + connectionManager);
        }
        return this.commonCreateConnectionFactory(connectionManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.createConnectionFactory()");
        }
        Object object = this.commonCreateConnectionFactory(null);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.createConnectionFactory", object);
        }
        return object;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.createManagedConnection(Subject subject, ConnectionRequestInfo connectionInfo)");
            this.logger.println("subject = " + subject);
            this.logger.println("connectionInfo = " + connectionRequestInfo);
        }
        this.validateNativeDataSource();
        String string = null;
        String string2 = null;
        if (subject == null) {
            if (connectionRequestInfo != null && connectionRequestInfo instanceof JCAConnectionRequestInfo) {
                string = ((JCAConnectionRequestInfo)connectionRequestInfo).getUsername();
                string2 = ((JCAConnectionRequestInfo)connectionRequestInfo).getPassword();
            }
        } else {
            object = JCAUtil.getPasswordCredential(subject, this);
            string = object.getUserName();
            string2 = new String(object.getPassword());
            if (string.length() == 0) {
                string = null;
                string2 = null;
            }
        }
        object = null;
        JCAManagedConnection jCAManagedConnection = null;
        try {
            block17: {
                if (this.nativeDataSource instanceof BaseXADataSource) {
                    try {
                        if (string == null) {
                            object = ((BaseXADataSource)this.nativeDataSource).getXAConnection();
                            break block17;
                        }
                        object = ((BaseXADataSource)this.nativeDataSource).getXAConnection(string, string2);
                    }
                    catch (SQLException sQLException) {
                        if (string == null) {
                            object = this.nativeDataSource.getPooledConnection();
                            break block17;
                        }
                        object = this.nativeDataSource.getPooledConnection(string, string2);
                    }
                } else {
                    object = string == null ? this.nativeDataSource.getPooledConnection() : this.nativeDataSource.getPooledConnection(string, string2);
                }
            }
            jCAManagedConnection = new JCAManagedConnection((PooledConnection)object, string, string2, this, this.logger, this.exceptions);
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ManagedConnectionFactory.createManagedConnection", jCAManagedConnection);
            }
            return jCAManagedConnection;
        }
        catch (SQLException sQLException) {
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            throw this.exceptions.getException(sQLException, 1);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.matchManagedConnections(Set managedConnections, Subject subject, ConnectionRequestInfo connectionInfo)");
            this.logger.println("managedConnections = " + set);
            this.logger.println("   Number of managedConnections in set = " + set.size());
            this.logger.println("subject = " + subject);
            this.logger.println("connectionInfo = " + connectionRequestInfo);
        }
        this.validateNativeDataSource();
        ManagedConnection managedConnection = null;
        JCAManagedConnection jCAManagedConnection = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            managedConnection = (ManagedConnection)iterator.next();
            if (!(managedConnection instanceof JCAManagedConnection) || !(jCAManagedConnection = (JCAManagedConnection)managedConnection).getOwnerFactory().equals(this) || !this.matchAuthenticationInfo(jCAManagedConnection, subject, connectionRequestInfo)) continue;
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ManagedConnectionFactory.matchManagedConnections", jCAManagedConnection);
            }
            return jCAManagedConnection;
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.matchManagedConnections", null);
        }
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setLogWriter(PrintWriter logWriter)");
            this.logger.println("logWriter = " + printWriter);
            this.logger.cleanup();
        }
        this.logger = new JCALogger(printWriter);
        try {
            if (this.nativeDataSource != null) {
                this.nativeDataSource.setLogWriter(printWriter);
            }
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 4302, 0);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setLogWriter");
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        PrintWriter printWriter = this.logger.getLogWriter();
        if (printWriter != null) {
            this.logger.printEnter("ManagedConnectionFactory.getLogWriter()");
            this.logger.println("Return Value = " + printWriter);
            this.logger.printExit("ManagedConnectionFactory.getLogWriter");
        }
        return printWriter;
    }

    Reference getDataSourceReference() {
        Reference reference = null;
        try {
            reference = this.nativeDataSource.getReference();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return reference;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof JCAManagedConnectionFactory) {
            BaseDataSource baseDataSource = this.nativeDataSource;
            BaseDataSource baseDataSource2 = ((JCAManagedConnectionFactory)object).nativeDataSource;
            if (baseDataSource == null || baseDataSource2 == null) {
                return false;
            }
            return this.implCompareProperties(baseDataSource, baseDataSource2) && this.compareProperties(baseDataSource, baseDataSource2);
        }
        return false;
    }

    public int hashCode() {
        if (this.nativeDataSource == null) {
            return super.hashCode();
        }
        String string = this.getHashString() + this.implGetHashString();
        return string.hashCode();
    }

    protected boolean compareProperties(BaseDataSource baseDataSource, BaseDataSource baseDataSource2) {
        if (!JCAUtil.isEqual(baseDataSource.getDatabaseName(), baseDataSource2.getDatabaseName())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getServerName(), baseDataSource2.getServerName())) {
            return false;
        }
        if (baseDataSource.getPortNumber() != baseDataSource2.getPortNumber()) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getUser(), baseDataSource2.getUser())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getPassword(), baseDataSource2.getPassword())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getDataSourceName(), baseDataSource2.getDataSourceName())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getDescription(), baseDataSource2.getDescription())) {
            return false;
        }
        if (baseDataSource.getLoginTimeout() != baseDataSource2.getLoginTimeout()) {
            return false;
        }
        if (baseDataSource.getBatchPerformanceWorkaround() != baseDataSource2.getBatchPerformanceWorkaround()) {
            return false;
        }
        if (baseDataSource.getInitialPoolSize() != baseDataSource2.getInitialPoolSize()) {
            return false;
        }
        if (baseDataSource.getMaxIdleTime() != baseDataSource2.getMaxIdleTime()) {
            return false;
        }
        if (baseDataSource.getMaxPoolSize() != baseDataSource2.getMaxPoolSize()) {
            return false;
        }
        if (baseDataSource.getMaxStatements() != baseDataSource2.getMaxStatements()) {
            return false;
        }
        if (baseDataSource.getMinPoolSize() != baseDataSource2.getMinPoolSize()) {
            return false;
        }
        if (baseDataSource.getPropertyCycle() != baseDataSource2.getPropertyCycle()) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getRoleName(), baseDataSource2.getRoleName())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getSpyAttributes(), baseDataSource2.getSpyAttributes())) {
            return false;
        }
        if (baseDataSource.getInsensitiveResultSetBufferSize() != baseDataSource2.getInsensitiveResultSetBufferSize()) {
            return false;
        }
        if (baseDataSource.getJavaDoubleToString() != baseDataSource2.getJavaDoubleToString()) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getInitializationString(), baseDataSource2.getInitializationString())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getLoadLibraryPath(), baseDataSource2.getLoadLibraryPath())) {
            return false;
        }
        if (baseDataSource.getWorkarounds() != baseDataSource2.getWorkarounds()) {
            return false;
        }
        if (baseDataSource.getConvertNull() != baseDataSource2.getConvertNull()) {
            return false;
        }
        if (baseDataSource.getQueryTimeout() != baseDataSource2.getQueryTimeout()) {
            return false;
        }
        if (baseDataSource.getCatalogOptions() != baseDataSource2.getCatalogOptions()) {
            return false;
        }
        return baseDataSource.getCatalogIncludesSynonyms() == baseDataSource.getCatalogIncludesSynonyms();
    }

    protected String getHashString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.nativeDataSource.getDatabaseName());
        stringBuffer.append(this.nativeDataSource.getServerName());
        stringBuffer.append(this.nativeDataSource.getPortNumber());
        stringBuffer.append(this.nativeDataSource.getUser());
        stringBuffer.append(this.nativeDataSource.getPassword());
        stringBuffer.append(this.nativeDataSource.getDataSourceName());
        stringBuffer.append(this.nativeDataSource.getDescription());
        stringBuffer.append(this.nativeDataSource.getLoginTimeout());
        stringBuffer.append(this.nativeDataSource.getBatchPerformanceWorkaround());
        stringBuffer.append(this.nativeDataSource.getInitialPoolSize());
        stringBuffer.append(this.nativeDataSource.getMaxIdleTime());
        stringBuffer.append(this.nativeDataSource.getMaxPoolSize());
        stringBuffer.append(this.nativeDataSource.getMaxStatements());
        stringBuffer.append(this.nativeDataSource.getMinPoolSize());
        stringBuffer.append(this.nativeDataSource.getPropertyCycle());
        stringBuffer.append(this.nativeDataSource.getRoleName());
        stringBuffer.append(this.nativeDataSource.getSpyAttributes());
        stringBuffer.append(this.nativeDataSource.getInsensitiveResultSetBufferSize());
        stringBuffer.append(this.nativeDataSource.getJavaDoubleToString());
        stringBuffer.append(this.nativeDataSource.getInitializationString());
        stringBuffer.append(this.nativeDataSource.getLoadLibraryPath());
        stringBuffer.append(this.nativeDataSource.getConvertNull());
        stringBuffer.append(this.nativeDataSource.getQueryTimeout());
        stringBuffer.append(this.nativeDataSource.getCatalogOptions());
        stringBuffer.append(this.nativeDataSource.getCatalogIncludesSynonyms());
        return stringBuffer.toString();
    }

    protected abstract boolean implCompareProperties(BaseDataSource var1, BaseDataSource var2);

    protected abstract String implGetHashString();

    public final String getDatabaseName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getDatabaseName();
    }

    public final void setDatabaseName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setDatabaseName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setDatabaseName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setDatabaseName");
        }
    }

    public final String getDataSourceName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getDataSourceName();
    }

    public final void setDataSourceName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setDataSourceName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setDataSourceName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setDataSourceName");
        }
    }

    public final String getDescription() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getDescription();
    }

    public final void setDescription(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setDescription(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setDescription(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setDescription");
        }
    }

    public final String getExtendedOptions() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getExtendedOptions();
    }

    public final void setExtendedOptions(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setExtendedOptions(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setExtendedOptions(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setExtendedOptions");
        }
    }

    public final String getPassword() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getPassword();
    }

    public final void setPassword(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setPassword(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setPassword(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setPassword");
        }
    }

    public final String getPortNumber() {
        if (this.nativeDataSource == null) {
            return "-1";
        }
        return String.valueOf(this.nativeDataSource.getPortNumber());
    }

    public final void setPortNumber(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.println("ManagedConnectionFactory.setPortNumber(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setPortNumber(Integer.parseInt(string));
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setPortNumber");
        }
    }

    public final String getRoleName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getRoleName();
    }

    public final void setRoleName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setRoleName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setRoleName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setRoleName");
        }
    }

    public final String getServerName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getServerName();
    }

    public final void setServerName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setServerName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setServerName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setServerName");
        }
    }

    public final String getUser() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getUser();
    }

    public final String getUserName() {
        return this.getUser();
    }

    public final void setUser(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setUser(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setUser(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setUser");
        }
    }

    public final void setUserName(String string) {
        this.setUser(string);
    }

    public String getAlternateServers() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getAlternateServers();
    }

    public void setAlternateServers(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setAlternateServers(String alternateServers)");
            this.logger.println("alternateServers = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setAlternateServers(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setAlternateServers");
        }
    }

    public final Boolean getBatchPerformanceWorkaround() {
        if (this.nativeDataSource == null) {
            return new Boolean(false);
        }
        return new Boolean(this.nativeDataSource.getBatchPerformanceWorkaround());
    }

    public final void setBatchPerformanceWorkaround(Boolean bl) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setBatchPerformanceWorkaround(boolean b)");
            this.logger.println("b = " + bl);
        }
        if (this.isValidNativeDataSource() && bl != null) {
            this.nativeDataSource.setBatchPerformanceWorkaround(bl.booleanValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setBatchPerformanceWorkaround");
        }
    }

    public final Boolean getLoadBalancing() {
        if (this.nativeDataSource == null) {
            return new Boolean(false);
        }
        return new Boolean(this.nativeDataSource.getLoadBalancing());
    }

    public final void setLoadBalancing(Boolean bl) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setLoadBalancing(boolean b)");
            this.logger.println("b = " + bl);
        }
        if (this.isValidNativeDataSource() && bl != null) {
            this.nativeDataSource.setLoadBalancing(bl.booleanValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setLoadBalancing");
        }
    }

    public final Boolean getJavaDoubleToString() {
        if (this.nativeDataSource == null) {
            return new Boolean(false);
        }
        return new Boolean(this.nativeDataSource.getJavaDoubleToString());
    }

    public final void setJavaDoubleToString(Boolean bl) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setJavaDoubleToString(boolean b)");
            this.logger.println("b = " + bl);
        }
        if (this.isValidNativeDataSource() && bl != null) {
            this.nativeDataSource.setJavaDoubleToString(bl.booleanValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setJavaDoubleToString");
        }
    }

    public final Integer getLoginTimeout() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getLoginTimeout());
    }

    public final void setLoginTimeout(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setLoginTimeout(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setLoginTimeout(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setLoginTimeout");
        }
    }

    public final String getSpyAttributes() {
        return this.spyAttributes;
    }

    public final void setSpyAttributes(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setSpyAttributes(String s)");
            this.logger.println("s = " + string);
            this.logger.cleanup();
        }
        this.spyAttributes = string;
        this.createLogger();
    }

    public void setMaxStatements(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMaxStatements(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setMaxStatements(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMaxStatements");
        }
    }

    public Integer getMaxStatements() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMaxStatements());
    }

    public void setInitialPoolSize(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setInitialPoolSize(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setInitialPoolSize(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setInitialPoolSize");
        }
    }

    public Integer getInitialPoolSize() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getInitialPoolSize());
    }

    public void setMinPoolSize(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMinPoolSize(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setMinPoolSize(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMinPoolSize");
        }
    }

    public Integer getMinPoolSize() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMinPoolSize());
    }

    public void setMaxPoolSize(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMaxPoolSize(Integer i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setMaxPoolSize(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMaxPoolSize");
        }
    }

    public Integer getMaxPoolSize() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMaxPoolSize());
    }

    public void setMaxPooledStatements(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMaxPooledStatements(Integer i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setMaxPooledStatements(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMaxPooledStatements");
        }
    }

    public Integer getMaxPooledStatements() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMaxPooledStatements());
    }

    public void setMaxIdleTime(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMaxIdleTime(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setMaxIdleTime(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMaxIdleTime");
        }
    }

    public Integer getMaxIdleTime() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMaxIdleTime());
    }

    public void setPropertyCycle(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setPropertyCycle(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setPropertyCycle(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setPropertyCycle");
        }
    }

    public Integer getPropertyCycle() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getPropertyCycle());
    }

    public String getResourceAdaptorName() {
        return this.connectorName;
    }

    public Integer getCatalogOptions() {
        return new Integer(this.nativeDataSource.getCatalogOptions());
    }

    public void setCatalogOptions(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setCatalogOptions(Integer catalogOptions)");
            this.logger.println("catalogOptions = " + n);
        }
        this.nativeDataSource.setCatalogOptions(n.intValue());
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setCatalogOptions");
        }
    }

    public Boolean getCatalogIncludesSynonyms() {
        return new Boolean(this.nativeDataSource.getCatalogIncludesSynonyms());
    }

    public void setCatalogIncludesSynonyms(Boolean bl) {
        if (bl == null) {
            return;
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setCatalogIncludesSynonyms(Boolean b)");
            this.logger.println("b = " + bl);
        }
        this.nativeDataSource.setCatalogIncludesSynonyms(bl.booleanValue());
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setCatalogIncludesSynonyms");
        }
    }

    public void setConnectionRetryCount(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setConnectionRetryCount(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setConnectionRetryCount(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setConnectionRetryCount");
        }
    }

    public Integer getConnectionRetryCount() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getConnectionRetryCount());
    }

    public void setConnectionRetryDelay(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setConnectionRetryDelay(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setConnectionRetryDelay(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setConnectionRetryDelay");
        }
    }

    public Integer getConnectionRetryDelay() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getConnectionRetryDelay());
    }

    public final Integer getResultsetMetaDataOptions() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getResultsetMetaDataOptions());
    }

    public final void setResultsetMetaDataOptions(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setResultsetMetaDataOptions(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setResultsetMetaDataOptions(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setResultsetMetaDataOptions");
        }
    }

    public void setInsensitiveResultSetBufferSize(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setInsensitiveResultSetBufferSize(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setInsensitiveResultSetBufferSize(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setInsensitiveResultSetBufferSize");
        }
    }

    public Integer getInsensitiveResultSetBufferSize() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getInsensitiveResultSetBufferSize());
    }

    public final String getInitializationString() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getInitializationString();
    }

    public final void setInitializationString(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setInitializationString(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setInitializationString(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setInitializationString");
        }
    }

    public final String getLoadLibraryPath() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getLoadLibraryPath();
    }

    public final void setLoadLibraryPath(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setLoadLibraryPath(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setLoadLibraryPath(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setLoadLibraryPath");
        }
    }

    public final String getImportStatementPool() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getImportStatementPool();
    }

    public final void setImportStatementPool(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setImportStatementPool(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setImportStatementPool(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setImportStatementPool");
        }
    }

    public final Integer getWorkarounds() {
        if (this.nativeDataSource == null) {
            return new Integer(0);
        }
        return new Integer(this.nativeDataSource.getWorkarounds());
    }

    public final void setWorkarounds(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setWorkarounds(Integer i)");
            this.logger.println("workaroundsArg = " + n);
        }
        if (this.isValidNativeDataSource()) {
            this.nativeDataSource.setWorkarounds(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setWorkarounds");
        }
    }

    public void setQueryTimeout(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setQueryTimeout(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setQueryTimeout(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setQueryTimeout");
        }
    }

    public Integer getQueryTimeout() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getQueryTimeout());
    }

    public Integer getConvertNull() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getConvertNull());
    }

    public void setConvertNull(Integer n) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setConvertNull(int i)");
            this.logger.println("i = " + n);
        }
        if (this.isValidNativeDataSource() && n != null) {
            this.nativeDataSource.setConvertNull(n.intValue());
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setConvertNull");
        }
    }

    boolean matchAuthenticationInfo(JCAManagedConnection jCAManagedConnection, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var8_8 = null;
        PasswordCredential passwordCredential = null;
        if (jCAManagedConnection != null) {
            string3 = jCAManagedConnection.getUsername();
            string4 = jCAManagedConnection.getPassword();
        }
        if (subject != null) {
            passwordCredential = JCAUtil.getPasswordCredential(subject, this);
            if (passwordCredential != null) {
                string = passwordCredential.getUserName();
                string2 = new String(passwordCredential.getPassword());
            }
            if (string.length() == 0) {
                string = null;
                string2 = null;
            }
        } else if (connectionRequestInfo != null && connectionRequestInfo instanceof JCAConnectionRequestInfo) {
            string = ((JCAConnectionRequestInfo)connectionRequestInfo).getUsername();
            string2 = ((JCAConnectionRequestInfo)connectionRequestInfo).getPassword();
        }
        return JCAUtil.isEqual(string, string3) && JCAUtil.isEqual(string2, string4);
    }

    private Object commonCreateConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        this.validateNativeDataSource();
        if (connectionManager == null) {
            connectionManager = new JCADefaultConnectionManager(this.exceptions);
        }
        JCAConnectionFactory jCAConnectionFactory = new JCAConnectionFactory(connectionManager, this, this.logger, this.exceptions);
        return jCAConnectionFactory;
    }

    private void validateNativeDataSource() throws ResourceException {
        if (this.nativeDataSource == null) {
            throw this.exceptions.getException(4303, 2);
        }
    }

    private boolean isValidNativeDataSource() {
        return this.nativeDataSource != null;
    }

    private boolean isEmptyString(String string) {
        return string != null && string.length() == 0;
    }

    public JCAExceptions getExceptions() {
        return this.exceptions;
    }

    private void createLogger() {
        block3: {
            this.logger = new JCALogger(this.spyAttributes);
            if (this.isValidNativeDataSource()) {
                try {
                    this.nativeDataSource.setLogWriter(this.logger.getLogWriter());
                }
                catch (SQLException sQLException) {
                    if (this.logger.getLogWriter() == null) break block3;
                    this.logger.println("Error Setting log writer of underlying DataSource");
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createLogger();
        this.exceptions = new JCAExceptions(this.connectorName);
    }
}

