/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAParameter;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAStatementRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.io.InputStream;
import java.sql.SQLException;

public class DRDAExecuteStatementRequest
extends DRDAStatementRequest {
    private static String footprint = "$Revision:   3.37.1.0  $";
    public DB2ImplStatement implStmt;
    public String spName;
    public boolean executingBatch;
    public boolean processingSQLCAforPrepare;
    public boolean lastBatchStatement;
    public int[] updateCounts;
    public int currentUpdateCount;
    public int currentExceptionCount;
    public short queryProtocol;

    public DRDAExecuteStatementRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter, DB2ImplStatement dB2ImplStatement, DRDAPkgNamCsn dRDAPkgNamCsn) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter, dRDAPkgNamCsn);
        this.implStmt = dB2ImplStatement;
    }

    public void setToPrepared() throws SQLException {
        super.setToPrepared();
        this.executingBatch = false;
        this.lastBatchStatement = true;
        this.updateCounts = null;
        this.currentUpdateCount = 0;
        this.currentExceptionCount = 0;
    }

    public void writeEXCSQLSTT(int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4;
            boolean bl;
            int n5 = n;
            boolean bl2 = bl = this.parameterDescriptions != null && this.numParams > 0;
            if (n5 == 1 && this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                int n6 = ++n5;
                ++n5;
                n4 = this.writer.writePacketHeader((short)1, (short)64, n6);
                n3 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n3);
                this.writer.writePacketLength(n4);
            }
            n4 = 0;
            n4 = bl ? this.writer.writePacketHeader((short)1, (short)80, n5) : (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit && !this.isStoredProcedure ? this.writer.writePacketHeader((short)1, (short)64, n5++) : this.writer.writePacketHeader((short)1, (short)0, n5));
            n3 = this.writer.writeCodePoint((short)8203);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8465);
            if (this.lobLocParam != null || bl && this.isStoredProcedure) {
                this.writer.writeInt8(241);
            } else {
                this.writer.writeInt8(240);
            }
            if (this.isStoredProcedure) {
                if (!this.comm.enableRealStoredProcPrepare) {
                    n2 = this.writer.writeCodePoint((short)8504);
                    this.writer.writeString(this.spName);
                    this.writer.writeCodePointLength(n2);
                }
                this.writer.writeInt16(5);
                this.writer.writeInt16(8453);
                this.writer.writeInt8(241);
                this.writer.writeInt16(8);
                this.writer.writeInt16(8468);
                if (this.comm.SQLAMLevel < 7) {
                    this.writer.writeInt32(Short.MAX_VALUE);
                } else {
                    this.writer.writeInt32(Short.MAX_VALUE);
                }
                this.writer.writeInt16(6);
                this.writer.writeInt16(8512);
                this.writer.writeInt16(65535);
                this.writer.writeInt16(5);
                this.writer.writeInt16(8514);
                this.writer.writeInt8(224);
            }
            this.writer.writeCodePointLength(n3);
            this.writer.writePacketLength(n4);
            if (bl) {
                short s;
                n2 = 0;
                int s2 = 3;
                if (this.comm.encryptData) {
                    s = 4;
                }
                n2 = this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit && !this.isStoredProcedure ? this.writer.writePacketHeader(s, (short)64, n5++) : (this.executingBatch && !this.lastBatchStatement ? this.writer.writePacketHeader(s, (short)64, n5++) : this.writer.writePacketHeader(s, (short)0, n5++));
                int n7 = this.writer.writeCodePoint((short)9234);
                int n8 = this.writer.writeCodePoint((short)16);
                this.writeFDODSC();
                this.writer.writeCodePointLength(n8);
                int n9 = this.writer.writeCodePoint((short)5242);
                this.writeFDODTA();
                this.writer.writeCodePointLength(n9);
                this.writer.writeCodePointLength(n7);
                if (this.lobInsertPos != 0) {
                    this.writer.writeNewPacketHeader(n2, s, (short)80, --n5);
                }
                if (this.comm.encryptData) {
                    this.writer.writeEncryptedPacketLength(n2);
                } else {
                    this.writer.writePacketLength(n2);
                }
                if (this.lobInsertPos != 0) {
                    for (int i = 0; i < this.lobInsertPos; ++i) {
                        long l;
                        int n10;
                        int n11 = 0;
                        n11 = this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit && !this.isStoredProcedure ? (i == this.lobInsertPos - 1 ? this.writer.writePacketHeader(s, (short)64, n5++) : this.writer.writePacketHeader(s, (short)80, n5)) : (i == this.lobInsertPos - 1 ? (this.executingBatch && !this.lastBatchStatement ? this.writer.writePacketHeader(s, (short)64, n5) : this.writer.writePacketHeader(s, (short)0, n5)) : this.writer.writePacketHeader(s, (short)80, n5));
                        BaseParameter baseParameter = this.parameterDescriptions.getInput(this.lobColumns[i]);
                        long l2 = 0L;
                        l2 = ((BaseInputStreamWrapper)baseParameter.getObject()).determineLength();
                        if (l2 <= 32753L || this.comm.encryptData) {
                            n10 = this.writer.writeCodePoint((short)5228);
                            if (this.comm.SQLAMLevel >= 7) {
                                if (baseParameter.isNull()) {
                                    this.writer.writeInt8(255);
                                } else {
                                    this.writer.writeInt8(0);
                                }
                            }
                            this.writer.writeStream((InputStream)((BaseInputStreamWrapper)baseParameter.getObject()), (int)l2);
                            this.writer.writeCodePointLength(n10);
                            if (this.comm.encryptData) {
                                this.writer.writeEncryptedPacketLength(n11);
                                continue;
                            }
                            this.writer.writePacketLength(n11);
                            continue;
                        }
                        this.writer.writeInt16(32776);
                        n10 = this.writer.currentBufferInsertPosition;
                        this.writer.currentBufferInsertPosition = n11;
                        this.writer.writeInt16(65535);
                        this.writer.currentBufferInsertPosition = n10;
                        this.writer.writeInt16(5228);
                        if (this.comm.SQLAMLevel < 7) {
                            this.writer.writeInt32((int)l2);
                        } else {
                            this.writer.writeInt32((int)l2 + 1);
                            if (baseParameter.isNull()) {
                                this.writer.writeInt8(255);
                            } else {
                                this.writer.writeInt8(0);
                            }
                        }
                        int n12 = 0;
                        n12 = this.comm.SQLAMLevel >= 7 ? 32752 : 32753;
                        this.writer.writeStream((InputStream)((BaseInputStreamWrapper)baseParameter.getObject()), n12);
                        this.writer.send();
                        for (l = l2 - (long)n12; l > 32765L; l -= 32765L) {
                            this.writer.writeInt16(65535);
                            this.writer.writeStream((InputStream)((BaseInputStreamWrapper)baseParameter.getObject()), 32765);
                            this.writer.send();
                        }
                        this.writer.writeInt16((int)l + 2);
                        this.writer.writeStream((InputStream)((BaseInputStreamWrapper)baseParameter.getObject()), (int)l);
                    }
                }
            }
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit && !this.isStoredProcedure) {
                if (this.implConn.isXAImplConn && this.implConn.comm.useBetaXAImplementation) {
                    n2 = this.writer.writePacketHeader((short)1, (short)0, n5);
                    int n13 = this.writer.writeCodePoint((short)4181);
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(4487);
                    this.writer.writeInt8(3);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6145);
                    this.writer.writeInt32(-1);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6403);
                    this.writer.writeInt32(0x10000000);
                    this.writer.writeCodePointLength(n13);
                    this.writer.writePacketLength(n2);
                } else {
                    n2 = this.writer.writePacketHeader((short)1, (short)0, n5);
                    int n14 = this.writer.writeCodePoint((short)8206);
                    this.writer.writeCodePointLength(n14);
                    this.writer.writePacketLength(n2);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
    }

    public void writeEXCSQLIMM(String string, int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4 = 1 + n;
            if (n4 == 1 && this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                n3 = this.writer.writePacketHeader((short)1, (short)64, n4++);
                n2 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n2);
                this.writer.writePacketLength(n3);
            }
            n3 = this.writer.writePacketHeader((short)1, (short)80, n4);
            n2 = this.writer.writeCodePoint((short)8202);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8453);
            this.writer.writeInt8(241);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n3);
            int n5 = 0;
            short s = 3;
            if (this.comm.encryptData) {
                s = 4;
            }
            n5 = this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit ? this.writer.writePacketHeader(s, (short)64, n4++) : (this.executingBatch && !this.lastBatchStatement ? this.writer.writePacketHeader(s, (short)64, n4++) : this.writer.writePacketHeader(s, (short)0, n4));
            int n6 = this.writer.writeCodePoint((short)9236);
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt8(0);
                this.writer.writeEncodedStringWithLength32(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt8(255);
            } else if (this.comm.serverType == 2) {
                this.writer.writeInt16(0);
                this.writer.writeEncodedStringWithLength16(string, this.comm.SingleByteClientTransliterator);
            } else {
                this.writer.writeEncodedStringWithLength16(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt16(0);
            }
            this.writer.writeCodePointLength(n6);
            if (this.comm.encryptData) {
                this.writer.writeEncryptedPacketLength(n5);
            } else {
                this.writer.writePacketLength(n5);
            }
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit) {
                if (this.implConn.isXAImplConn && this.implConn.comm.useBetaXAImplementation) {
                    int n7 = this.writer.writePacketHeader((short)1, (short)0, n4);
                    int n8 = this.writer.writeCodePoint((short)4181);
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(4487);
                    this.writer.writeInt8(3);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6145);
                    this.writer.writeInt32(-1);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6403);
                    this.writer.writeInt32(0x10000000);
                    this.writer.writeCodePointLength(n8);
                    this.writer.writePacketLength(n7);
                } else {
                    int n9 = this.writer.writePacketHeader((short)1, (short)0, n4);
                    int n10 = this.writer.writeCodePoint((short)8206);
                    this.writer.writeCodePointLength(n10);
                    this.writer.writePacketLength(n9);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
    }

    public void writeEXCSQLSET(String string, int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4 = 1 + n;
            if (n4 == 1 && this.implConn.isXAImplConn && this.implConn.inLocalTransaction) {
                n3 = this.writer.writePacketHeader((short)1, (short)64, n4++);
                n2 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n2);
                this.writer.writePacketLength(n3);
            }
            n3 = this.writer.writePacketHeader((short)1, (short)80, n4);
            n2 = this.writer.writeCodePoint((short)8212);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n3);
            int n5 = 0;
            short s = 3;
            if (this.comm.encryptData) {
                s = 4;
            }
            n5 = this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit ? this.writer.writePacketHeader(s, (short)64, n4++) : (this.executingBatch && !this.lastBatchStatement ? this.writer.writePacketHeader(s, (short)64, n4++) : this.writer.writePacketHeader(s, (short)0, n4));
            int n6 = this.writer.writeCodePoint((short)9236);
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt8(0);
                this.writer.writeEncodedStringWithLength32(string, this.comm.SingleByteClientTransliterator);
                this.writer.writeInt8(255);
            } else {
                this.writer.writeInt16(0);
                this.writer.writeEncodedStringWithLength16(string, this.comm.SingleByteClientTransliterator);
            }
            this.writer.writeCodePointLength(n6);
            if (this.comm.encryptData) {
                this.writer.writeEncryptedPacketLength(n5);
            } else {
                this.writer.writePacketLength(n5);
            }
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit) {
                if (this.implConn.isXAImplConn) {
                    int n7 = this.writer.writePacketHeader((short)1, (short)0, n4);
                    int n8 = this.writer.writeCodePoint((short)4181);
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(4487);
                    this.writer.writeInt8(3);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6145);
                    this.writer.writeInt32(-1);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6403);
                    this.writer.writeInt32(0x10000000);
                    this.writer.writeCodePointLength(n8);
                    this.writer.writePacketLength(n7);
                } else {
                    int n9 = this.writer.writePacketHeader((short)1, (short)0, n4);
                    int n10 = this.writer.writeCodePoint((short)8206);
                    this.writer.writeCodePointLength(n10);
                    this.writer.writePacketLength(n9);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 8729: 
                case 9235: {
                    break;
                }
                case 8709: {
                    if (this.numResultSets >= 1) {
                        this.resultSetArray = new DB2ImplResultSet[this.numResultSets];
                        this.createResultSetCaches(baseWarnings);
                    }
                    this.isCursorOpen = true;
                    this.moreData = true;
                    this.resultType = 2;
                    this.isStoredProcedure = true;
                    this.isStoredProcedureRS = true;
                    if (this.numResultSets >= 1) {
                        return false;
                    }
                    break;
                }
                case 8505: {
                    this.numResultSets = n / 68;
                    this.packageNameCsnList = new DRDAPkgNamCsn[this.numResultSets];
                    for (int i = 0; i < this.numResultSets; ++i) {
                        this.reader.readAndDiscardBytes(4);
                        String string = this.reader.readEncodedString(18, this.comm.defaultCCSIDTransliterator);
                        String string2 = this.reader.readEncodedString(18, this.comm.defaultCCSIDTransliterator);
                        String string3 = this.reader.readEncodedString(18, this.comm.defaultCCSIDTransliterator);
                        String string4 = this.reader.readEncodedString(8, this.comm.transliteratorPool.getTransliteratorForCodePage("1252"));
                        short s = this.reader.readInt16();
                        this.packageNameCsnList[i] = new DRDAPkgNamCsn(string, string2, string3, s, string4);
                    }
                    break;
                }
                case 16: {
                    this.processFDODSC(n, true);
                    break;
                }
                case 5242: {
                    if ((short)(n + 4) == -32760) {
                        n = this.reader.readInt32();
                    }
                    this.processSQLCA(baseWarnings);
                    this.updateParameterData();
                    int n3 = this.storedProcedureParams.size();
                    for (int i = 0; i < n3; ++i) {
                        DRDAParameter dRDAParameter = (DRDAParameter)this.storedProcedureParams.get(i);
                        if (!dRDAParameter.hasExtendedData || dRDAParameter.readExtendedData) continue;
                        this.processEXTDTAParam(dRDAParameter, false);
                    }
                    break;
                }
                case 9230: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 8469: {
                    byte by = this.reader.readInt8();
                    break;
                }
                case 8728: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 9224: {
                    if (this.executingBatch && this.currentUpdateCount < this.updateCounts.length) {
                        this.processSQLCA(baseWarnings);
                        if (this.processingSQLCAforPrepare) {
                            this.processingSQLCAforPrepare = false;
                            break;
                        }
                        if (this.exception != null && (this.currentExceptionCount == 0 || this.currentExceptionCount < this.numExceptions)) {
                            ++this.currentExceptionCount;
                            this.updateCounts[this.currentUpdateCount++] = -3;
                            break;
                        }
                        this.updateCounts[this.currentUpdateCount++] = this.numRowsAffected;
                        break;
                    }
                    return super.processCodePoint(n, n2, baseWarnings);
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        return true;
    }

    private void createResultSetCaches(BaseWarnings baseWarnings) throws UtilException, SQLException {
        int n = this.codePoint;
        int n2 = this.codePointLength;
        for (int i = 0; i < this.numResultSets; ++i) {
            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
            int n3 = 0;
            int n4 = 0;
            n3 = this.reader.addPacketToBuffer(n3, n2 + 4, n, utilPagedTempBuffer);
            boolean bl = true;
            block4: while (bl && !this.reader.atEndOfReply()) {
                n2 = this.reader.readInt16() - 4;
                n = this.reader.readInt16();
                switch (n) {
                    case 8709: {
                        bl = false;
                        continue block4;
                    }
                }
                n4 = n3;
                n3 = this.reader.addPacketToBuffer(n3, n2 + 4, n, utilPagedTempBuffer);
                bl = true;
            }
            if (utilPagedTempBuffer.getSize() > 0L) {
                utilPagedTempBuffer.write((long)(n4 + 3), (byte)0);
            }
            this.resultSetArray[i] = new DB2ImplResultSet(this, this.comm);
            this.resultSetArray[i].makeResultSetCached(utilPagedTempBuffer, n3, this.parameterDescriptions, this.packageNameCsnList[i]);
            this.resultSetArray[i].setImplStatement(this.implStmt);
        }
    }
}

