/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.util;

import com.metamatrix.common.types.BlobType;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.ValueRetriever;
import com.metamatrix.connector.jdbc.extension.ValueTranslator;
import com.metamatrix.connector.jdbc.util.ValueTranslatorAdaptor;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.MetadataObject;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JDBCExecutionHelper {
    public static Class[] getColumnDataTypes(ICommand command) {
        Class[] dataTypes = null;
        if (command instanceof IQuery) {
            List selectSymbols = ((IQuery)command).getSelect().getSelectSymbols();
            dataTypes = new Class[selectSymbols.size()];
            Iterator iterator = selectSymbols.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                ISelectSymbol selectSymbol = (ISelectSymbol)iterator.next();
                dataTypes[i] = selectSymbol.getExpression().getType();
                ++i;
            }
        }
        return dataTypes;
    }

    public static Batch createBatch(int updateCount) {
        BasicBatch batch = new BasicBatch();
        ArrayList<Integer> row = new ArrayList<Integer>(1);
        row.add(new Integer(updateCount));
        batch.addRow(row);
        batch.setLast();
        return batch;
    }

    public static Batch createBatch(ResultSet results, Class[] columnDataTypes, int maxBatchSize, boolean trimStrings, ResultsTranslator resultsTranslator, ExecutionContext context, Calendar calendar) throws ConnectorException {
        BasicBatch batch = new BasicBatch();
        JDBCExecutionHelper.transferResults((Batch)batch, results, columnDataTypes, maxBatchSize, true, trimStrings, resultsTranslator, context, calendar);
        return batch;
    }

    public static void fillBatch(Batch batch, ResultSet results, Class[] columnDataTypes, int maxBatchSize, boolean trimStrings, ResultsTranslator resultsTranslator, ExecutionContext context, Calendar calendar) throws ConnectorException {
        JDBCExecutionHelper.transferResults(batch, results, columnDataTypes, maxBatchSize, false, trimStrings, resultsTranslator, context, calendar);
    }

    protected static void transferResults(Batch batch, ResultSet results, Class[] columnTypes, int maxBatchSize, boolean setLastBatch, boolean trimStrings, ResultsTranslator resultsTranslator, ExecutionContext context, Calendar calendar) throws ConnectorException {
        if (results == null) {
            return;
        }
        boolean[] trimColumn = new boolean[columnTypes.length];
        try {
            ResultSetMetaData rsmd = results.getMetaData();
            for (int i = 0; i < columnTypes.length; ++i) {
                if (!columnTypes[i].equals(String.class) || !trimStrings && rsmd.getColumnType(i + 1) != 1) continue;
                trimColumn[i] = true;
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage());
        }
        boolean[] transformKnown = new boolean[columnTypes.length];
        ValueTranslator[] transforms = new ValueTranslator[columnTypes.length];
        ArrayList<Object> vals = null;
        int numCols = columnTypes.length;
        List valueTranslators = resultsTranslator.getValueTranslators();
        ValueRetriever valueRetriever = resultsTranslator.getValueRetriever();
        try {
            int rowCnt;
            for (rowCnt = 0; rowCnt < maxBatchSize && results.next(); ++rowCnt) {
                vals = new ArrayList<Object>(numCols);
                for (int i = 0; i < numCols; ++i) {
                    Object value = valueRetriever.retrieveValue(results, i + 1, columnTypes[i], calendar);
                    if (value != null) {
                        if (!transformKnown[i]) {
                            Class<?> valueType = value.getClass();
                            if (!columnTypes[i].isAssignableFrom(valueType)) {
                                transforms[i] = JDBCExecutionHelper.determineTransformation(valueType, columnTypes[i], valueTranslators);
                            } else if (columnTypes[i].equals(Object.class) && Blob.class.isAssignableFrom(valueType)) {
                                transforms[i] = JDBCExecutionHelper.determineTransformation(valueType, BlobType.class, valueTranslators);
                            }
                            transformKnown[i] = true;
                        }
                        if (transforms[i] != null) {
                            value = transforms[i].translate(value, context);
                        } else if (columnTypes[i].equals(Object.class) && Blob.class.isAssignableFrom(value.getClass())) {
                            Blob bValue = (Blob)value;
                            value = bValue.getBytes(1L, (int)bValue.length());
                        }
                        if (trimColumn[i]) {
                            value = JDBCExecutionHelper.trimString((String)value);
                        }
                    }
                    vals.add(value);
                }
                batch.addRow(vals);
            }
            if (rowCnt < maxBatchSize && setLastBatch) {
                batch.setLast();
            }
        }
        catch (ConnectorException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e), JDBCPlugin.Util.getString("JDBCTranslator.Unexpected_exception_translating_results___8", (Object)e.getMessage()));
        }
        catch (Throwable e) {
            throw new ConnectorException(e, JDBCPlugin.Util.getString("JDBCTranslator.Unknown_error_translating_results___9", (Object)e.getMessage()));
        }
    }

    public static List setParametersForUpdateLOB(ICommand command) {
        LinkedList modifyParams;
        block3: {
            block2: {
                modifyParams = null;
                if (!(command instanceof IInsert)) break block2;
                List originalParams = ((IInsert)command).getValues();
                modifyParams = new LinkedList(originalParams);
                Iterator iter = modifyParams.iterator();
                while (iter.hasNext()) {
                    ILiteral param = (ILiteral)iter.next();
                    Object literalValue = param.getValue();
                    if (literalValue != null && (literalValue == null || List.class.isAssignableFrom(literalValue.getClass()) || Blob.class.isAssignableFrom(literalValue.getClass()) || Clob.class.isAssignableFrom(literalValue.getClass()))) continue;
                    iter.remove();
                }
                break block3;
            }
            if (!(command instanceof IUpdate)) break block3;
            List originalParams = ((IUpdate)command).getChanges();
            modifyParams = new LinkedList(originalParams);
            Iterator iter = modifyParams.iterator();
            while (iter.hasNext()) {
                ICompareCriteria param = (ICompareCriteria)iter.next();
                Object right = ((ILiteral)param.getRightExpression()).getValue();
                if (right != null && (right == null || List.class.isAssignableFrom(right.getClass()) || Blob.class.isAssignableFrom(right.getClass()) || Clob.class.isAssignableFrom(right.getClass()))) continue;
                iter.remove();
            }
        }
        return modifyParams;
    }

    public static Map createParameterIndexMap(List parameters, String sql) {
        if (parameters == null || parameters.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<IParameter, Integer> paramsIndexes = new HashMap<IParameter, Integer>();
        int index = 1;
        for (IParameter param : parameters) {
            if (param.getDirection() != 3) continue;
            paramsIndexes.put(param, new Integer(index++));
            break;
        }
        for (IParameter param : parameters) {
            if (param.getDirection() == 4 || param.getDirection() == 3) continue;
            paramsIndexes.put(param, new Integer(index++));
        }
        return paramsIndexes;
    }

    public static Class[] getColumnDataTypes(List params, RuntimeMetadata metadata) throws ConnectorException {
        if (params != null) {
            IParameter resultSet = null;
            for (IParameter param : params) {
                if (param.getDirection() != 4) continue;
                resultSet = param;
                break;
            }
            if (resultSet != null) {
                List columnMetadata = null;
                columnMetadata = resultSet.getMetadataID().getChildIDs();
                int size = columnMetadata.size();
                Class[] coulmnDTs = new Class[size];
                for (int i = 0; i < size; ++i) {
                    MetadataID mID = (MetadataID)columnMetadata.get(i);
                    MetadataObject mObj = metadata.getObject(mID);
                    coulmnDTs[i] = ((Element)mObj).getJavaType();
                }
                return coulmnDTs;
            }
        }
        return new Class[0];
    }

    public static Object convertValue(Object value, Class expectedType, List valueTranslators, boolean trimStrings, ExecutionContext context) throws ConnectorException {
        if (expectedType.isAssignableFrom(value.getClass())) {
            return value;
        }
        ValueTranslator translator = JDBCExecutionHelper.determineTransformation(value.getClass(), expectedType, valueTranslators);
        Object result = translator.translate(value, context);
        if (trimStrings && result instanceof String) {
            result = ((String)result).trim();
        }
        return result;
    }

    protected static ValueTranslator determineTransformation(Class actualType, Class expectedType, List valueTranslators) throws ConnectorException {
        ValueTranslatorAdaptor valueTranslator = null;
        if (valueTranslators != null && !valueTranslators.isEmpty()) {
            for (ValueTranslator translator : valueTranslators) {
                if (!expectedType.equals(translator.getTargetType()) || !translator.getSourceType().isAssignableFrom(actualType)) continue;
                valueTranslator = translator;
                break;
            }
        }
        if (valueTranslator == null) {
            Transform transform = DataTypeManager.getTransform((Class)actualType, (Class)expectedType);
            if (transform == null) {
                throw new ConnectorException(JDBCPlugin.Util.getString("JDBCTranslator.Unable_to_translate_data_value__11", (Object)actualType.getName(), (Object)expectedType.getName()));
            }
            valueTranslator = new ValueTranslatorAdaptor(transform);
        }
        return valueTranslator;
    }

    static String trimString(String value) {
        for (int i = value.length() - 1; i >= 0; --i) {
            if (value.charAt(i) == ' ') continue;
            return value.substring(0, i + 1);
        }
        return "";
    }
}

