/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import javax.naming.NoPermissionException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.HARMIServer;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;

public class HARMIServerGuard
implements HARMIServer,
Serializable {
    private static Logger log = Logger.getLogger(HARMIServerGuard.class);
    private HARMIServer guardedHARMIServer;

    public HARMIServerGuard(HARMIServer guardedHARMIServer) {
        this.guardedHARMIServer = guardedHARMIServer;
    }

    public HARMIResponse invoke(long tag, MarshalledInvocation mi) throws Exception {
        log.info((Object)("RMI local invocation =" + mi.isLocal()));
        Method method = mi.getMethod();
        if ("bind,rebind,unbind,createSubcontext".indexOf(method.getName()) != -1) {
            throw new NoPermissionException(method.getName() + " JNDI operation not allowed when on non-local invocation.");
        }
        return this.guardedHARMIServer.invoke(tag, mi);
    }

    public List getReplicants() throws Exception {
        return this.guardedHARMIServer.getReplicants();
    }

    public Object getLocal() throws Exception {
        return this.guardedHARMIServer.getLocal();
    }
}

