/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.jms;

import java.lang.reflect.Method;
import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.integration.hornetq.management.jms.JMSManageMO;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;

@ManagementObject(componentType=@ManagementComponent(type="JMSManage", subtype="ServerManage"), properties=ManagementProperties.EXPLICIT, isRuntime=true)
public class JMSServerMO
extends JMSManageMO {
    public JMSServerMO(HornetQServer server) {
        super(server);
    }

    @ManagementOperation(name="getVersion", description="returns the servers version")
    public String getVersion() {
        JMSServerControl jmsServerControl = this.getJmsServerControl();
        if (jmsServerControl == null) {
            return null;
        }
        return jmsServerControl.getVersion();
    }

    @ManagementOperation(name="getVersion", description="returns the servers status")
    public boolean isStarted() {
        JMSServerControl jmsServerControl = this.getJmsServerControl();
        return jmsServerControl != null && jmsServerControl.isStarted();
    }

    @ManagementOperation(name="invokeManagerOperation", description="invokes a queues method", params={@ManagementParameter(name="name", description="the name"), @ManagementParameter(name="method", description="the method"), @ManagementParameter(name="params", description="the method params")})
    public Object invokeManagerOperation(String name, String method, String[] params, String[] type) throws Exception {
        Class[] classes = this.getClassTypes(type);
        Method m = null;
        try {
            JMSServerControl jmsServerControl = this.getJmsServerControl();
            m = jmsServerControl.getClass().getMethod(method, classes);
            return m.invoke((Object)jmsServerControl, this.getParams(params, classes));
        }
        catch (NoSuchMethodException e) {
            HornetQServerControl hornetQServerControl = this.getHornetQServerControl();
            m = hornetQServerControl.getClass().getMethod(method, classes);
            return m.invoke((Object)hornetQServerControl, this.getParams(params, classes));
        }
    }
}

