/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.util.Collections;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;
import org.jboss.modcluster.AbstractModClusterService;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.ServerProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProvider;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.impl.BusyConnectorsLoadMetric;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModClusterListener
extends AbstractModClusterService {
    private static final Logger log;
    private final StringManager sm = StringManager.getManager((String)Constants.Package);
    private Class<? extends LoadMetric> loadMetricClass = BusyConnectorsLoadMetric.class;
    private int decayFactor = 2;
    private int history = 9;
    private double capacity = 1.0;

    public ModClusterListener() {
    }

    protected ModClusterListener(MCMPHandler mcmpHandler, MCMPRequestFactory requestFactory, ServerProvider<Server> serverProvider, LifecycleListener lifecycleListener) {
        super(mcmpHandler, requestFactory, serverProvider, lifecycleListener);
    }

    @Override
    public LoadBalanceFactorProvider createLoadBalanceFactorProvider() {
        try {
            LoadMetric metric = this.loadMetricClass.newInstance();
            metric.setCapacity(this.capacity);
            DynamicLoadBalanceFactorProvider provider = new DynamicLoadBalanceFactorProvider(Collections.singleton(metric));
            provider.setDecayFactor(this.decayFactor);
            provider.setHistory(this.history);
            return provider;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        super.lifecycleEvent(event);
        Lifecycle source = event.getLifecycle();
        if (source instanceof Server) {
            Server server = (Server)source;
            String type = event.getType();
            if ("after_start".equals(type)) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).registerComponent((Object)this, name, null);
                }
                catch (Exception e) {
                    log.error((Object)this.sm.getString("modcluster.error.jmxRregister"), (Throwable)e);
                }
            } else if ("stop".equals(type)) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).unregisterComponent(name);
                }
                catch (Exception e) {
                    log.error((Object)this.sm.getString("modcluster.error.jmxUnregister"), (Throwable)e);
                }
            }
        }
    }

    private ObjectName getObjectName(Server server) throws MalformedObjectNameException {
        String domain = (String)IntrospectionUtils.getProperty((Object)server, (String)"domain");
        return ObjectName.getInstance(domain, "type", "ModClusterListener");
    }

    public String getLoadMetricClass() {
        return this.loadMetricClass.getName();
    }

    public void setLoadMetricClass(String loadMetricClass) throws ClassNotFoundException {
        this.loadMetricClass = Class.forName(loadMetricClass).asSubclass(LoadMetric.class);
    }

    public int getLoadDecayFactor() {
        return this.decayFactor;
    }

    public void setLoadDecayFactor(int decayFactor) {
        this.decayFactor = decayFactor;
    }

    public int getLoadHistory() {
        return this.history;
    }

    public void setLoadHistory(int history) {
        this.history = history;
    }

    public double getLoadMetricCapacity() {
        return this.capacity;
    }

    public void setLoadMetricCapacity(String capacity) {
        this.capacity = Double.parseDouble(capacity);
    }

    static {
        if (Logger.getPluginClassName() == null) {
            String pluginClass = "org.jboss.logging.jdk.JDK14LoggerPlugin";
            try {
                ModClusterListener.class.getClassLoader().loadClass(pluginClass);
                Logger.setPluginClassName((String)pluginClass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        log = Logger.getLogger(ModClusterListener.class);
    }
}

