/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.cursor.impl;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.core.paging.Page;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.cursor.PageCache;

public class PageCacheImpl
implements PageCache {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private PagedMessage[] messages;
    private final Page page;

    public PageCacheImpl(Page page) {
        this.page = page;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PagedMessage getMessage(int messageNumber) {
        this.lock.readLock().lock();
        try {
            if (messageNumber < this.messages.length) {
                PagedMessage pagedMessage = this.messages[messageNumber];
                return pagedMessage;
            }
            PagedMessage pagedMessage = null;
            return pagedMessage;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public long getPageId() {
        return this.page.getPageId();
    }

    @Override
    public void lock() {
        this.lock.writeLock().lock();
    }

    @Override
    public void unlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public void setMessages(PagedMessage[] messages) {
        this.messages = messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfMessages() {
        this.lock.readLock().lock();
        try {
            int n = this.messages.length;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isLive() {
        return false;
    }

    public String toString() {
        return "PageCacheImpl::page=" + this.page.getPageId() + " numberOfMessages = " + this.messages.length;
    }

    @Override
    public PagedMessage[] getMessages() {
        return this.messages;
    }
}

