/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import java.util.List;
import java.util.Map;
import javax.management.MBeanOperationInfo;
import org.hornetq.api.core.management.ClusterConnectionControl;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.management.impl.AbstractControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.utils.json.JSONArray;

public class ClusterConnectionControlImpl
extends AbstractControl
implements ClusterConnectionControl {
    private final ClusterConnection clusterConnection;
    private final ClusterConnectionConfiguration configuration;

    public ClusterConnectionControlImpl(ClusterConnection clusterConnection, StorageManager storageManager, ClusterConnectionConfiguration configuration) throws Exception {
        super(ClusterConnectionControl.class, storageManager);
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAddress() {
        this.clearIO();
        try {
            String string = this.configuration.getAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiscoveryGroupName() {
        this.clearIO();
        try {
            String string = this.configuration.getDiscoveryGroupName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxHops() {
        this.clearIO();
        try {
            int n = this.configuration.getMaxHops();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRetryInterval() {
        this.clearIO();
        try {
            long l = this.configuration.getRetryInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeID() {
        this.clearIO();
        try {
            String string = this.clusterConnection.getNodeID();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStaticConnectors() {
        this.clearIO();
        try {
            if (this.configuration.getStaticConnectors() == null) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = this.configuration.getStaticConnectors().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStaticConnectorsAsJSON() throws Exception {
        this.clearIO();
        try {
            List<String> connectors = this.configuration.getStaticConnectors();
            if (connectors == null) {
                String string = null;
                return string;
            }
            JSONArray array = new JSONArray();
            for (String connector : connectors) {
                array.put(connector);
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDuplicateDetection() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isDuplicateDetection();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isForwardWhenNoConsumers() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isForwardWhenNoConsumers();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTopology() {
        this.clearIO();
        try {
            String string = this.clusterConnection.getTopology().describe();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getNodes() throws Exception {
        this.clearIO();
        try {
            Map<String, String> map = this.clusterConnection.getNodes();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.clusterConnection.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.clearIO();
        try {
            this.clusterConnection.start();
            this.clusterConnection.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        this.clearIO();
        try {
            this.clusterConnection.stop();
            this.clusterConnection.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(ClusterConnectionControl.class);
    }
}

