/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class ConcurrentStackTest
extends ChannelTestBase {
    JChannel ch1;
    JChannel ch2;
    JChannel ch3;
    static final int NUM = 10;
    static final int EXPECTED = 30;
    static final long SLEEPTIME = 500L;
    CyclicBarrier barrier;

    public ConcurrentStackTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.barrier = new CyclicBarrier(4);
        this.ch1 = this.createChannel();
        this.ch2 = this.createChannel();
        this.ch3 = this.createChannel();
    }

    @Override
    protected void tearDown() throws Exception {
        Util.close(this.ch3, this.ch2, this.ch1);
        this.barrier.reset();
        super.tearDown();
    }

    public void testSequentialDelivery() throws Exception {
        this.doIt(false);
    }

    public void testConcurrentDelivery() throws Exception {
        this.doIt(true);
    }

    private void doIt(boolean use_concurrent_stack) throws Exception {
        ConcurrentStackTest.setConcurrentStack(this.ch1, use_concurrent_stack);
        ConcurrentStackTest.setConcurrentStack(this.ch2, use_concurrent_stack);
        ConcurrentStackTest.setConcurrentStack(this.ch3, use_concurrent_stack);
        MyReceiver r1 = new MyReceiver("R1");
        MyReceiver r2 = new MyReceiver("R2");
        MyReceiver r3 = new MyReceiver("R3");
        this.ch1.setReceiver(r1);
        this.ch2.setReceiver(r2);
        this.ch3.setReceiver(r3);
        this.ch1.connect("test");
        this.ch2.connect("test");
        this.ch3.connect("test");
        View v = this.ch3.getView();
        ConcurrentStackTest.assertEquals((int)3, (int)v.size());
        new Thread((Runnable)new Sender(this.ch1)){}.start();
        new Thread((Runnable)new Sender(this.ch2)){}.start();
        new Thread((Runnable)new Sender(this.ch3)){}.start();
        this.barrier.await();
        long start = System.currentTimeMillis();
        TimeoutException ex = null;
        try {
            this.barrier.await(19500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            ex = e;
        }
        long stop = System.currentTimeMillis();
        long diff = stop - start;
        System.out.println("Total time: " + diff + " ms\n");
        this.checkFIFO(r1);
        this.checkFIFO(r2);
        this.checkFIFO(r3);
        if (ex != null) {
            throw ex;
        }
    }

    private void checkFIFO(MyReceiver r) {
        List msgs = r.getMessages();
        HashMap map = new HashMap();
        for (Pair p : msgs) {
            Address sender = (Address)p.key;
            LinkedList list = (LinkedList)map.get(sender);
            if (list == null) {
                list = new LinkedList();
                map.put(sender, list);
            }
            list.add(p.val);
        }
        boolean fifo = true;
        LinkedList<Address> incorrect_receivers = new LinkedList<Address>();
        System.out.println("Checking FIFO for " + r.getName() + ":");
        for (Address addr : map.keySet()) {
            List list = (List)map.get(addr);
            ConcurrentStackTest.print(addr, list);
            if (ConcurrentStackTest.verifyFIFO(list)) continue;
            fifo = false;
            incorrect_receivers.add(addr);
        }
        System.out.print("\n");
        if (!fifo) {
            ConcurrentStackTest.fail((String)("The following receivers didn't receive all messages in FIFO order: " + incorrect_receivers));
        }
    }

    private static boolean verifyFIFO(List<Integer> list) {
        LinkedList<Integer> list2 = new LinkedList<Integer>(list);
        Collections.sort(list2);
        return ((Object)list).equals(list2);
    }

    private static void print(Address addr, List<Integer> list) {
        StringBuilder sb = new StringBuilder();
        sb.append(addr).append(": ");
        for (Integer i : list) {
            sb.append(i).append(" ");
        }
        System.out.println(sb);
    }

    private static void setConcurrentStack(JChannel ch1, boolean use_concurrent_stack) {
        TP tp = ch1.getProtocolStack().getTransport();
        if (tp == null) {
            throw new IllegalStateException("Transport not found");
        }
        Properties p = new Properties();
        p.setProperty("use_concurrent_stack", String.valueOf(use_concurrent_stack));
        p.setProperty("thread_pool.min_threads", "1");
        p.setProperty("thread_pool.max_threads", "100");
        p.setProperty("thread_pool.queue_enabled", "false");
        tp.setProperties(p);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConcurrentStackTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private class MyReceiver
    extends ReceiverAdapter {
        String name;
        final List<Pair<Address, Integer>> msgs = new LinkedList<Pair<Address, Integer>>();
        AtomicInteger count = new AtomicInteger(0);

        public MyReceiver(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            Util.sleep(500L);
            Pair<Address, Integer> pair = new Pair<Address, Integer>(msg.getSrc(), (Integer)msg.getObject());
            List<Pair<Address, Integer>> list = this.msgs;
            synchronized (list) {
                this.msgs.add(pair);
            }
            if (this.count.incrementAndGet() >= 30) {
                try {
                    ConcurrentStackTest.this.barrier.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public List getMessages() {
            return this.msgs;
        }

        public String getName() {
            return this.name;
        }
    }

    private class Pair<K, V> {
        K key;
        V val;

        public Pair(K key, V val) {
            this.key = key;
            this.val = val;
        }

        public String toString() {
            return this.key + "::" + this.val;
        }
    }

    private class Sender
    implements Runnable {
        Channel ch;
        Address local_addr;

        public Sender(Channel ch) {
            this.ch = ch;
            this.local_addr = ch.getLocalAddress();
        }

        @Override
        public void run() {
            try {
                ConcurrentStackTest.this.barrier.await();
            }
            catch (Throwable t) {
                return;
            }
            for (int i = 1; i <= 10; ++i) {
                Message msg = new Message(null, null, new Integer(i));
                try {
                    this.ch.send(msg);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

