/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jms.delegate.Ack;
import org.jboss.jms.delegate.DefaultAck;
import org.jboss.jms.delegate.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class SessionAcknowledgeDeliveriesRequest
extends RequestSupport {
    private List acks;

    public SessionAcknowledgeDeliveriesRequest() {
    }

    public SessionAcknowledgeDeliveriesRequest(String objectId, byte version, List acks) {
        super(objectId, 305, version);
        this.acks = acks;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        int size = is.readInt();
        this.acks = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            long deliveryId = is.readLong();
            DefaultAck ack = new DefaultAck(deliveryId);
            this.acks.add(ack);
        }
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.acknowledgeDeliveries(this.acks);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeInt(this.acks.size());
        for (Ack ack : this.acks) {
            os.writeLong(ack.getDeliveryID());
        }
        os.flush();
    }
}

