/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.recovery;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.server.recovery.MessagingXAResourceWrapper;
import org.jboss.logging.Logger;

public class MessagingXAResourceWrapper2
implements XAResource,
ExceptionListener {
    private static final Logger log = Logger.getLogger(MessagingXAResourceWrapper2.class);
    private ClientConnectionDelegate connection;
    private XAResource delegate;
    private int node;

    public MessagingXAResourceWrapper2(ClientConnectionDelegate connectionDelegate, int node) throws JMSException {
        try {
            this.connection = connectionDelegate;
            ClientSessionDelegate session = (ClientSessionDelegate)this.connection.createSessionDelegate(true, 0, true);
            this.delegate = session.getXAResource();
            this.node = node;
            this.connection.setExceptionListener(this);
        }
        catch (JMSException e) {
            log.error((Object)(this + " got exception creating XAResource"), (Throwable)e);
            this.close();
            throw e;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            log.debug((Object)("Invoking recover(" + flag + ") on the underlying XAResource."));
            return this.delegate.recover(flag);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        log.debug((Object)("Commit " + this.node + " xid " + " onePhase=" + onePhase));
        try {
            this.delegate.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        log.debug((Object)("Rollback " + this.node + " xid " + xid));
        try {
            this.delegate.rollback(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void forget(Xid xid) throws XAException {
        log.debug((Object)("Forget " + this.node + " xid " + xid));
        try {
            this.delegate.forget(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof MessagingXAResourceWrapper) {
            xaRes = ((MessagingXAResourceWrapper)xaRes).getDelegate();
        }
        try {
            return this.delegate.isSameRM(xaRes);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this.delegate.prepare(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            this.delegate.start(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            this.delegate.end(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return this.delegate.getTransactionTimeout();
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            return this.delegate.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            block4: {
                try {
                    if (this.connection == null) break block4;
                    this.connection.closing(-1L);
                    this.connection.close();
                }
                catch (Exception ignored) {
                    log.trace((Object)"Ignored error during close", (Throwable)ignored);
                    Object var3_2 = null;
                    this.connection = null;
                }
            }
            Object var3_1 = null;
            this.connection = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connection = null;
            throw throwable;
        }
    }

    protected XAException check(XAException e) throws XAException {
        if (e.errorCode == 4) {
            log.debug((Object)("Fatal error in provider " + this.node), (Throwable)e);
            this.close();
        }
        log.debug((Object)("Caught XAException. Error code: " + e.errorCode + ". Will rethrow as XAER_RMFAIL."), (Throwable)e);
        throw new XAException(-7);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void onException(JMSException arg0) {
        this.close();
    }
}

