/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.destination.JBossQueue;
import org.jboss.jms.destination.JBossTemporaryQueue;
import org.jboss.jms.destination.JBossTemporaryTopic;
import org.jboss.jms.destination.JBossTopic;
import org.jboss.jms.exception.MessagingJMSException;
import org.jboss.jms.server.DestinationManager;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.JNDIUtil;

class DestinationJNDIMapper
implements DestinationManager {
    private static final Logger log = Logger.getLogger(DestinationJNDIMapper.class);
    private Context initialContext;
    private Map queueMap = new HashMap();
    private Map topicMap = new HashMap();
    private ServerPeer serverPeer;

    public DestinationJNDIMapper(ServerPeer serverPeer) throws Exception {
        this.serverPeer = serverPeer;
    }

    public synchronized void registerDestination(ManagedDestination destination) throws Exception {
        String jndiName = destination.getJndiName();
        if (!destination.isTemporary()) {
            String jndiNameInContext;
            String parentContext;
            if (jndiName == null) {
                parentContext = destination.isQueue() ? this.serverPeer.getDefaultQueueJNDIContext() : this.serverPeer.getDefaultTopicJNDIContext();
                jndiNameInContext = destination.getName();
                jndiName = parentContext + "/" + jndiNameInContext;
            } else {
                int sepIndex = jndiName.lastIndexOf(47);
                parentContext = sepIndex == -1 ? "" : jndiName.substring(0, sepIndex);
                jndiNameInContext = jndiName.substring(sepIndex + 1);
            }
            destination.setJndiName(jndiName);
            try {
                this.initialContext.lookup(jndiName);
                throw new InvalidDestinationException("Destination " + destination.getName() + " already exists");
            }
            catch (NameNotFoundException e) {
                Context c = JNDIUtil.createContext(this.initialContext, parentContext);
                JBossDestination jbDest = destination.isQueue() ? new JBossQueue(destination.getName()) : new JBossTopic(destination.getName());
                c.rebind(jndiNameInContext, (Object)jbDest);
            }
        }
        if (destination.isQueue()) {
            this.queueMap.put(destination.getName(), destination);
        } else {
            this.topicMap.put(destination.getName(), destination);
        }
        log.debug((Object)((destination.isQueue() ? "queue" : "topic") + " " + destination.getName() + " registered "));
        log.debug((Object)((destination.isQueue() ? "queue" : "topic") + " bound in JNDI as " + jndiName));
    }

    public synchronized void unregisterDestination(ManagedDestination destination) throws Exception {
        String jndiName = null;
        if (destination.isQueue()) {
            ManagedDestination dest = (ManagedDestination)this.queueMap.remove(destination.getName());
            if (dest != null) {
                jndiName = dest.getJndiName();
            }
        } else {
            ManagedDestination dest = (ManagedDestination)this.topicMap.remove(destination.getName());
            if (dest != null) {
                jndiName = dest.getJndiName();
            }
        }
        if (jndiName == null) {
            return;
        }
        if (!destination.isTemporary()) {
            this.initialContext.unbind(jndiName);
            this.serverPeer.getSecurityManager().clearSecurityConfig(destination.isQueue(), destination.getName());
        }
        log.debug((Object)("unregistered " + (destination.isQueue() ? "queue " : "topic ") + destination.getName()));
    }

    public synchronized ManagedDestination getDestination(String name, boolean isQueue) {
        Map m = isQueue ? this.queueMap : this.topicMap;
        ManagedDestination holder = (ManagedDestination)m.get(name);
        return holder;
    }

    public synchronized Set getDestinations() {
        HashSet<JBossDestination> destinations = new HashSet<JBossDestination>();
        for (ManagedDestination dest : this.queueMap.values()) {
            if (dest.isTemporary()) {
                destinations.add(new JBossTemporaryQueue(dest.getName()));
                continue;
            }
            destinations.add(new JBossQueue(dest.getName()));
        }
        for (ManagedDestination dest : this.topicMap.values()) {
            if (dest.isTemporary()) {
                destinations.add(new JBossTemporaryTopic(dest.getName()));
                continue;
            }
            destinations.add(new JBossTopic(dest.getName()));
        }
        return destinations;
    }

    public void start() throws Exception {
        this.initialContext = new InitialContext();
        this.createContext(this.serverPeer.getDefaultQueueJNDIContext());
        this.createContext(this.serverPeer.getDefaultTopicJNDIContext());
    }

    public void stop() throws Exception {
        HashSet queues = new HashSet(this.queueMap.values());
        HashSet topics = new HashSet(this.topicMap.values());
        Iterator i = queues.iterator();
        while (i.hasNext()) {
            this.unregisterDestination((ManagedDestination)i.next());
        }
        i = topics.iterator();
        while (i.hasNext()) {
            this.unregisterDestination((ManagedDestination)i.next());
        }
        String defaultJndi = this.serverPeer.getDefaultQueueJNDIContext();
        if (!defaultJndi.trim().equals("")) {
            this.initialContext.unbind(defaultJndi);
        }
        if (!(defaultJndi = this.serverPeer.getDefaultTopicJNDIContext()).trim().equals("")) {
            this.initialContext.unbind(defaultJndi);
        }
        this.initialContext.close();
    }

    private void createContext(String contextName) throws Exception {
        Object context = null;
        try {
            context = this.initialContext.lookup(contextName);
            if (!(context instanceof Context)) {
                throw new MessagingJMSException(contextName + " is already bound " + " and is not a JNDI context!");
            }
        }
        catch (NameNotFoundException e) {
            this.initialContext.createSubcontext(contextName);
            log.debug((Object)(contextName + " subcontext created"));
        }
    }
}

