/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxws;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.FaultAction;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.common.handler.GenericSOAPHandler;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAddressingServerHandler
extends GenericSOAPHandler {
    private static Logger log = Logger.getLogger(WSAddressingServerHandler.class);
    private static AddressingBuilder ADDR_BUILDER;
    private static AddressingConstantsImpl ADDR_CONSTANTS;
    private static Set<QName> HEADERS;

    public Set getHeaders() {
        return Collections.unmodifiableSet(HEADERS);
    }

    protected boolean handleInbound(MessageContext msgContext) {
        String wsaAction;
        String soapAction;
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleInbound");
        }
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)ADDR_BUILDER.newAddressingProperties();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        CommonMessageContext commonMsgContext = (CommonMessageContext)msgContext;
        ServerEndpointMetaData serverMetaData = (ServerEndpointMetaData)commonMsgContext.getEndpointMetaData();
        AddressingFeature addrFeature = serverMetaData.getFeature(AddressingFeature.class);
        if (addrFeature != null && addrFeature.isRequired()) {
            try {
                soapMessage.setProperty("isRequired", (Object)true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        addrProps.readHeaders(soapMessage);
        msgContext.put((Object)"javax.xml.ws.addressing.context.inbound", (Object)addrProps);
        msgContext.setScope("javax.xml.ws.addressing.context.inbound", MessageContext.Scope.APPLICATION);
        msgContext.put((Object)"javax.xml.ws.reference.parameters", WSAddressingServerHandler.convertToElementList(addrProps.getReferenceParameters().getElements()));
        msgContext.setScope("javax.xml.ws.reference.parameters", MessageContext.Scope.APPLICATION);
        String[] soapActions = commonMsgContext.getMessageAbstraction().getMimeHeaders().getHeader("SOAPAction");
        if (!(soapActions == null || soapActions.length <= 0 || (soapAction = soapActions[0]).equals("\"\"") || addrProps.getAction() == null || soapAction.equals(wsaAction = addrProps.getAction().getURI().toString()) || soapAction.equals("\"" + wsaAction + "\""))) {
            try {
                SOAPFaultImpl fault = new SOAPFaultImpl();
                fault.setFaultCode(new QName(ADDR_CONSTANTS.getNamespaceURI(), "ActionMismatch"));
                fault.setFaultString("Mismatch between soap action:" + soapAction + " and wsa action:\"" + addrProps.getAction().getURI() + "\"");
                Detail detail = fault.addDetail();
                detail.addDetailEntry(new QName(ADDR_CONSTANTS.getNamespaceURI(), "ProblemAction"));
                throw new SOAPFaultException((SOAPFault)fault);
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        return true;
    }

    private static List<Element> convertToElementList(List<Object> objects) {
        if (objects == null) {
            return null;
        }
        LinkedList<Element> elements = new LinkedList<Element>();
        for (Object o : objects) {
            if (!(o instanceof Element)) continue;
            elements.add((Element)o);
        }
        return elements;
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleOutbound");
        }
        this.handleResponseOrFault(msgContext, false);
        return true;
    }

    public boolean handleFault(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleFault");
        }
        this.handleResponseOrFault(msgContext, true);
        return true;
    }

    private void handleResponseOrFault(MessageContext msgContext, boolean isFault) {
        SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        SOAPAddressingProperties inProps = (SOAPAddressingProperties)msgContext.get((Object)"javax.xml.ws.addressing.context.inbound");
        SOAPAddressingProperties outProps = (SOAPAddressingProperties)msgContext.get((Object)"javax.xml.ws.addressing.context.outbound");
        if (outProps == null) {
            outProps = (SOAPAddressingProperties)builder.newAddressingProperties();
            msgContext.put((Object)"javax.xml.ws.addressing.context.outbound", (Object)outProps);
            msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
        }
        if (inProps != null) {
            outProps.initializeAsReply(inProps, isFault);
        }
        try {
            OperationMetaData opMetaData = ((CommonMessageContext)msgContext).getOperationMetaData();
            if (!isFault && !opMetaData.isOneWay()) {
                AddressingOpMetaExt addrExt = (AddressingOpMetaExt)opMetaData.getExtension(ADDR_CONSTANTS.getNamespaceURI());
                if (addrExt != null) {
                    outProps.setAction(ADDR_BUILDER.newURI(addrExt.getOutboundAction()));
                } else {
                    log.warn((Object)("Unable to resolve replyAction for " + opMetaData.getQName()));
                }
            } else if (isFault) {
                AddressingOpMetaExt addrExt = (AddressingOpMetaExt)opMetaData.getExtension(ADDR_CONSTANTS.getNamespaceURI());
                if (addrExt != null && msgContext.get((Object)"Exception") != null && addrExt.getFaultActions() != null && addrExt.getFaultActions().length > 0) {
                    Exception ex = (Exception)msgContext.get((Object)"Exception");
                    for (FaultAction faultAction : addrExt.getFaultActions()) {
                        if (!faultAction.className().getName().equals(ex.getClass().getName())) continue;
                        outProps.setAction(ADDR_BUILDER.newURI(faultAction.value()));
                        break;
                    }
                }
                if (outProps.getAction() == null) {
                    outProps.setAction(ADDR_BUILDER.newURI(ADDR_CONSTANTS.getDefaultFaultAction()));
                }
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error setting response action", (Throwable)e);
        }
        outProps.writeHeaders(soapMessage);
    }

    private void validateRequest(SOAPAddressingProperties addrProps) {
        if (addrProps.getReplyTo() != null && addrProps.getMessageID() == null) {
            throw new IllegalArgumentException("wsa:MessageId is required when wsa:ReplyTo is supplied");
        }
    }

    static {
        HEADERS = new HashSet<QName>();
        ADDR_CONSTANTS = new AddressingConstantsImpl();
        ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
        HEADERS.add(ADDR_CONSTANTS.getActionQName());
        HEADERS.add(ADDR_CONSTANTS.getToQName());
    }
}

