require 'test_helper'

class ThreeScale::IpAddressValidatorTest < ActiveSupport::TestCase

  def test_validate_each

    validator = ThreeScale::IpAddressValidator.new(attributes: [:api_backend])

    record = Proxy.new
    errors = validator.validate_each(record, :api_backend, 'http://174.129.235.69')
    assert_equal ["can't be ip address"], errors
    assert record.errors.present?

    record = Proxy.new
    errors = validator.validate_each(record, :api_backend, 'http://54.234.21.19/v1/przyslist.json?district=lsm')
    assert_equal ["can't be ip address"], errors
    assert record.errors.present?

    record = Proxy.new
    errors = validator.validate_each(record, :api_backend, 'hrdt://smth')
    assert_equal nil, errors
    assert record.errors.empty?

    record = Proxy.new
    errors = validator.validate_each(record, :api_backend, '')
    assert_equal nil, errors
    assert record.errors.empty?

    record = Proxy.new
    errors = validator.validate_each(record, :api_backend, nil)
    assert_equal nil, errors
    assert record.errors.empty?

  end
end