require 'test_helper'

class BackendClient::Service::LogRequestsTest < ActiveSupport::TestCase

  include TestHelpers::FakeWeb

  def setup
    set_backend_host 'example.org'

    @provider_account = Factory(:provider_account)
    @provider_key     = @provider_account.api_key

    @service = @provider_account.first_service!
    @service_id = @service.backend_id

    plan              = Factory(:application_plan, :issuer => @service)
    @cinstance        = Factory(:cinstance, :plan => plan)

    @connection = BackendClient::Connection.new(:host => backend_host)
    @backend   = @connection.service(@service)
  end


  def test_parsing_backend_output
    timestamp = Time.zone.at(Time.zone.now.to_i) # round microseconds, ruby 1.9.3 has #round
    request = 'request text'
    response = 'response text'
    code = 409
    app_id = 409
    requests = [
      {:service_id => @service_id, :app_id => app_id , :timestamp => timestamp, :request => request, :response => response, :code => code}
    ]
    fake_backend_service_log_requests requests

    log_requests = @backend.log_requests

    assert_equal 1, log_requests.size
    log = log_requests.first

    assert_equal @service_id, log[:service_id]
    assert_equal app_id.to_s, log[:app_id]
    assert_equal timestamp, log[:timestamp]
    assert_equal request, log[:request]
    assert_equal response, log[:response]
    assert_equal code.to_s, log[:code]
  end

  def test_deleting_all_log_requests
    fake_backend_service_delete_log_requests

    assert @backend.delete_all_log_requests
  end
end
