require 'test_helper'

class Backend::ModelExtensions::ServiceTest < ActiveSupport::TestCase
  disable_transactional_fixtures!

  test 'stores backend service data when service is saved' do
    service = FactoryGirl.build(:service,
      account: FactoryGirl.create(:provider_account), referrer_filters_required: true)

    ThreeScale::Core::Service.expects(:save!).with do |params|
      params[:id] == service.backend_id &&
        params[:referrer_filters_required] == true
    end

    service.save!
  end

  test 'deletes backend service data when service is destroyed' do
    service = FactoryGirl.create(
      :service, account: FactoryGirl.create(:provider_account), metrics: [])

    ThreeScale::Core::Service.expects(:delete_by_id!).with do |id|
      id == service.backend_id
    end

    service.destroy
  end

  test 'updates notification settings to backend' do
    service = FactoryGirl.create(:simple_service)

    service.expects(:update_notification_settings)

    service.notification_settings = { buyer_web: [50] }
    service.save
  end
end
