require 'test_helper'

class Abilities::LogRequestsTest < ActiveSupport::TestCase

  # REFACTOR: what about DRYing this up with other switch tests?

  def setup
    @provider = Factory(:provider_account)
    assert @provider.settings.log_requests.denied?
  end

  test 'provider can manage log requests' do
    user = Factory(:user, :account => @provider, :role => :member)
    ability = Ability.new(user)

    assert_cannot ability, :admin, :log_requests
    assert_cannot ability, :see, :log_requests


    # member sees
    @provider.settings.allow_log_requests!
    assert_can ability.reload!, :see, :log_requests
    assert_cannot ability, :admin, :log_requests

    # member with permission admins
    user.member_permissions.create(admin_section: "monitoring")
    assert_can ability.reload!, :admin, :log_requests

    # Admin admins && manages
    user.update_attribute :role, :admin
    ability.reload!

    assert_can ability, :admin, :log_requests
    assert_can ability, :manage, :log_requests
  end

  test 'buyer can manage log requests' do
    buyer   = Factory(:buyer_account, :provider_account => @provider)
    user    = Factory(:user, :account => buyer, :role => :member)
    ability = Ability.new(user)

    assert_cannot ability, :see, :log_requests
    assert_cannot ability, :admin, :log_requests

    @provider.settings.allow_log_requests!
    assert_cannot ability.reload!, :see, :log_requests

    @provider.settings.show_log_requests!
    ability.reload!

    assert_can ability, :see, :log_requests
    assert_cannot ability, :manage, :log_requests
  end
end
