module TestHelpers
  module FakeWeb
    module LogRequests
      def fake_backend_log_requests_body(requests)
        %{
<?xml version="1.0" encoding="UTF-8"?>
<log_requests>
  #{ requests.map do |request|
      %{
    <log_request>
      <service_id>#{request[:service_id]}</service_id>
      <app_id>#{request[:app_id]}</app_id>
      <usage>#{request[:usage] || 'N/A'}</usage>
      <timestamp>#{request[:timestamp].strftime('%Y-%m-%d %H:%M:%S %z')}</timestamp>
      <request>#{request[:request]}</request>
      <response>#{request[:response]}</response>
      <code>#{request[:code]}</code>
   </log_requests>
      }
     end.join
  }
</log_requests>
        }
      end

      def fake_backend_app_log_requests(requests, application_id = @application_id, service_id = @service_id, provider_key = @provider_key)

        ::FakeWeb.register_uri :get, fake_app_url("/log_requests.xml?provider_key=#{provider_key}&service_id=#{service_id}", application_id),
                               :status => [200, 'OK'], :content_type => CONTENT_TYPE,
                               :body => fake_backend_log_requests_body(requests)
      end

      def fake_backend_app_delete_log_requests(application_id = @application_id, service_id = @service_id, provider_key = @provider_key)
        ::FakeWeb.register_uri :delete, fake_app_url("/log_requests.xml?provider_key=#{provider_key}&service_id=#{service_id}", application_id),
                               :status => [200, 'OK'], :content_type => CONTENT_TYPE
      end

      def fake_backend_service_log_requests(requests, service_id = @service_id, provider_key = @provider_key)
        ::FakeWeb.register_uri :get, fake_service_url("/log_requests.xml?provider_key=#{provider_key}", service_id),
                               :status => [200, 'OK'], :content_type => CONTENT_TYPE,
                               :body => fake_backend_log_requests_body(requests)
      end

      def fake_backend_service_delete_log_requests(service_id = @service_id, provider_key = @provider_key)
        ::FakeWeb.register_uri :delete, fake_service_url("/log_requests.xml?provider_key=#{provider_key}", service_id),
                               :status => [200, 'OK'], :content_type => CONTENT_TYPE
      end

    end
  end
end
