require File.expand_path(File.dirname(__FILE__) + '/../../test_helper')

class PaymentExpressTest < ActionDispatch::IntegrationTest
  def setup
    @provider_account, plan = create_provider_account

    @provider_account.settings.allow_finance! unless @provider_account.settings.finance.allowed?
    @provider_account.settings.show_finance! unless @provider_account.settings.finance.visible?

    @buyer_account = Factory(:buyer_account, :provider_account => @provider_account)
    @buyer_account.buy!(plan)
    host! @provider_account.domain
  end

  test "navigate to the correct link" do

    login_with @buyer_account.admins.first.username, 'supersecret'
    get "/admin/account/"

    # active_merchant sets type to bogus and don't know how to change it
    details_url = "/admin/account/payment_express"
     # click_link "Credit Card Details"
     assert_select('a[href=?]', details_url)
  end

  def create_provider_account
    provider_account = Factory(:provider_with_billing, :payment_gateway_type => :payment_express, :payment_gateway_options => {:login => 'foo', :password => 'bar'})
    provider_account.billing_strategy = Factory(:postpaid_with_charging)

    plan = Factory(:application_plan, :issuer => provider_account.default_service)

    [provider_account, plan]
  end
end
