require 'test_helper'

class HerokuSSOTest < ActionDispatch::IntegrationTest

  disable_transactional_fixtures!

  def setup

    @partner = FactoryGirl.create(:partner, system_name: 'heroku', name: 'Heroku')
    service = master_account.default_service
    application_plan = service.application_plans.create(name: 'blabla', partner: @partner)
    @provider = FactoryGirl.create(:provider_account, partner: @partner)
    settings = @provider.settings
    settings.heroku_name = 'foo'
    settings.heroku_id = 'bar'
    settings.save
    @provider.application_contracts.delete_all

    @provider.buy!(application_plan, name: 'Default', description: 'Default')
    host! @provider.admin_domain
  end

  test 'should be redirected to heroku_sso' do
    get admin_buyers_accounts_path
    assert_equal admin_buyers_accounts_path, session[:return_to]
    assert_equal "https://api.heroku.com/myapps/foo/addons/#{Heroku.addon_name}?return_to=#{admin_buyers_accounts_path}", response.location
  end

end
