require 'test_helper'

class DeveloperPortal::SignupTest < ActionDispatch::IntegrationTest
  include DeveloperPortal::Engine.routes.url_helpers

  def setup
    @provider = FactoryGirl.create(:provider_account)

    host! @provider.domain
  end

  def test_create
    post signup_path(account: {
      promo_code: '12345',
      org_name:   'alaska',
      user: {
        email:    'aleks@alaska.com',
        username: 'supertramp',
        password: 'westisthebest'
      }
    })
    assert_response :redirect
  end

  def test_show
    get signup_path

    assert_response :success

    get signup_path, plan_ids: ''

    assert_response :success

    get signup_path, plan_ids: nil

    assert_response :success

    get signup_path, plan_ids: []

    assert_response :success

    plan_id = @provider.provided_plans.published.first.id

    get signup_path, plan_ids: plan_id

    assert_response :success

    get signup_path, plan_ids: Array(plan_id)

    assert_response :success
  end
end
