require 'test_helper'

class DeveloperPortal::Admin::Applications::LogRequestsControllerTest < DeveloperPortal::ActionController::TestCase
  include TestHelpers::BackendClientStubs

  def setup
    @application = FactoryGirl.create(:cinstance)
    provider = @application.service.provider
    provider.settings.allow_log_requests!
    provider.settings.show_log_requests
    service = @application.service
    service.buyer_can_see_log_requests = true
    service.save!

    login_buyer @application.buyer
  end

  # regression test for https://github.com/3scale/system/pull/147
  def test_index
    stubbed_data = [{
        code: 200,
        request: 'a fake request',
        response: 'a fake response',
        app_id: @application.id,
        service_id: @application.service.id,
        usage: 'some usage',
        timestamp: 'some timesamp'
    }]

    stub_backend_get_application_log_requests(stubbed_data)

    get :index, application_id: @application.id

    assert_response :success

    expected_values = [
        stubbed_data.first[:timestamp],
        stubbed_data.first[:code],
        stubbed_data.first[:request],
        stubbed_data.first[:response]
    ]
    selector = '.log-request-transaction-table tbody'

    assert_select selector do |elements|
      elements.each_with_index do |element, i|
        assert_select element, 'td:last-child', expected_values[i]
      end
    end
  end
end
