require 'test_helper'

class Buyers::LogRequestsControllerTest < ActionController::TestCase

  setup do
    @provider= FactoryGirl.create(:provider_account)
    @request.host = master_account.domain
    login_provider master_account
    @cinstance = @provider.bought_cinstances.first
    Buyers::LogRequestsController.any_instance.expects(:authorize_log_requests).returns(true)
  end

  test "should render index and no_log_requests" do
    backend_object = stub(:backend_object)
    backend_object.expects(:log_requests).returns([])
    Cinstance.any_instance.expects(:backend_object).returns(backend_object)
    get :index, account_id: @provider.id, application_id: @cinstance.id

    assert_template "index"
    assert_template "_no_log_requests"
  end

  test "should render cubert_logs and no_log_requests" do
    @cinstance.service.create_cubert_info
    CubertRequestLogsService.any_instance.expects(:get_list).returns([])
    get :index, account_id: @provider.id, application_id: @cinstance.id
    assert_template "cubert_logs"
    assert_template "_no_log_requests"
  end

  test 'using cubert' do
    @cinstance.service.create_cubert_info
    CubertRequestLogsService.any_instance
        .expects(:get_list)
        .with({'log' => {'code' => '200'},
               'application_id' => @cinstance.application_id,
               'timestamp' => {'$lte' => '1'}},
              {:page => 1, :per_page => 20, :sort => {'timestamp' => 'desc'}})
        .returns([])

    get :index, account_id: @provider.id, application_id: @cinstance.id,
                search: { code: 200, timestamp: { '$lte' => 1 }}
    assert_response :success
  end

end
